#= Template File for "Config.mk", build configuration of dcpam (autoconf)
#
# Authors::   Yasuhiro MORIKAWA, Masaki ISHIWATARI
# Version::   $Id: Config.mk.in,v 1.16 2009-03-26 08:45:27 morikawa Exp $
# Tag Name::  $Name: dcpam5-20090405 $
# Copyright:: Copyright (C) GFD Dennou Club, 2004-2005. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file is template file to create "Config.mk" by
# autoconf 2.59. Some functions are defined in "aclocal.m4"
# (for example, DC_ARG_WITH).
#
# [JAPANESE]
# Υե Makefile ƤӽФե "Config.mk"
# οեǤ. configure ץȤˤäƤΥե
#  (@ ǰϤޤ줿ѿ) ֤, "Config.mk" ޤ.
# configure  configure.in  aclocal.m4  autoconf ޥɤ
# Ѥ뤳Ȥޤ.
#
############################################################

############################################################
#== for Debian install
#
# [JAPANESE] Debian 󥹥ȡ
#
DESTDIR = 

############################################################
#== Fortran Compiler
#
# [JAPANESE] Fortran ѥ
#
FC=frt

# Flags needed when compiled and linked
# [JAPANESE] ѥ󥯻ɬפʥե饰
SYSFFLAGS=-Am  -I/home/noda/local/spml-ffc/include -I/home/noda/local/gtool5-ffc/include 

# Flags needed when linked
# [JAPANESE] 󥯻ɬפʥե饰
SYSLDFLAGS= -L/home/noda/local/spml-ffc/lib -L/home/noda/local/gtool5-ffc/lib -L/home/noda/local/netcdf-ffc/lib -L/home/noda/local/lib 

# Libraries needed when linked
# [JAPANESE] 󥯻ɬפʥ饤֥
SYSLDLIBS= -lspml-fftw2-ssl2 -lgtool5 -lnetcdf -lisp-ffc 

# Flags for C preprocessor
# [JAPANESE] CץץåΥե饰
CPPFLAGS=
###CPPFLAGS=-DLIB_SATURATE_NHA1992 -DLIB_SATURATE_T1930

# MPI executable command
#   + an option for number of nodes + an option for number of processes
# [JAPANESE] MPI ¹ԥޥ
#              + Ρɿꥪץ + ץꥪץ
MPIEXEC=
MPIEXECPROCOPT=
MPIEXECNODEOPT=

# Linker which includes flags
# [JAPANESE] 󥫥ޥ
LINKF=$(FC) $(FFLAGS) $(SYSFFLAGS) $(INCLUDES)

# Host type
# [JAPANESE] ۥȥƥΥ
HOST_CPU=x86_64

# Cross-compile
# [JAPANESE] ѥ
CROSS_COMPILING=no

# Information of Modules (std.mod, HP.mod, fqs.mod, intel.d, hitachi.f90)
# [JAPANESE] ⥸塼Ϥ
F90MODTYPE=fqs.mod

# Flag for module files search path
# [JAPANESE] ⥸塼եؤΥѥꤹ뤿Υե饰
MODPATHFLAG=-I

#
# Extensions of Module Files used when "make clean"
# * if "F90MODTYPE = hitachi.f90", clean nothing.
#
# [JAPANESE]
# make clean ˻Ѥ⥸塼ե
# (F90MODTYPE = hitachi.f90 ΤȤϲäƤϤʤʤ)
#
CLEAN_MODS=*.mod
MODSUFFIX=.mod
MODFILE=`basename $@ .o`$(MODSUFFIX)

############################################################
#== library name lib$(LIBNAME).a
#
# [JAPANESE] 饤֥̾ lib$(LIBNAME).a
#
LIBNAME		= dcpam5
DCPAMLIB	= lib$(LIBNAME).a

############################################################
#== Directory to which the all files are archived
#
# DIRDEPTH is set in each Makefile
#
# [JAPANESE] ֤ԤΥǥ쥯ȥ
#
# DIRDEPTH ϳ Makefile ꤵޤ. 
#
MODDIR		= $(DIRDEPTH)/include
LIBDIR		= $(DIRDEPTH)/lib
BINDIR		= $(DIRDEPTH)/bin
DOCDIR		= $(DIRDEPTH)/doc

############################################################
#== Directory to which the all files are installed
#
# [JAPANESE] 󥹥ȡΥǥ쥯ȥ
#
prefix		= /home/noda/local/spml-ffc
exec_prefix	= ${prefix}
dcpam_bin_suffix= 

INSTMODDIR	= $(DESTDIR)${prefix}/include
INSTLIBDIR	= $(DESTDIR)${exec_prefix}/lib
INSTBINDIR	= $(DESTDIR)${exec_prefix}/bin
INSTDOCDIR	= $(DESTDIR)${prefix}/doc
INSTSHAREDIR	= $(DESTDIR)${prefix}/share

############################################################
#== URL of COPYRIGHT (for latex2html)
#
# [JAPANESE] COPYRIGHT  URL (latex2html ǻ).
#
COPYRIGHTURL	=http://www.gfd-dennou.org/library/dcpam/dcpam5/dcpam5\\\\_current/COPYRIGHT

############################################################
#== Tools for build
#
# [JAPANESE] ӥѤΥġ
#
RUBY		= /usr/bin/ruby   # Ruby 1.8 or more
PERL		= /usr/bin/perl
SH		= /bin/bash
SCRIPTDIR	= $(DIRDEPTH)/script
SCRIPTF90	= $(SCRIPTDIR)/f90
SCRIPTLATEX2HTML= $(SCRIPTDIR)/latex2html
F90DEPEND	= $(RUBY) $(SCRIPTF90)/f90depend.rb
F90DEPENDOPTS	= -q #-S -v
CVSTAG2LATEX	= $(SCRIPTDIR)/rd/cvstag2latex.rb

############################################################
#== Settings for test
#
# [JAPANESE] ƥ
#
TESTLOG		= xtest.log

############################################################
#== Set Commands for compile and install source code
#
# Please edit according to your system.
#
# [JAPANESE] ѥ䥤󥹥ȡɬפʥޥɷ
#
# ƥ˹碌ѹƤ.
#
MV         = mv -f
CP         = cp -p
SH         = sh
INSTALL    = install -m 644
INSTALLBIN = install -m 755
INSTALLDIR = install -d -m 755
MKDIR      = mkdir -p
DIRNAME    = dirname
BASENAME   = basename
TOUCH      = touch
RM         = rm -fv
RMDIR      = rmdir -v
GUNZIP     = gunzip     # decompression  (equal to "gzip -d")
TEE        = tee        # tee command
MAKE       = make     # GNU Make
AR         = ar       # AR : Library builder specification
ARFLAGS    = cru  # flags of AR
RANLIB     = ranlib   # generate index to archivea
NCDUMP     = ncdump   # netCDF file dump command

############################################################
#== Set Commands for development
#
# [JAPANESE] ȯѤݤΥޥ
#
TAGS		= etags --regex='/\ *module.*\|\ *interface.*\|\ *type\ .*\|\ *function\ .*\|\ *MODULE.*\|\ *INTERFACE.*\|\ *TYPE\ .*\|\ *FUNCTION\ .*/'


############################################################
#== Path to CSS etc
#
# [JAPANESE] 륷ȥեʤɤؤΥѥ
#
CSSPATH		= $(DIRDEPTH)/htmltools/dcpam.css
EMAIL_PNG	= $(DIRDEPTH)/htmltools/dcstaff_email.png


############################################################
#== Set Commands for documentations
#
# [JAPANESE] ɥɬפʥޥ
#
RD2		= rd2      # for Generation RD documents
RDOC		= rdoc     # for Generation RDOC documents
RDOCOPTS	= -U --title "dcpam5 Reference Manual" \
		  --charset euc-jp --inline-source --ignore-case --all
JLATEX		= platex   # for Generation DVI documents
DVI2PDF		= dvipdfmx # for Generation PDF documents
DVI2JPS		= dvi2ps   # for Generation PS documents
LPR		= lpr -s   # for Print out

#=== latex2html_jp for Dennou.sty
#
# latex2html_jp+dennou is available from
# http://www.gfd-dennou.org/arch/cc-env/latex2html/SIGEN.htm
#
# [JAPANESE] latex2html_jp+dennnou Ѥݤɬפ
#
# latex2html_jp+dennou ϰʲ URL Ǥޤ.
# http://www.gfd-dennou.org/arch/cc-env/latex2html/SIGEN.htm
#
LATEX2HTML = latex2html
LATEX2HTMLOPTIONS = $(LATEX2HTMLDEBUG) \
	-init_file $(SCRIPTLATEX2HTML)/latex2html-init.pl \
	-no_footnode -local_icons -short_extn \
	-bottom_navigation -no_contents_in_navigation -no_auto_link \
	-up_url $(HREFTOPDIR)/index.htm -up_title $(HREFTOPDIRNAME) \
	-split 3 -show_section_numbers -dir $(TARGETHTMDIR) 
