!= ɽ̲٥ꥹȥǡ, ͥǡ
!
!= Restart data, initial data of surface temperature input/output
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: restart_surftemp_io.f90,v 1.5 2010-12-18 12:54:43 yot Exp $
! Tag Name::  $Name: dcpam5-20110407 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module restart_surftemp_io
  !
  != ɽ̲٥ꥹȥǡ, ͥǡ
  !
  != Restart data, initial data of surface temperature input/output
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̲٤Υꥹȥǡ⤷ϽͥǡϤԤޤ. 
  ! ϥե, ϥե, ǡνϤδֳ֤
  ! NAMELIST#restart_surftemp_io_nml ꤷޤ. 
  !
  ! ꥹȥǡϥե뤬ꤵʤ, 
  ! surface_data ⥸塼줿ͥǡޤ. 
  !
  ! Restart data or initial data is input/output. 
  ! Settings of input file, output file, and interval of data output 
  ! is configured by "NAMELIST#restart_surftemp_io_nml". 
  !
  ! If input file of restart data is not set, 
  ! initial data is generated in "surface_data" module, and 
  ! obtained data from the module. 
  !
  !== Procedures List
  !
  ! RestartSurfTempOpen   :: ꥹȥեΥץ
  ! RestartSurfTempOutput :: ꥹȥեؤΥǡ
  ! RestartSurfTempClose  :: ꥹȥեΥ
  ! RestartSurfTempGet    :: ꥹȥե
  ! ------------      :: ------------
  ! RestartSurfTempOpen   :: Open restart file
  ! RestartSurfTempOutput :: Data output to restart file
  ! RestartSurfTempClose  :: Close restart file
  ! RestartSurfTempGet    :: Input restart file
  !
  !== NAMELIST
  !
  ! NAMELIST#restart_surftemp_io_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! gtool4 ǡ
  ! Gtool4 data output
  !
  use gtool_history, only: GT_HISTORY

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: RestartSurfTempOpen, RestartSurfTempClose, RestartSurfTempOutPut
  public:: RestartSurfTempGet

  ! ѿ
  ! Public variables
  !
  logical, save, public:: restart_surftemp_io_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  logical, save, public:: restart_surftemp_opened = .false.
                              ! ꥹȥեΥץ˴ؤե饰. 
                              ! Flag of restart file open

  ! ѿ
  ! Private variables
  !
  logical, save:: flag_init_data_save
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

  character(STRING), save:: InputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of input restart data
  character(TOKEN), save:: InputName
                              ! Ϥꥹȥǡѿ̾
                              ! Variable name of input restart data

  character(STRING), save:: OutputFile
                              ! ϤꥹȥǡΥե̾
                              ! Filename of output restart data
  real(DP), save:: IntValue
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output
  character(TOKEN):: IntUnit
                              ! ꥹȥǡνϴֳ֤ñ. 
                              ! Unit for interval of restart data output

  type(GT_HISTORY), save:: gthst_rst
                              ! ꥹȥǡ gtool_history#GT_HISTORY ѿ
                              ! "gtool_history#GT_HISTORY" variable for restart data

  real(DP), save:: PrevOutputTime
                              ! νϻ. 
                              ! Previous output time
  logical, save:: flag_output_end
                              ! ׻ǽνϴλΥե饰. 
                              ! Flag for completion of output at the end time of calculation

  real(DP), save:: IntTime
                              ! ꥹȥǡνϻ. 
                              ! Time interval of restart data output

  character(*), parameter:: time_name = 'time'
                              ! μѿ̾
                              ! Variable name of time dimension
  character(*), parameter:: deltime_name = 'deltime'
                              ! t ѿ̾
                              ! Variable name of Delta t


  character(*), parameter:: module_name = 'restart_surftemp_io'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110407 $' // &
    & '$Id: restart_surftemp_io.f90,v 1.5 2010-12-18 12:54:43 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine RestartSurfTempOpen( flag_init_data )
    !
    ! ꥹȥե򥪡ץ󤷤ޤ. 
    !
    ! A restart file is opened. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ϥեδܾ
    ! Basic information for output files
    ! 
    use fileset, only: &
      & FileTitle, &
                              ! ϥǡեɽ.
                              ! Title of output data files
      & FileSource, &
                              ! ǡեμ. 
                              ! Source of data file
      & FileInstitution
                              ! ǡեǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes data files for the last time

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI   ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & RestartTime           ! ꥹȳϻ. 
                              ! Retart time of calculation

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryCreate, HistoryAddVariable, &
      & HistoryPut, HistoryAddAttr

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA, CPrintf, LChar

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    logical, intent(in), optional:: flag_init_data
                              ! ͥǡ, 
                              ! ΰ .true. Ϳޤ. 
                              ! 
                              ! If initial data is created, 
                              ! give ".true." to this argument. 

    ! ѿ
    ! Work variables
    !
    character(STRING):: title_msg
                              ! ɽղäå. 
                              ! Message added to title
    real(DP):: origin_time
                              ! ׻ϻ. 
                              ! Start time of calculation
    character(STRING):: time_unit
                              ! ñ. Units of date and time

    logical:: flag_mpi_init

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    flag_init_data_save = present_and_true( flag_init_data )
    if ( .not. restart_surftemp_io_inited ) call RestartSurfTempInit
    if ( restart_surftemp_opened ) return

    ! ɽղäå
    ! Configure message added to title
    !
    if ( .not. flag_init_data_save ) then
      title_msg = ' restart data of surface temperature'
    else
      title_msg = ' initial data of surface temperature'
    end if

    ! μ
    ! Get time information
    !
    if ( .not. flag_init_data_save ) then
      origin_time = RestartTime + IntTime
    else
      origin_time = RestartTime
    end if

    time_unit = IntUnit

    flag_mpi_init = .true.

    ! ꥹȥեΥץ
    ! Open a restart file
    !
    call HistoryCreate( &
      &      file = OutputFile,   &
      &     title = trim(FileTitle) // trim(title_msg), &          ! (in)
      &    source = FileSource, institution = FileInstitution, &   ! (in)
      &      dims = StoA( 'lon', 'lat', time_name ), &             ! (in)
      &  dimsizes = (/ imax, jmax, 0 /), &                         ! (in)
      & longnames = StoA( 'longitude', 'latitude', time_name ), &  ! (in)
      &     units = StoA( 'degree_east', 'degree_north', &
      &                    time_unit ), &                          ! (in)
      &        origind = origin_time, &       ! (in) optional
      &      intervald = IntValue, &          ! (in) optional
      & flag_mpi_split = flag_mpi_init, &     ! (in) optional
      &        history = gthst_rst )          ! (out) optional

    ! ɸǡ
    ! Axes data settings
    !
    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'standard_name', &   ! (in)
      & value = 'longitude', &                           ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'standard_name', &   ! (in)
      & value = 'latitude', &                            ! (in)
      & history = gthst_rst )                            ! (inout)
    call HistoryAddAttr( &
      & varname = time_name, attrname = 'standard_name', &  ! (in)
      & value = 'time', &                                ! (in)
      & history = gthst_rst )                            ! (inout)

    call HistoryPut( &
      & varname = 'lon', &               ! (in)
      & array = x_Lon / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )            ! (inout)
    call HistoryPut( &
      & varname = 'lat', &               ! (in)
      & array = y_Lat / PI * 180.0_DP, & ! (in)
      & history = gthst_rst )            ! (inout)

    ! ɸŤߤ
    ! Axes weights settings
    !
    call HistoryAddVariable( &
      & varname = 'lon_weight', &                           ! (in)
      & dims = StoA('lon'), &                               ! (in)
      & longname = 'weight for integration in longitude', & ! (in)
      & units = 'radian', xtype = 'double', &               ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight', &                             ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryPut( &
      & varname = 'lon_weight', array = x_Lon_Weight, &     ! (in)
      & history = gthst_rst )                               ! (inout)

    call HistoryAddVariable( &
      & varname = 'lat_weight', &                           ! (in)
      & dims = StoA('lat'), &                               ! (in)
      & longname = 'weight for integration in latitude', &  ! (in)
      & units = 'radian', xtype = 'double', &               ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight', &                             ! (in)
      & history = gthst_rst )                               ! (inout)
    call HistoryPut( &
      & varname = 'lat_weight', array = y_Lat_Weight, &     ! (in)
      & history = gthst_rst )                               ! (inout)

    ! ͽѿ
    ! Predictional variables settings
    !
    call HistoryAddVariable( &
      & varname = 'SurfTemp', &                   ! (in)
      & dims = StoA('lon', 'lat', time_name), &   ! (in)
      & longname = 'surface temperature', &       ! (in)
      & units = 'K', xtype = 'double', &          ! (in)
      & history = gthst_rst )                     ! (inout)

    restart_surftemp_opened = .true.
  end subroutine RestartSurfTempOpen

  !-------------------------------------------------------------------

  subroutine RestartSurfTempOutput( &
    & xy_SurfTemp &   ! (in)
    & )
    !
    ! ꥹȥǡνϤԤޤ. 
    !
    ! Output restart data

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryPut, HistorySetTime

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
      & EndTime               ! ׻λ. 
                              ! End time of calculation

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_true

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    logical:: flag_output
                              ! ϤΥե饰. 
                              ! Flag for output

    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_surftemp_opened ) call RestartSurfTempOpen

    ! ϥߥ󥰤Υå
    ! Check output timing
    !
    flag_output = TimeN - PrevOutputTime >= IntTime
    if ( TimeN >= EndTime .and. .not. flag_output_end ) then
      flag_output = .true.
      flag_output_end = .true.
    end if
    flag_output = ( .not. TimeN == PrevOutputTime ) .and. flag_output
    flag_output = flag_init_data_save .or. flag_output

    if ( .not. flag_output ) return

    ! Ѥ, ν (˾)  ¸
    ! Save output time (expected) in this time, for next time
    !
    PrevOutputTime = PrevOutputTime + IntTime

    ! 
    ! Set time
    !
    call HistorySetTime( timed = TimeN, history = gthst_rst )

    ! ǡ
    ! Data output
    !
    call HistoryPut( &
      & 'SurfTemp', xy_SurfTemp, history = gthst_rst ) ! (in)

  end subroutine RestartSurfTempOutput

  !-------------------------------------------------------------------

  subroutine RestartSurfTempClose
    !
    ! ꥹȥǡեϤνλԤޤ. 
    !
    ! Terminate restart data files output. 

    ! ⥸塼 ; USE statements
    !

    ! gtool4 ǡ
    ! Gtool4 data output
    !
    use gtool_history, only: HistoryClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !
    if ( .not. restart_surftemp_opened ) return

    call HistoryClose( history = gthst_rst ) ! (inout)

    restart_surftemp_opened = .false.
  end subroutine RestartSurfTempClose

  !-------------------------------------------------------------------

  subroutine RestartSurfTempGet( &
    & xy_SurfTemp &                 ! (out)
    & )
    !
    ! ꥹȥǡϤԤޤ. 
    ! ꥹȥǡ¸ߤʤˤ, 
    ! surface_data ⥸塼Ѥ, ɽ̲٥ǡԤޤ. 
    !
    ! Input restart data. 
    ! If restart data is not exist, 
    ! surface temperature data is created by "surface_data". 


    ! ⥸塼 ; USE statements
    !

    ! ɽ̥ǡ
    ! Prepare surface data
    !
    use surface_data, only: SetSurfData

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime           ! ꥹȳϻ. 
                              ! Retart time of calculation

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ʸ
    ! Character handling
    !
    use dc_string, only: toChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    character(TOKEN):: time_range
                              ! λ. 
                              ! Specification of time
    logical:: flag_mpi_init

    ! ¹ʸ ; Executable statement
    !

    if ( .not. restart_surftemp_io_inited ) call RestartSurfTempInit

    ! ǡ surface_data ⥸塼뤫
    ! Data is input from "surface_data" module
    ! 
    if ( trim(InputFile) == '' .or. trim(InputName) == '' ) then
      call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional

    ! ǡ InputFile 
    ! Data is input from InputFile
    ! 
    else

      ! μ
      ! Get time information
      !
      time_range = time_name // '=' // toChar( RestartTime )

!!$      flag_mpi_init = .false.
      flag_mpi_init = .true.

      ! ǡ
      ! Data input
      ! 
      call HistoryGet( &
        & InputFile, InputName, range = time_range, &  ! (in)
        & array = xy_SurfTemp, &                       ! (out)
        & flag_mpi_split = flag_mpi_init )             ! (in) optional

    end if

  end subroutine RestartSurfTempGet

  !-------------------------------------------------------------------

  subroutine RestartSurfTempInit
    !
    ! restart_surftemp_io ⥸塼νԤޤ. 
    ! NAMELIST#restart_surftemp_io_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "restart_surftemp_io" module is initialized. 
    ! "NAMELIST#restart_surftemp_io_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: restart_file_io_inited, &
      & RestartFileIntValue => IntValue, &
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output
      & RestartFileIntUnit  => IntUnit
                              ! ꥹȥǡνϴֳ֤ñ. 
                              ! Unit for interval of restart data output

    ! 
    ! Time control
    !
    use timeset, only: &
      & RestartTime           ! ꥹȳϻ. 
                              ! Retart time of calculation

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! μ갷
    ! Calendar and Date handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /restart_surftemp_io_nml/ &
      & InputFile, &
      & InputName, &
      & OutputFile, &
      & IntValue, IntUnit
          !
          ! ǥեͤˤĤƤϽ³ "restart_surftemp_io#RestartSurfTempInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "restart_surftemp_io#RestartSurfTempInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( restart_surftemp_io_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    InputFile  = ''
    InputName  = 'SurfTemp'
    if ( .not. flag_init_data_save ) then
      OutputFile = 'rst_sst.nc'
    else
      OutputFile = 'sst.nc'
    end if

    if ( restart_file_io_inited ) then
      IntValue   = RestartFileIntValue
      IntUnit    = RestartFileIntUnit
    else
      IntValue   = 1.0
      IntUnit    = 'day'
    end if

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = restart_surftemp_io_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = restart_surftemp_io_nml )
    end if

    ! ϻֳִ֤
    ! Configure time interval of output
    !
    IntTime = DCCalConvertByUnit( IntValue, IntUnit, 'sec' ) ! (in)
    PrevOutputTime = RestartTime

    ! ե饰ν
    ! Initialize flag
    !
    flag_output_end = .false.


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'Input:: ' )
    call MessageNotify( 'M', module_name, '  InputFile  = %c', c1 = trim(InputFile) )
    call MessageNotify( 'M', module_name, '  InputName  = %c', c1 = trim(InputName) )
    call MessageNotify( 'M', module_name, 'Output:: ' )
    call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim(OutputFile) )
    call MessageNotify( 'M', module_name, '  IntTime    = %f [%c]', d = (/ IntValue /), c1 = trim(IntUnit) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    restart_surftemp_io_inited = .true.
  end subroutine RestartSurfTempInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ϥեδܾ
    ! Management basic information for output files
    !
    use fileset, only: fileset_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. fileset_inited ) &
      & call MessageNotify( 'E', module_name, '"fileset" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )


  end subroutine InitCheck

end module restart_surftemp_io
