!= dcpam ץ
!
!= dcpam main program
!
! Authors::   Yasuhiro MORIKAWA, Satoshi Noda, Yoshiyuki O. TAKAHASHI
! Version::   $Id: dcpam_main.f90,v 1.21 2011-03-27 02:22:20 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110407 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2010. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program dcpam_main
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ǥλȤˤĤƤ {塼ȥꥢ}[link:../../../doc/tutorial/rakuraku/] 
  ! ȤƤ.
  !
  ! See {Tutorial}[link:../../../doc/tutorial/rakuraku/index.htm.en] for usage of the 
  ! model. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
  !
  use dynamics_hspl_vas83, only: Dynamics

  ! ʪΤߤη׻Τϳز
  ! A dynamics for calculation with physical processes only
  !
  use dynamics_physicsonly, only: DynamicsPhysicsOnly

  ! Held and Suarez (1994) ˤ붯Ȼ
  ! Forcing and dissipation suggested by Held and Suarez (1994)
  !
  use held_suarez_1994, only: HS94Forcing

  ! ñ׻Τζ
  ! forcing for simple Venus calculation
  !
  use yt2003_forcing, only: YT2003Forcing

  ! Schneider and Liu (2009) ˤľ
  ! Vertical diffusion by Schneider and Liu (2009)
  !
  use sl09_diffusion, only : SL09Diffusion

  ! ͥեå (GFD Ǿȯͥǥ)
  ! Radiation flux (radiation model developed by GFD Dennou Club)
  !
  use rad_DennouAGCM, only: RadDennouAGCMFlux

  ! ʹϢ롼
  ! Routines for radiation calculation
  !
  use rad_utils, only : RadDTempDt, RadFluxOutput

  use rad_dcpam_E_V2, only: RadDcpamEV2Flux

  ! dcpam 絤ͥǥ Ver. 1
  ! dcpam radiation model for the Mars' atmosphere Ver. 1
  !
  use rad_dcpam_M_V1, only: RadDcpamMV1Flux

  ! ׻ѶֳǮΨ׻
  ! Calculation of near infrared heating rate in the case of Mars
  !
  use rad_dcpam_M_NIR, only : RadDcpamMNIRINOUT

  ! Schneider and Liu (2009) ͥǥ
  ! Radiation model by Schneider and Liu (2009)
  !
  use rad_SL09, only : RadSL09Flux

  ! ľȻեå (Mellor and Yamada, 1974, ٥ 2)
  ! Vertical diffusion flux (Mellor and Yamada, 1974, Level 2)
  !
  use vdiffusion_my1974, only: VDiffusion, VDiffusionOutput

  ! ϲˤǮαľȻ
  ! Vertical diffusion of heat under the ground
  !
  use subsurface_diffusion_heat, only: SubsurfaceDiffusion

  ! ѱѥ᥿ꥼ (ήĴ)
  ! Cumulus parameterization (convection adjust)
  !
  use moist_conv_adjust, only: MoistConvAdjust

  ! 絬϶ŷ
  ! Large scale condensation
  !
  use lscond, only: LScaleCond

  ! ɽ̥եå
  ! Surface flux
  use surface_flux_bulk, only: SurfaceFlux, SurfaceFluxOutput

  ! ήĴ
  ! Dry convective adjustment
  !
  use dry_conv_adjust, only: DryConvAdjust

  ! ̤
  ! Mass fixer
  !
  use mass_fixer, only: MassFixer

  ! ٤Ⱦҥ٥, ȹ٤λ
  ! Interpolate temperature on half sigma level, 
  ! and calculate pressure and height
  !
  use auxiliary, only: AuxVars

  ! ˡˤʬΤΥ롼
  ! Routines for time integration with implicit scheme
  !
  use phy_implicit_utils, only : PhyImplEvalRadLFluxA

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit, only: PhyImplTendency

  ! ˡΤι (ʪ)
  ! Matrices handling for implicit scheme (for a part of physical processes)
  !
  use phy_implicit_sdh, only: PhyImplSDHTendency

  ! ˡˤʬ (絤Τ / ɽ̲١ھٷ׻ʤ)
  ! Time integration by using implicit scheme in case without calculation of surface and soil temperature
  !
  use phy_implicit_atmonly, only : PhyImplAtmOnlyTendency

  ! ̲٤λʬɽ
  ! Time integration of surface temperature, correction of flux on surface
  !
  use intg_surftemp, only: IntegralSurfTemp

  ! Хĥǥ
  ! Bucket model
  !
  use Bucket_Model, only : BucketModQvapFlux, BucketIntegration, BucketPRCPAdjust

  ! ľե륿 (Ishiwatari et al., 2002)
  ! Vertical filter (Ishiwatari et al., 2002)
  !
  use vertical_filter, only: VerticalFilter

  ! ե륿 (Asselin, 1972)
  ! Time filter (Asselin, 1972)
  !
  use timefilter_asselin1972, only: TimeFilter, TimeFilterSurfVars

  ! 
  ! Time control
  !
  use timeset, only: TimesetProgress, &
    & TimeB, &                ! ƥå $ t - \Delta t $ λ. 
                              ! Time of step $ t - \Delta t $. 
    & TimeN, &                ! ƥå $ t $ λ. 
                              ! Time of step $ t $. 
    & TimeA, &                ! ƥå $ t + \Delta t $ λ. 
                              ! Time of step $ t + \Delta t $. 
    & EndTime, &              ! ׻λ. 
                              ! End time of calculation
    & DelTime                 ! $ \Delta t $ [s]

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutPut

  ! ɽ
  ! Setting of surface properties
  !
  use surface_properties, only: SetSurfaceProperties

  ! ҥȥǡ
  ! History data output
  !
  use gtool_historyauto, only: HistoryAutoPut, HistoryAutoAllVarFix

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax, &
                              ! ʬο
                              ! Number of composition
    &                    a_QMixName, &
                              ! ʬѿ̾
                              ! Name of variables for composition
    &                    a_QMixLongName, &
                              ! ʬĹѿ̾
                              ! Long name of variables for composition
    &                    IndexH2OVap, &
    &                    CompositionInqIndex


  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, &  ! ٳʻ. 
                              ! Number of grid points in longitude
    &                jmax, &  ! ٳʻ. 
                              ! Number of grid points in latitude
    &                kmax     ! ľؿ. 
                              ! Number of vertical level

  ! ʪ
  ! Physical constants settings
  !
  use constants, only: LatentHeat

  !
  !
  use dc_message, only: MessageNotify

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  use set_cloud, only:                 &
    & SetCloudCloudWaterLossRateInOut, &
    & SetCloudRegDQCloudWaterDt


  ! CO2 Ѳ (׻)
  ! Phase change of CO2 (for the use in Mars calculation)
  !
  use co2_phase_change, only : CO2PhaseChangeLimitTemp

  ! ͽѿͤγǧ
  ! Check values of prognostic variables
  !
  use check_prog_vars, only: CheckProgVars

  ! ʸ ; Declaration statements
  !
  implicit none

  character(*), parameter:: prog_name = 'dcpam_main'
                            ! ץ̾. 
                            ! Main program name

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .   . Temperature (K)
  real(DP), allocatable:: xyzf_QMixB(:,:,:,:)
                              ! $ q (t-\Delta t) $ .   . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure (Pa)
  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ u (t) $ .     ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ v (t) $ .     ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature (K)
  real(DP), allocatable:: xyzf_QMixN(:,:,:,:)
                              ! $ q (t) $ .     . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure (Pa)
  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind (m s-1)
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind (m s-1)
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .   . Temperature (K)
  real(DP), allocatable:: xyzf_QMixA(:,:,:,:)
                              ! $ q (t+\Delta t) $ .   . Mass mixing ratio of constituents (1)
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure (Pa)

  real(DP), allocatable:: xy_SoilMoistB (:,:)
                              ! $ M_ws (t-\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowB (:,:)
                              ! $ M_ss (t-\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
  real(DP), allocatable:: xy_SoilMoistN (:,:)
                              ! $ M_ws (t) $          . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowN (:,:)
                              ! $ M_ss (t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)
  real(DP), allocatable:: xy_SoilMoistA (:,:)
                              ! $ M_ws (t+\Delta t) $ . ھʬ (kg m-2)
                              ! Soil moisture (kg m-2)
  real(DP), allocatable:: xy_SurfSnowA (:,:)
                              ! $ M_ss (t+\Delta t) $ .  (kg m-2)
                              ! Surface snow amount (kg m-2)


  ! ѿ, ¾
  ! Diagnostic variables, etc.
  !
  real(DP), allocatable:: xyz_DUDt (:,:,:)
                              ! $ \DP{u}{t} $ . ®Ѳ (m s-2)
                              ! Eastward wind tendency (m s-2)
  real(DP), allocatable:: xyz_DVDt (:,:,:)
                              ! $ \DP{v}{t} $ . ®Ѳ (m s-2)
                              ! Northward wind tendency (m s-2)
  real(DP), allocatable:: xyz_DTempDt (:,:,:)
                              ! $ \DP{T}{t} $ . Ѳ (K s-1)
                              ! Temperature tendency (K s-1)
  real(DP), allocatable:: xyzf_DQMixDt(:,:,:,:)
                              ! $ \DP{q}{t} $ . Ѳ (s-1)
                              ! Mass mixing ratio tendency (s-1)

  real(DP), allocatable:: xy_SurfHeight (:,:)
                              ! $ z_s $ . ɽ̹ (m)
                              ! Surface height (m)

  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲ (K)
                              ! Surface temperature (K)
  real(DP), allocatable:: xyz_SoilTemp(:,:,:)
                              ! ھ (K)
                              ! Soil temperature (K)


  real(DP), allocatable:: xy_SurfAlbedo (:,:)
                              ! ɽ٥ (1)
                              ! Surface albedo (1)
  real(DP), allocatable:: xy_SurfHumidCoef (:,:)
                              ! ɽ (1)
                              ! Surface humidity coefficient (1)
  real(DP), allocatable:: xy_SurfRoughLength (:,:)
                              ! ɽĹ (m)
                              ! Surface rough length (m)
  real(DP), allocatable:: xy_SurfHeatCapacity (:,:)
                              ! ɽǮ (J m-2 K-1)
                              ! Surface heat capacity (J m-2 K-1)
  real(DP), allocatable:: xy_SeaIceConc(:,:)
                              ! ɹ̩ (0 <= xy_SeaIceConc <= 1) (1)
                              ! Sea ice concentration (0 <= xy_SeaIceConc <= 1) (1)
  integer , allocatable:: xy_SurfCond (:,:)
                              ! ɽ (0: , 1: ) (1)
                              ! Surface condition (0: fixed, 1: variable) (1)
  real(DP), allocatable:: xy_DeepSubSurfHeatFlux (:,:)
                              ! Ǯեå (W m-2)
                              ! "Deep subsurface heat flux" (W m-2)
                              ! Heat flux at the bottom of surface/soil layer.
  real(DP), allocatable:: xy_SoilHeatCap (:,:)
                              ! ھǮ (J K-1 kg-1)
                              ! Specific heat of soil (J K-1 kg-1)
  real(DP), allocatable:: xy_SoilHeatDiffCoef (:,:)
                              ! ھǮƳ (J m-3 K-1)
                              ! Heat conduction coefficient of soil (J m-3 K-1)

  real(DP), allocatable:: xyr_Temp (:,:,:)
                              ! $ \hat{T} $ .  (Ⱦ٥) (K)
                              ! Temperature (half level) (K)
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p $ .  (٥) (Pa)
                              ! Air pressure (full level) (Pa)
  real(DP), allocatable:: xyr_Press (:,:,:)
                              ! $ \hat{p} $ .  (Ⱦ٥) (Pa)
                              ! Air pressure (half level) (Pa)
  real(DP), allocatable:: xyz_Height (:,:,:)
                              !  (٥) (m)
                              ! Height (full level) (m)
  real(DP), allocatable:: xyr_Height (:,:,:)
                              !  (Ⱦ٥) (m)
                              ! Height (half level) (m)
  real(DP), allocatable:: xyz_Exner (:,:,:)
                              ! Exner ؿ (٥) (1)
                              ! Exner function (full level) (1)
  real(DP), allocatable:: xyr_Exner (:,:,:)
                              ! Exner ؿ (Ⱦ٥) (1)
                              ! Exner function (half level) (1)

  real(DP), allocatable:: xyr_RadLFlux (:,:,:)
                              ! Ĺȥեå (W m-2)
                              ! Longwave flux (W m-2)
  real(DP), allocatable:: xyr_RadLFluxA (:,:,:)
                              ! ˡǲ򤤤ɽǮ٤Ū $ t+\Delta t $ 
                              ! Ĺȥեåη׻
                              !   * Ƿ׻줿ͤľܼΥƥå $ t $ ˤ
                              !     ĹȥեåȤѤ櫓ǤϤʤ
                              !   * ߤλ֥ƥåפˤĹͲǮΨη׻˻
                              !     
                              !
                              ! Evaluate longwave flux at $ t+\Delta t $ consistent 
                              ! with surface energy balance solved with implicit method
                              !   * The evaluated value is not used directly as Longwave
                              !     flux at next step $ t $.
                              !   * The evaluated value is used to calculate long wave 
                              !     radiative heating rate in the current time step.
  real(DP), allocatable:: xyr_RadSFlux (:,:,:)
                              ! û () եå (W m-2)
                              ! Shortwave (insolation) flux (W m-2)
  real(DP), allocatable:: xyra_DelRadLFlux (:,:,:,:)
                              ! ĹɽѲ (W m-2)
                              ! Surface temperature tendency with longwave (W m-2)

  real(DP), allocatable:: xyr_MomFluxX (:,:,:)
                              ! ư̥եå
                              ! Eastward momentum flux
  real(DP), allocatable:: xyr_MomFluxY (:,:,:)
                              ! ư̥եå. 
                              ! Northward momentum flux
  real(DP), allocatable:: xyr_HeatFlux (:,:,:)
                              ! Ǯեå. 
                              ! Heat flux
  real(DP), allocatable:: xyrf_QMixFlux(:,:,:,:)
                              ! ʬ̥եå. 
                              ! Mass flux of compositions

  real(DP), allocatable:: xyr_SoilHeatFlux (:,:,:)
                              ! ھǮեå (W m-2)
                              ! Heat flux in sub-surface soil (W m-2)

  real(DP), allocatable:: xyr_VelTransCoef (:,:,:)
                              ! ͢ư. 
                              ! Transfer coefficient: velocity
  real(DP), allocatable:: xyr_TempTransCoef (:,:,:)
                              ! ͢. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xyr_QMixTransCoef(:,:,:)
                              ! ͢.
                              ! Transfer coefficient: mixing ratio

  real(DP), allocatable:: xy_SurfVelTransCoef (:,:)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
  real(DP), allocatable:: xy_SurfTempTransCoef (:,:)
                              ! ͢. 
                              ! Transfer coefficient: temperature
  real(DP), allocatable:: xy_SurfQVapTransCoef (:,:)
                              ! ͢
                              ! Transfer coefficient: water vapor
  real(DP), allocatable:: xyr_SoilTempTransCoef (:,:,:)
                              ! ͢ھ.
                              ! Transfer coefficient: soil temperature

  real(DP), allocatable:: xy_DSurfTempDt (:,:)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
  real(DP), allocatable:: xyz_DSoilTempDt (:,:,:)
                              ! $ \DP{Tg}{t} $ . ھѲ (K s-1)
                              ! Temperature tendency (K s-1)

  real(DP), allocatable:: xy_DSoilMoistDt (:,:)
                              ! ھٻѲΨ (kg m-2 s-1)
                              ! Soil temperature tendency (kg m-2 s-1)
  real(DP), allocatable:: xy_DSurfSnowDt (:,:)
                              ! ΨѲΨ (kg m-2 s-1)
                              ! Surface snow amount tendency (kg m-2 s-1)

  real(DP), allocatable:: xyz_DTempDtVDiff(:,:,:)
                              ! ľȻˤǮΨ (K s-1)
                              ! Temperature tendency due to vertical diffusion (K s-1)

  real(DP), allocatable:: xyz_DTempDtRadL (:,:,:)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with longwave
  real(DP), allocatable:: xyz_DTempDtRadS (:,:,:)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with shortwave

  real(DP), allocatable:: xy_Rain (:,:)
                              ! ߿. 
                              ! Precipitation
  real(DP), allocatable:: xyz_DTempDtCond (:,:,:)
                              ! ŷǮΨ. 
                              ! Condensation heating
  real(DP), allocatable:: xyz_DQVapDtCond (:,:,:)
                              ! ŷ漾Ѳ. 
                              ! Condensation specific humidity tendency

  real(DP), allocatable:: xyz_DDelLWDtCum(:,:,:)
                              ! Production rate of liquid water in the layer 
                              ! due to condensation in cumulus convection 
                              ! parameterization (kg m-2 s-1)
  real(DP), allocatable:: xyz_DDelLWDtLSC(:,:,:)
                              ! Production rate of liquid water in the layer 
                              ! due to condensation in large scale condensation 
                              ! (kg m-2 s-1)

  real(DP), allocatable:: xyz_DQH2OLiqDtCum(:,:,:)
                              ! Production rate of cloud water in the layer 
                              ! due to condensation in cumulus convection 
                              ! parameterization (kg kg-1)
  real(DP), allocatable:: xyz_DQH2OLiqDtLSC(:,:,:)
                              ! Production rate of cloud water in the layer 
                              ! due to condensation in large scale condensation 
                              ! (kg kg-1)


  ! ѿ
  ! Work variables
  !
  integer           :: IDDynMode                 ! Ѥϳز
                                                 ! Dynamics used for an experiment

  integer, parameter:: IDDynModeHSPLVAS83       = 0
  integer, parameter:: IDDynModeNoHorAdv        = 1

  integer           :: IDPhyMode                 ! Ѥʪ
                                                 ! Physics used for an experiment

  integer, parameter:: IDPhyModeNoPhysics     = 0
  integer, parameter:: IDPhyModeFullPhysics   = 1
  integer, parameter:: IDPhyModeHS94          = 2
  integer, parameter:: IDPhyModeVenusSimple   = 3
  integer, parameter:: IDPhyModeJupiterSimple = 4

  integer           :: IDPhyTendMethod           ! ʪˤѲΨη׻ˡ
                                                 ! Method calculating physics tendency

  integer, parameter:: IDPhyTendMethodImp1LayModel = 10
  integer, parameter:: IDPhyTendMethodImpSoilModel = 11
  integer, parameter:: IDPhyTendMethodImpAtmOnly   = 12

  integer           :: IDRadMethod               ! Ͳη׻ˡ
                                                 ! Method for radiation

  integer, parameter:: IDRadMethodDennouAGCM = 20
  integer, parameter:: IDRadMethodDcpamEV1   = 21
  integer, parameter:: IDRadMethodDcpamMV1   = 22
  integer, parameter:: IDRadMethodSL09       = 23

  logical:: FlagPhyImpSoilModelSO   ! flag for use of slab ocean
  logical:: FlagVerticalFilter      ! flag for use of vertical filter


  logical:: firstloop = .true.
                              ! Υ롼פǤ뤳Ȥ򼨤ե饰. 
                              ! Flag implying first loop

  logical:: flag_initial
                              ! ֥롼 MainInit ꤵޤ. 
                              ! ꥹȥǡɤ߹ˤ, 
                              ! .false. , ͥǡɤ߹ˤ
                              ! .true. ꤵޤ. 
                              ! 
                              ! This variable is set in an internal 
                              ! subroutine "MainInit". 
                              ! If restart data is loaded, .false. is set. 
                              ! On the other hand, if initial data is loaded, 
                              ! .true. is set.

  integer:: n                 ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit


  ! ʬ
  ! Time integration
  !
  loop_time : do while ( TimeB < EndTime )

    ! ɽ̹٤
    ! Set surface height
    !
    call SetSurfaceProperties( &
      & xy_SurfHeight = xy_SurfHeight  & ! (inout) optional
      & )


    select case ( IDPhyMode )
    case ( IDPhyModeNoPhysics )

      xyz_DUDt     = 0.0d0
      xyz_DVDt     = 0.0d0
      xyz_DTempDt  = 0.0d0
      xyzf_DQMixDt = 0.0d0

    case ( IDPhyModeHS94 )

      ! Held and Suarez (1994) ˤ붯Ȼ
      ! Forcing and dissipation suggested by Held and Suarez (1994)
      !
      call HS94Forcing( &
        & xyz_UB, xyz_VB, xyz_TempB, xy_PsB, & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt )    ! (out)
      xyzf_DQMixDt = 0.

    case ( IDPhyModeVenusSimple )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB,     xyz_TempB,                               & ! (in )
        & xyr_Temp,                                            & ! (out) optional
        & xyr_Press     = xyr_Press,                           & ! (out) optional
        & xyz_Press     = xyz_Press,                           & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
        & xyz_Height    = xyz_Height,                          & ! (out) optional
        & xyr_Height    = xyr_Height,                          & ! (out) optional
        & xyz_Exner     = xyz_Exner,  xyr_Exner  = xyr_Exner   & ! (out) optional
        & )

      ! ñ׻Τζ
      ! forcing for simple Venus calculation
      !
      call YT2003Forcing(                          &
        & xy_SurfHeight,                                      & ! (in )
        & xyz_UB, xyz_VB, xyz_TempB,                          & ! (in )
        & xy_PsB, xyz_Press, xyr_Press, xyr_Temp,             & ! (in )
        & xyz_Height, xyr_Height, xyz_Exner, xyr_Exner,       & ! (in )
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt                     & ! (out)
        & )

      xyzf_DQMixDt = 0.0d0


    case ( IDPhyModeJupiterSimple )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB,     xyz_TempB,                               & ! (in )
        & xyr_Press     = xyr_Press                            & ! (out) optional
        & )


      ! Schneider and Liu (2009) ˤľ
      ! Vertical diffusion by Schneider and Liu (2009)
      !
      call SL09Diffusion(                 &
        & xyz_UB, xyz_VB, xyr_Press,            & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff  & ! (out)
        & )

      ! Schneider and Liu (2009) ͥǥ
      ! Radiation model by Schneider and Liu (2009)
      !
      call RadSL09Flux(                                       &
        & xyr_Press, xyz_TempB,                               &
        & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux        &
        & )

      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadDTempDt(                           &
        & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)

      ! ǮǮΨ¤η׻
      ! Sum all diabatic heating rates
      !
      xyz_DTempDt = xyz_DTempDtVDiff + xyz_DTempDtRadL + xyz_DTempDtRadS

      xyzf_DQMixDt = 0.0_DP


    case ( IDPhyModeFullPhysics )

      ! ɽ̾
      ! Configure surface conditions
      !
      call SetSurfaceProperties(                        &
        & FlagPhyImpSoilModelSO,                        & ! (in)    optional
        & xy_SoilMoistB, xy_SurfSnowB,                  & ! (in)    optional
        & xy_SurfTemp            = xy_SurfTemp,            & ! (inout) optional
        & xy_SurfAlbedo          = xy_SurfAlbedo,          & ! (inout) optional
        & xy_SurfHumidCoef       = xy_SurfHumidCoef,       & ! (inout) optional
        & xy_SurfRoughLength     = xy_SurfRoughLength,     & ! (inout) optional
        & xy_SurfHeatCapacity    = xy_SurfHeatCapacity,    & ! (inout) optional
        & xy_DeepSubSurfHeatFlux = xy_DeepSubSurfHeatFlux, & ! (inout) optional
        & xy_SurfCond            = xy_SurfCond,            & ! (inout) optional
        & xy_SeaIceConc          = xy_SeaIceConc,          & ! (inout) optional
        & xy_SoilHeatCap         = xy_SoilHeatCap,         & ! (inout) optional
        & xy_SoilHeatDiffCoef    = xy_SoilHeatDiffCoef     & ! (inout) optional
        & )

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsB,     xyz_TempB,                               & ! (in )
        & xyr_Temp,                                            & ! (out) optional
        & xyr_Press     = xyr_Press,                           & ! (out) optional
        & xyz_Press     = xyz_Press,                           & ! (out) optional
        & xy_SurfHeight = xy_SurfHeight,                       & ! (in ) optional
        & xyz_Height    = xyz_Height, xyr_Height = xyr_Height, & ! (out) optional
        & xyz_Exner     = xyz_Exner,  xyr_Exner  = xyr_Exner   & ! (out) optional
        & )


      select case ( IDRadMethod )
      case ( IDRadMethodDennouAGCM )

        ! ͥեå (GFD Ǿȯͥǥ)
        ! Radiation flux (radiation model developed by GFD Dennou Club)
        !
        call RadDennouAGCMFlux(                                  &
          & xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xyr_Press, &   ! (in)
          & xy_SurfTemp, xy_SurfAlbedo,      &   ! (in)
          & xyr_RadLFlux, xyr_RadSFlux,      &   ! (out)
          & xyra_DelRadLFlux,                &   ! (out)
          & flag_rst = .not. flag_initial    &   ! (in) optional
          & )

      case ( IDRadMethodDcpamEV1 )

        if ( CompositionInqIndex( 'H2OLiq' ) <= 0 ) then
          call MessageNotify( 'E', prog_name, 'H2OLiq is not found.' )
        end if

        call RadDcpamEV2Flux(                                      &
          & xy_SurfAlbedo,                                         &
          & xyz_Press, xyr_Press, xyz_TempB,                       &
          & xyzf_QMixB(:,:,:,IndexH2OVap),                         &
          & xyzf_QMixB(:,:,:,CompositionInqIndex( 'H2OLiq' )),     &
          & xy_SurfTemp,                                           &
          & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux           &
          & )

      case ( IDRadMethodDcpamMV1 )

        call RadDcpamMV1Flux(                              &
          & xy_SurfAlbedo,                                 &
          & xyz_Press, xyr_Press, xyz_TempB, xy_SurfTemp,  &
          & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux   &
          & )

      case ( IDRadMethodSL09 )

        ! Schneider and Liu (2009) ͥǥ
        ! Radiation model by Schneider and Liu (2009)
        !
        call RadSL09Flux(                                       &
          & xyr_Press, xyz_TempB,                               &
          & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux        &
          & )

        ! This is done no to correct long wave radiation flux by PhyImplEvalRadLFluxA.
        ! (yot, 2010/09/28)
        !
        xyra_DelRadLFlux = 0.0_DP

      end select


      ! ľȻեå
      ! Vertical diffusion flux
      !
      call VDiffusion(                                               &
        & xyz_UB,     xyz_VB,     xyzf_QMixB,                        & ! (in)
        & xyz_TempB,  xyr_Temp,   xyr_Press,                         & ! (in)
        & xy_SurfHeight,                                             & ! (in)
        & xyz_Height, xyr_Height, xyz_Exner,    xyr_Exner,           & ! (in)
        & xyr_MomFluxX,  xyr_MomFluxY,  xyr_HeatFlux, xyrf_QMixFlux, & ! (out)
        & xyr_VelTransCoef, xyr_TempTransCoef,                       & ! (out)
        & xyr_QMixTransCoef                                          & ! (out)
        & )

      ! ɽ̥եå
      ! Surface flux
      !
      call SurfaceFlux(                                               &
        & xyz_UB, xyz_VB, xyz_TempB, xyr_Temp, xyzf_QMixB,            & ! (in)
        & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner, & ! (in)
        & xy_SurfTemp, xy_SurfHumidCoef,                              & ! (in)
        & xy_SurfRoughLength,                                         & ! (in)
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,    & ! (inout)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                  & ! (out)
        & xy_SurfQVapTransCoef                                        & ! (out)
        & )

      ! ʪλѲΨη׻ (ˡ)
      ! Calculate tendency by a part of physical processes (implicit)
      !
      select case ( IDPhyTendMethod )
      case ( IDPhyTendMethodImp1LayModel )

        call PhyImplTendency(                                        &
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
          & xyr_RadSFlux, xyr_RadLFlux,                              & ! (in)
          & xy_DeepSubSurfHeatFlux,                                  & ! (in)
          & xy_SurfTemp, xy_SurfHumidCoef, xy_SurfCond,              & ! (in)
          & xy_SurfHeatCapacity,                                     & ! (in)
          & xyra_DelRadLFlux,                                        & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
          & xyr_VelTransCoef, xyr_TempTransCoef,                     & ! (in)
          & xyr_QMixTransCoef,                                       & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
          & xy_SurfQVapTransCoef,                                    & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,      & ! (out)
          & xy_DSurfTempDt                                           & ! (out)
          & )

        xyz_DSoilTempDt = 0.0_DP
        xy_DSoilMoistDt = 0.0_DP
        xy_DSurfSnowDt  = 0.0_DP

      case ( IDPhyTendMethodImpSoilModel )

        ! ХĥǥΤɽ̥եå
        ! Modification of surface flux for bucket model
        !
        call BucketModQvapFlux(                       &
          & xy_SurfCond, xy_SoilMoistB, xy_SurfSnowB, & ! (in   )
          & xyrf_QMixFlux(:,:,0,IndexH2OVap)          & ! (inout)
          & )

        ! ϲˤǮαľȻ
        ! Vertical diffusion of heat under the ground
        !
        call SubsurfaceDiffusion(                    &
          & xy_DeepSubSurfHeatFlux,                  &          ! (in)
          & xy_SoilHeatCap, xy_SoilHeatDiffCoef,     &          ! (in )
          & xy_SurfTemp, xyz_SoilTemp,               &          ! (in)
          & xyr_SoilTempTransCoef, xyr_SoilHeatFlux  &          ! (out)
          & )

        call PhyImplSDHTendency(                                      &
          & FlagPhyImpSoilModelSO,                                    & ! (in)
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (in)
          & xyr_SoilHeatFlux,                                         & ! (in)
          & xyr_RadSFlux, xyr_RadLFlux,                               & ! (in)
          & xy_DeepSubSurfHeatFlux,                                   & ! (in)
          & xy_SurfTemp, xyz_SoilTemp,                                & ! (in)
          & xy_SurfHumidCoef, xy_SurfCond,                            & ! (in)
          & xy_SurfHeatCapacity,                                      & ! (in)
          & xy_SoilHeatCap, xy_SoilHeatDiffCoef,                      & ! (in)
          & xy_SeaIceConc,                                            & ! (in)
          & xyra_DelRadLFlux,                                         & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                          & ! (in)
          & xyr_VelTransCoef, xyr_TempTransCoef,                      & ! (in)
          & xyr_QMixTransCoef,                                        & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                & ! (in)
          & xy_SurfQVapTransCoef,                                     & ! (in)
          & xyr_SoilTempTransCoef,                                    & ! (in)
          & xy_SurfSnowB,                                             & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,       & ! (out)
          & xy_DSurfTempDt,                                           & ! (out)
          & xyz_DSoilTempDt,                                          & ! (out)
          & xy_DSoilMoistDt,                                          & ! (out)
          & xy_DSurfSnowDt                                            & ! (out)
          & )

      case ( IDPhyTendMethodImpAtmOnly )

        call PhyImplAtmOnlyTendency(                           &
          & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
          & xyr_Press, xyz_Exner, xyr_Exner,                         & ! (in)
          & xyr_VelTransCoef, xyr_TempTransCoef,                     & ! (in)
          & xyr_QMixTransCoef,                                       & ! (in)
          & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
          & xy_SurfQVapTransCoef,                                    & ! (in)
          & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt       & ! (out)
          & )

        xy_DSurfTempDt  = 0.0_DP
        xyz_DSoilTempDt = 0.0_DP
        xy_DSoilMoistDt = 0.0_DP
        xy_DSurfSnowDt  = 0.0_DP

      end select


      ! ˡǲ򤤤ɽǮ٤Ū $ t+\Delta t $ ˤĹȥեå
      ! ׻
      !   * Ƿ׻줿ͤľܼΥƥå $ t $ ˤĹȥեåȤ
      !   * Ѥ櫓ǤϤʤ
      !   * ߤλ֥ƥåפˤĹͲǮΨη׻˻Ȥ
      !
      ! Evaluate longwave flux at $ t+\Delta t $ consistent with surface energy balance
      ! solved with implicit method
      !   * The evaluated value is not used directly as Longwave flux at next step $t$.
      !   * The evaluated value is used to calculate long wave radiative heating rate 
      !     in the current time step.
      !
      call PhyImplEvalRadLFluxA( &
        & xyr_RadLFlux, &                                  ! (in)
        & xyz_DTempDtVDiff, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
        & xyr_RadLFluxA )                                  ! (out)

      ! ͤˤ벹ѲΨ
      ! Temperature tendency with radiation
      !
      call RadDTempDt(                            &
        & xyr_RadLFluxA, xyr_RadSFlux, xyr_Press, &   ! (in)
        & xyz_DTempDtRadL, xyz_DTempDtRadS )          ! (out)


      ! ǮǮΨ¤η׻
      ! Sum all diabatic heating rates
      !
      xyz_DTempDt = xyz_DTempDtVDiff + xyz_DTempDtRadL + xyz_DTempDtRadS


      select case ( IDRadMethod )
      case ( IDRadMethodDcpamMV1 )
        ! ׻ѶֳǮΨ׻
        ! Calculation of near infrared heating rate in the case of Mars
        !
        call RadDcpamMNIRINOUT(   &
          & xyz_Press,            &  ! (in)
          & xyz_DTempDt           &  ! (inout)
          & )
      end select


      if ( CompositionInqIndex( 'H2OLiq' ) > 0 ) then

        ! Add loss rate of cloud water
        !
        call SetCloudCloudWaterLossRateInOut(                  &
          & xyzf_QMixB(:,:,:,CompositionInqIndex('H2OLiq')),   & ! (in   )
          & xyzf_DQMixDt(:,:,:,CompositionInqIndex('H2OLiq'))  & ! (inout)
          & )

      end if


      ! ľȻեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output Vertical diffusion fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call VDiffusionOutput(                                       &
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
        & xyz_DUDt,  xyz_DVDt,  xyz_DTempDtVDiff,  xyzf_DQMixDt,   & ! (in)
        & xyz_Exner, xyr_Exner,                                    & ! (in)
        & xyr_VelTransCoef, xyr_TempTransCoef,                     & ! (in)
        & xyr_QMixTransCoef                                        & ! (in)
        & )

      ! ɽ̥եåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output surface fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call SurfaceFluxOutput(                                       &
        & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,  & ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDtVDiff, xyzf_DQMixDt,       & ! (in)
        & xy_SurfTemp, xy_DSurfTempDt,                              & ! (in)
        & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,        & ! (in)
        & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                & ! (in)
        & xy_SurfQVapTransCoef                                      & ! (in)
        & )

      ! ͥեåν 
      !   * ϤΤߤΥ֥롼Ǥ, ׻ˤϱƶʤ
      ! 
      ! Output radiation fluxes
      !   * This subroutine works for output only, 
      !     so it does not influence a calculation.
      !
      call RadFluxOutput(                                    &
        & xyr_RadSFlux, xyr_RadLFlux,                        & ! (in)
        & xyra_DelRadLFlux, xy_DSurfTempDt, xyz_DTempDtVDiff & ! (in)
        & )

    end select


    ! ̲١ھ١ھʬ̤ʬ
    ! Time integration of surface temperature, soil temperature, soil moisture, 
    ! and surface snow amount
    !
    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )

      ! ̲١ھ٤λʬ
      ! Time integration of surface temperature and soil temperature
      !
      call IntegralSurfTemp( &
        & xy_DSurfTempDt, xyz_DSoilTempDt, &     ! (in)
        & xy_SurfTemp   , xyz_SoilTemp     &     ! (inout)
        & )

      ! ھʬ̤λʬ
      ! Time integration of soil moisture and snow amount
      !
      call BucketIntegration( &
        & xy_SurfCond,                     & ! (in )
        & xy_DSoilMoistDt, xy_DSurfSnowDt, & ! (in )
        & xy_SoilMoistB, xy_SurfSnowB,     & ! (in )
        & xy_SoilMoistA, xy_SurfSnowA      & ! (out)
        & )

    end select


    ! ϳز
    ! Dynamical core
    !
    select case ( IDDynMode )
    case ( IDDynModeHSPLVAS83 )
      call Dynamics( &
        & xyz_UB,   xyz_VB,   xyz_TempB,   xyzf_QMixB,   xy_PsB, &   ! (in)
        & xyz_UN,   xyz_VN,   xyz_TempN,   xyzf_QMixN,   xy_PsN, &   ! (in)
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt, &           ! (in)
        & xy_SurfHeight, &                                             ! (in)
        & xyz_UA,   xyz_VA,   xyz_TempA,   xyzf_QMixA,   xy_PsA  &   ! (out)
        & )
    case ( IDDynModeNoHorAdv )
      call DynamicsPhysicsOnly(                                &
        & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt, & ! (in)
        & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             & ! (in)
        & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              & ! (out)
        & )
    end select


    select case ( IDPhyMode )
    case ( IDPhyModeJupiterSimple )
      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA,     xyz_TempA, & ! (in)
        & xyz_Press = xyz_Press, & ! (out) optional
        & xyr_Press = xyr_Press )  ! (out) optional

      ! ήĴ
      ! Dry convective adjustment
      !
      call DryConvAdjust( &
        & xyz_TempA,             &  ! (inout)
        & xyz_Press, xyr_Press  &  ! (in)
        & )

    case ( IDPhyModeFullPhysics )
      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level, 
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA,     xyz_TempA, & ! (in)
        & xyz_Press = xyz_Press, & ! (out) optional
        & xyr_Press = xyr_Press )  ! (out) optional

      ! ѱѥ᥿ꥼ
      ! Cumulus parameterization
      !
      xy_Rain         = 0.
      xyz_DTempDtCond = 0.
      xyz_DQVapDtCond = 0.
      ! new routine
      call MoistConvAdjust( &
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap), xy_Rain,     & ! (inout)
        & xyz_DTempDtCond, xyz_DQVapDtCond,                      & ! (inout)
        & xyz_Press, xyr_Press,                                  & ! (in)
        & xyz_DDelLWDtCum,                                       & ! (out) optional
        & xyz_DQH2OLiqDtCum                                      & ! (out) optional
        & )

      ! 絬϶ŷ
      ! Large scale condensation
      !
      call LScaleCond( &
        & xyz_TempA, xyzf_QMixA(:,:,:,IndexH2OVap), xy_Rain,     & ! (inout)
        & xyz_DTempDtCond, xyz_DQVapDtCond,                      & ! (inout)
        & xyz_Press, xyr_Press,                                  & ! (in)
        & xyz_DDelLWDtLSC,                                       & ! (out) optional
        & xyz_DQH2OLiqDtLSC                                      & ! (inout) optional
        & )


      call SetCloudRegDQCloudWaterDt( &
        & 'CUM', xyz_DQH2OLiqDtCum    & ! (in)
        & )
      call SetCloudRegDQCloudWaterDt( &
        & 'LSC', xyz_DQH2OLiqDtLSC    & ! (in)
        & )


      ! Хĥǥ, ߿ȼɽѲη׻
      ! bucket model, calculation of change of surface water due to precipitation
      !
      call BucketPRCPAdjust( &
        & xy_SurfCond, xy_PsA, xy_Rain, &  ! (in )
        & xyz_TempA, xy_SoilMoistA, xy_SurfSnowA      &  ! (inout)
        & )


      ! ήĴ
      ! Dry convective adjustment
      !
      call DryConvAdjust( &
        & xyz_TempA,             &  ! (inout)
        & xyz_Press, xyr_Press  &  ! (in)
        & )


      ! CO2 Ѳ (׻)
      ! Phase change of CO2 (for the use in Mars calculation)
      !
      call CO2PhaseChangeLimitTemp( &
        & xyr_Press, xyz_Press,  &  ! (in)
        & xy_SurfTemp, xyz_TempA  &  ! (inout)
        & )

      ! ʬμ̤
      ! Fix masses of constituents
      !
      call MassFixer(             &
        & xyr_Press,  & ! (in)
        & xyzf_QMixA  & ! (inout)
        & )

    end select

    ! Vertical filter
    ! ľե륿
    ! 
    if ( FlagVerticalFilter ) then

      ! ٤Ⱦҥ٥, ȹ٤λ
      ! Interpolate temperature on half sigma level,
      ! and calculate pressure and height
      !
      call AuxVars( &
        & xy_PsA,     xyz_TempA, & ! (in)
        & xyr_Temp  = xyr_Temp,  & ! (out) optional
        & xyr_Press = xyr_Press )  ! (out) optional

      call VerticalFilter( &
        & xyz_UA, xyz_VA, xyz_TempA, &
        & xyr_Press, xyr_Temp )

    end if

    ! ֥ե륿
    ! Time filter
    !
    if ( .not. flag_initial .or. .not. firstloop ) then
      call TimeFilter( &
        & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, &   ! (in)
        & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, &   ! (inout)
        & xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA, xy_PsA  )   ! (in)

      select case ( IDPhyMode )
      case ( IDPhyModeFullPhysics )
        call TimeFilterSurfVars( &
          & xy_SoilMoistB, xy_SurfSnowB, &   ! (in)
          & xy_SoilMoistN, xy_SurfSnowN, &   ! (inout)
          & xy_SoilMoistA, xy_SurfSnowA  &   ! (in)
          & )
      end select
    end if

!!$    write( 6, * ) xyz_TempA(0,jmax/2+1,1)

    ! ͽѿͤγǧ
    ! Check values of prognostic variables
    !
    call CheckProgVars( &
      & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA   & ! (in)
      & )

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeA, 'U',    xyz_UA )
    call HistoryAutoPut( TimeA, 'V',    xyz_VA )
    call HistoryAutoPut( TimeA, 'Temp', xyz_TempA )
    do n = 1, ncmax
      call HistoryAutoPut( TimeA, a_QMixName(n), xyzf_QMixA(:,:,:,n) )
    end do
    call HistoryAutoPut( TimeA, 'Ps',   xy_PsA )

    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )
      call HistoryAutoPut( TimeN, 'SurfTemp', xy_SurfTemp )
      if ( size( xyz_SoilTemp ) /= 0 ) then
        call HistoryAutoPut( TimeN, 'SoilTemp', xyz_SoilTemp )
      end if

      call HistoryAutoPut( TimeA, 'SoilMoist', xy_SoilMoistA )
      call HistoryAutoPut( TimeA, 'SurfSnow' , xy_SurfSnowA  )

      call HistoryAutoPut( TimeN, 'Rain', xy_Rain * LatentHeat )
      call HistoryAutoPut( TimeN, 'DTempDtCond', xyz_DTempDtCond )
      call HistoryAutoPut( TimeN, 'DQVapDtCond', xyz_DQVapDtCond )

      call HistoryAutoPut( TimeN, 'SeaIceConc', xy_SeaIceConc )
      call HistoryAutoPut( TimeN, 'SurfAlbedo', xy_SurfAlbedo )
    end select

    ! λ֥ƥåפ˸ͽѿؤ
    ! Exchange prediction variables for the next time step
    !
    xyz_UB     = xyz_UN     ; xyz_UN     = xyz_UA     ; xyz_UA     = 0.
    xyz_VB     = xyz_VN     ; xyz_VN     = xyz_VA     ; xyz_VA     = 0.
    xyz_TempB  = xyz_TempN  ; xyz_TempN  = xyz_TempA  ; xyz_TempA  = 0.
    xyzf_QMixB = xyzf_QMixN ; xyzf_QMixN = xyzf_QMixA ; xyzf_QMixA = 0.
    xy_PsB     = xy_PsN     ; xy_PsN     = xy_PsA     ; xy_PsA     = 0.


    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )
      xy_SoilMoistB = xy_SoilMoistN
      xy_SoilMoistN = xy_SoilMoistA
      xy_SoilMoistA = 0.0d0

      xy_SurfSnowB  = xy_SurfSnowN
      xy_SurfSnowN  = xy_SurfSnowA
      xy_SurfSnowA  = 0.0d0
    end select

    ! οʹ
    ! Progress time
    !
    call TimesetProgress

    ! NAMELIST ɤ߹ѿ̵̾ʤΤ¸ߤɤå
    ! HistoryAutoAddVariable Ͽѿ̾
    !
    ! Check that invalid variable names are loaded from NAMELIST or not
    ! Print registered variable names by "HistoryAutoAddVariable"
    !
    !!! if ( firstloop ) call HistoryAutoAllVarFix

    ! ꥹȥǡ
    ! Restart data output
    !
    call RestartFileOutput( &
      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB(:,:,:,IndexH2OVap), xy_PsB, &  ! (in)
      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN(:,:,:,IndexH2OVap), xy_PsN  )  ! (in)

    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )
      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature output
      !
      call RestartSurfTempOutput( &
        & xy_SurfTemp  )             ! (in)
    end select

    firstloop = .false.

  ! ʬλ
  ! Time integration is finished
  !
  end do loop_time

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate



contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit, NmlutilMsg, namelist_filename

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit, TimesetDelTimeHalf, &
      & TimeN                 ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                  imax, & ! ٳʻ. 
                                 ! Number of grid points in longitude
      &                  jmax, & ! ٳʻ. 
                                 ! Number of grid points in latitude
      &                  kmax, & ! ľؿ. 
                                 ! Number of vertical level
      &                kslmax    ! ϲαľؿ. 
                                 ! Number of subsurface vertical level

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    use composition, only: CompositionInit

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: ConstantsSnowSeaIceInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileOpen, RestartFileGet

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempOpen, RestartSurfTempGet

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileOpen
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT               ! ɸϤֹ. Unit number of standard output

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), parameter:: version = &
      & '$Name: dcpam5-20110407 $' // &
      & '$Id: dcpam_main.f90,v 1.21 2011-03-27 02:22:20 yot Exp $'
                              ! ץΥС
                              ! Main program version

    character(STRING)      :: opt_nml_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

    logical:: FlagDynamics      ! ϳز׻ѥե饰
                                ! Flag for dynamics

    logical:: FlagFullPhysics   ! ʪ׻ѥե饰
                                ! Flag for full physics
    logical:: FlagHS94          ! Held and Suarez (1994) 󡿥. 
                                ! Held and Suarez (1994) forcing on/off. 
    logical:: FlagVenusSimple   ! ñѥե饰
                                ! Flag for simple forcing for Venus
    logical:: FlagJupiterSimple !
                                ! Flag for simple forcing for Jupiter planets

    logical:: FlagRadDennouAGCM
                                ! flag for use of radiation model used in DennouAGCM
    logical:: FlagRadDcpamEV1
                                ! flag for use of radiation model used in DcpamEV1
    logical:: FlagRadDcpamMV1
                                ! flag for use of radiation model used in DcpamMV1
    logical:: FlagRadSL09
                                ! flag for use of radiation model used in DcpamMV1

    logical:: FlagPhyImp1LayModel
                             ! flag for use of implicit solver with surface 1 layer model
    logical:: FlagPhyImpSoilModel
                             ! flag for use of implicit solver with soil model
    logical:: FlagPhyImpAtmOnly
                             ! flag for use of implicit solver of atmospheric only

    character(STRING):: briefexpldyn
                              ! ¹ԥեδʷ (ϳز)
                              ! Brief account of executable file (dynamics)
    character(STRING):: briefexplphy
                              ! ¹ԥեδʷ (ʪ)
                              ! Brief account of executable file (physics)
    character(STRING):: briefexplrad
                              ! ¹ԥեδʷ (Ͳ)
                              ! Brief account of executable file (radiation)
    character(STRING):: briefexplimp
                              ! ¹ԥեδʷ (ˡˡ)
                              ! Brief account of executable file (implicit method)

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: k
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dcpam_main_nml/ &
      & FlagDynamics, &
      & FlagFullPhysics, FlagHS94, FlagVenusSimple, FlagJupiterSimple, &
      & FlagRadDennouAGCM, FlagRadDcpamEV1, FlagRadDcpamMV1, &
      & FlagRadSL09, &
      & FlagPhyImp1LayModel, FlagPhyImpSoilModel, FlagPhyImpSoilModelSO, &
      & FlagPhyImpAtmOnly, &
      & FlagVerticalFilter
          !
          ! ǥեͤˤĤƤϽ³ "main/dcpam_main.F90#MainInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "main/dcpam_main.F90#MainInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(       &
      & opt_nml_filename,    & ! (out)
      & prog_name            & ! (in )
      & )

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & opt_nml_filename  & ! (in)
      & )

    ! ǥեͤ
    ! Default values settings
    !
    FlagDynamics            = .true.
    FlagFullPhysics         = .true.
    FlagHS94                = .false.
    FlagVenusSimple         = .false.
    FlagJupiterSimple       = .false.

    FlagRadDennouAGCM       = .true.
    FlagRadDcpamEV1         = .false.
    FlagRadDcpamMV1         = .false.
    FlagRadSL09             = .false.
    FlagPhyImp1LayModel     = .true.
    FlagPhyImpSoilModel     = .false.
    FlagPhyImpSoilModelSO   = .false.
    FlagPhyImpAtmOnly       = .false.
    FlagVerticalFilter      = .false.

    ! ׻⡼ɤ
    ! Configure calculation mode
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &            ! (in)
        & nml = dcpam_main_nml, &  ! (out)
        & iostat = iostat_nml )    ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, prog_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = dcpam_main_nml )
    end if


    ! Identification of calculation method for dynamics
    !
    call MessageNotify( 'M', prog_name, &
      & 'FlagDynamics=<%b>.', &
      & l = (/FlagDynamics/) )

    if ( FlagDynamics ) then
      IDDynMode = IDDynModeHSPLVAS83
    else
      IDDynMode = IDDynModeNoHorAdv
    end if


    ! Identification of calculation method for physics
    !
    if ( FlagFullPhysics .and. FlagHS94 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagFullPhysics=<%b> conflicts with FlagHS94=<%b>.', &
        & l = (/FlagFullPhysics, FlagHS94/) )
    else if ( FlagFullPhysics .and. FlagVenusSimple ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagFullPhysics=<%b> conflicts with FlagVenusSimple=<%b>.', &
        & l = (/FlagFullPhysics, FlagVenusSimple/) )
    else if ( FlagFullPhysics .and. FlagJupiterSimple ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagFullPhysics=<%b> conflicts with FlagJupiterSimple=<%b>.', &
        & l = (/FlagFullPhysics, FlagJupiterSimple/) )
    else if ( FlagHS94 .and. FlagVenusSimple ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagHS94=<%b> conflicts with FlagVenusSimple=<%b>.', &
        & l = (/FlagHS94, FlagVenusSimple/) )
    else if ( FlagHS94 .and. FlagJupiterSimple ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagHS94=<%b> conflicts with FlagJupiterSimple=<%b>.', &
        & l = (/FlagHS94, FlagJupiterSimple/) )
    else if ( FlagVenusSimple .and. FlagJupiterSimple ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagVenusSimple=<%b> conflicts with FlagJupiterSimple=<%b>.', &
        & l = (/FlagVenusSimple, FlagJupiterSimple/) )
    end if
    !
    if ( FlagFullPhysics ) then
      IDPhyMode = IDPhyModeFullPhysics
    else if ( FlagHS94 ) then
      IDPhyMode = IDPhyModeHS94
    else if ( FlagVenusSimple ) then
      IDPhyMode = IDPhyModeVenusSimple
    else if ( FlagJupiterSimple ) then
      IDPhyMode = IDPhyModeJupiterSimple
    else
      IDPhyMode = IDPhyModeNoPhysics
    end if


    ! Identification of calculation method for radiation
    !
    call MessageNotify( 'M', prog_name, &
      & 'FlagRadDennouAGCM=<%b>.', &
      & l = (/FlagRadDennouAGCM/) )
    call MessageNotify( 'M', prog_name, &
      & 'FlagRadDcpamEV1  =<%b>.', &
      & l = (/FlagRadDcpamEV1/) )
    call MessageNotify( 'M', prog_name, &
      & 'FlagRadDcpamMV1  =<%b>.', &
      & l = (/FlagRadDcpamMV1/) )
    call MessageNotify( 'M', prog_name, &
      & 'FlagRadSL09      =<%b>.', &
      & l = (/FlagRadSL09/) )
    !
    !   Check for conflict
    !
    if ( FlagRadDennouAGCM .and. FlagRadDcpamEV1 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDennouAGCM=<%b> conflicts with FlagRadDcpamEV1=<%b>.', &
        & l = (/FlagRadDennouAGCM, FlagRadDcpamEV1/) )
    else if ( FlagRadDennouAGCM .and. FlagRadDcpamMV1 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDennouAGCM=<%b> conflicts with FlagRadDcpamMV1=<%b>.', &
        & l = (/FlagRadDennouAGCM, FlagRadDcpamMV1/) )
    else if ( FlagRadDennouAGCM .and. FlagRadSL09 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDennouAGCM=<%b> conflicts with FlagRadSL09=<%b>.', &
        & l = (/FlagRadDennouAGCM, FlagRadSL09/) )
    else if ( FlagRadDcpamEV1 .and. FlagRadDcpamMV1 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDcpamEV1=<%b> conflicts with FlagRadDcpamMV1=<%b>.', &
        & l = (/FlagRadDcpamEV1, FlagRadDcpamMV1/) )
    else if ( FlagRadDcpamEV1 .and. FlagRadSL09 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDcpamEV1=<%b> conflicts with FlagRadSL09=<%b>.', &
        & l = (/FlagRadDcpamEV1, FlagRadSL09/) )
    else if ( FlagRadDcpamMV1 .and. FlagRadSL09 ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagRadDcpamMV1=<%b> conflicts with FlagRadSL09=<%b>.', &
        & l = (/FlagRadDcpamMV1, FlagRadSL09/) )
    end if
    !
    if ( FlagRadDennouAGCM ) then
      IDRadMethod = IDRadMethodDennouAGCM
    else if ( FlagRadDcpamEV1 ) then
      IDRadMethod = IDRadMethodDcpamEV1
    else if ( FlagRadDcpamMV1 ) then
      IDRadMethod = IDRadMethodDcpamMV1
    else if ( FlagRadSL09 ) then
      IDRadMethod = IDRadMethodSL09
    else
      if ( FlagFullPhysics ) then
        call MessageNotify( 'E', prog_name, &
          & 'None of radiation model is selected.' )
      end if
    end if


    ! Identification of calculation method for solving simultaneous linear equations 
    ! of physics
    !
    call MessageNotify( 'M', prog_name, &
      & 'FlagPhyImp1LayModel=<%b>.', &
      & l = (/FlagPhyImp1LayModel/) )
    call MessageNotify( 'M', prog_name, &
      & 'FlagPhyImpSoilModel=<%b>.', &
      & l = (/FlagPhyImpSoilModel/) )
    call MessageNotify( 'M', prog_name, &
      & 'FlagPhyImpAtmOnly  =<%b>.', &
      & l = (/FlagPhyImpAtmOnly/) )
    !
    !   Check for conflict
    !
    if ( FlagPhyImp1LayModel .and. FlagPhyImpSoilModel ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagPhyImp1LayModel=<%b> conflicts with FlagPhyImpSoilModel=<%b>.', &
        & l = (/FlagPhyImp1LayModel, FlagPhyImpSoilModel/) )
    else if ( FlagPhyImpSoilModel .and. FlagPhyImpAtmOnly ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagPhyImpSoilModel=<%b> conflicts with FlagPhyImpAtmOnly=<%b>.', &
        & l = (/FlagPhyImpSoilModel, FlagPhyImpAtmOnly/) )
    else if ( FlagPhyImpAtmOnly .and. FlagPhyImp1LayModel ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagPhyImpAtmOnly=<%b> conflicts with FlagPhyImp1LayModel=<%b>.', &
        & l = (/FlagPhyImpAtmOnly, FlagPhyImp1LayModel/) )
    end if
    !
    !   Check for value of FlagFullPhysics
    !
    if ( ( .not. FlagFullPhysics ) .and. FlagPhyImpSoilModel ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagFullPhysics has to be true, when FlagPhyImpSoilModel is true.' )
    end if
    if ( ( .not. FlagFullPhysics ) .and. FlagPhyImpAtmOnly ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagFullPhysics has to be true, when FlagPhyImpAtmOnly is true.' )
    end if
    !
    !   Check for slab ocean
    !
    if ( ( .not. FlagPhyImpSoilModel ) .and. FlagPhyImpSoilModelSO ) then
      call MessageNotify( 'E', prog_name, &
        & 'FlagPhyImpSoilModel has to be true, when FlagPhyImpSoilModelSO is true.' )
    end if
    !
    if ( FlagPhyImp1LayModel ) then
      IDPhyTendMethod = IDPhyTendMethodImp1LayModel
    else if ( FlagPhyImpSoilModel ) then
      IDPhyTendMethod = IDPhyTendMethodImpSoilModel
    else if ( FlagPhyImpAtmOnly ) then
      IDPhyTendMethod = IDPhyTendMethodImpAtmOnly
    else
      if ( .not. FlagFullPhysics ) then
        call MessageNotify( 'E', prog_name, &
          & 'None of calculation method for simultaneous linear equations of physics is selected.' )
      end if
    end if


    ! ׻⡼ɤɽ
    ! Display calculation mode
    !
    select case ( IDDynMode )
    case ( IDDynModeHSPLVAS83 )
      briefexpldyn = 'used'
    case ( IDDynModeNoHorAdv )
      briefexpldyn = 'not used'
    end select

    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )
      briefexplphy = 'parameterization suite is used'
    case ( IDPhyModeHS94 )
      briefexplphy = 'forcing for Held and Suarez (1994) dynamical core test'
    case ( IDPhyModeVenusSimple )
      briefexplphy = 'simple forcing for a Venus-like planet'
    case ( IDPhyModeJupiterSimple )
      briefexplphy = 'simple forcing for a Jupiter-like planet'
    case ( IDPhyModeNoPhysics )
      briefexplphy = 'not used'
    end select

    if ( IDPhyMode == IDPhyModeFullPhysics ) then
      select case ( IDRadMethod )
      case ( IDRadMethodDennouAGCM )
        briefexplrad = 'dennou AGCM5 default'
      case ( IDRadMethodDcpamEV1 )
        briefexplrad = 'Earth-like planet'
      case ( IDRadMethodDcpamMV1 )
        briefexplrad = 'Mars'
      case ( IDRadMethodSL09 )
        briefexplrad = 'Schneider and Liu (2009) (Jupiter-like planet)'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplrad', '' )
      end select

      select case ( IDPhyTendMethod )
      case ( IDPhyTendMethodImp1LayModel )
        briefexplimp = 'system with surface 1 layer model'
      case ( IDPhyTendMethodImpSoilModel )
        briefexplimp = 'system with thermal diffusion soil model'
      case ( IDPhyTendMethodImpAtmOnly )
        briefexplimp = 'system only with atmosphere'
      case default
        call MessageNotify( 'E', 'Unexpected error in setting briefexplimp', '' )
      end select
    else
      briefexplrad = ''
    end if

    call MessageNotify( 'M', prog_name, '' )
    call MessageNotify( 'M', prog_name,   '+-------------------------------------' )
    call MessageNotify( 'M', prog_name,   '|  Dynamics: %c', c1 = trim(briefexpldyn) )
    call MessageNotify( 'M', prog_name,   '|  Physics : %c', c1 = trim(briefexplphy) )
    if ( IDPhyMode == IDPhyModeFullPhysics ) then
      call MessageNotify( 'M', prog_name, '|    Radiation model : %c', c1 = trim(briefexplrad) )
      call MessageNotify( 'M', prog_name, '|    Implicit method : %c', c1 = trim(briefexplimp) )
    end if
    call MessageNotify( 'M', prog_name,   '|  -- version = %c', c1 = trim(version) )
    call MessageNotify( 'M', prog_name,   '+-------------------------------------' )
    call MessageNotify( 'M', prog_name, '' )

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ˴ؤ
    ! Settings of array for atmospheric composition
    !
    call CompositionInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    call ConstantsSnowSeaIceInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_UB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VB    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempB (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsB    (0:imax-1, 1:jmax) )

    allocate( xyz_UN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VN    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempN (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixN(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsN    (0:imax-1, 1:jmax) )

    allocate( xyz_UA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_VA    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_TempA (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )
    allocate( xy_PsA    (0:imax-1, 1:jmax) )


    ! ꥹȥǡ
    ! Restart data input
    !
    call RestartFileGet( &
      & xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB, xy_PsB, & ! (out)
      & xyz_UN, xyz_VN, xyz_TempN, xyzf_QMixN, xy_PsN, & ! (out)
      & flag_initial )                                  ! (out) optional


    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )

      ! ɽ̲, ھ٤γ
      ! Allocation of surface temperature and soil temperature
      !
      allocate( xy_SurfTemp (0:imax-1, 1:jmax) )
      allocate( xyz_SoilTemp(0:imax-1, 1:jmax, 1:kslmax) )

      allocate( xy_SoilMoistB(0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowB (0:imax-1, 1:jmax) )

      allocate( xy_SoilMoistN(0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowN (0:imax-1, 1:jmax) )

      allocate( xy_SoilMoistA(0:imax-1, 1:jmax) )
      allocate( xy_SurfSnowA (0:imax-1, 1:jmax) )


      ! ɽ̲٥ꥹȥǡ
      ! Restart data of surface temperature input
      !
      call RestartSurfTempGet( &
        & xy_SurfTemp  )          ! (out)


      ! THIS IS A TEMPORARY LINE.
      ! ھ, ..., ν, ꥹȥե뤫ɤ褦ˤ
      ! Setting of initial values of soil temperature, ..., these values are input from restart file in near future
      !
      do k = 1, kslmax
        xyz_SoilTemp(:,:,k) = xy_SurfTemp
      end do

      xy_SoilMoistN = 0.0_DP
      xy_SurfSnowN  = 0.0_DP

      xy_SoilMoistB = xy_SoilMoistN
      xy_SurfSnowB  = xy_SurfSnowN

      xy_SoilMoistA = 0.0_DP
      xy_SurfSnowA  = 0.0_DP

    end select


    ! ꥹȥǡեν
    ! Initialization of restart data file
    !
    call RestartFileOpen

    ! ҥȥǡեν
    ! Initialization of history data files
    !
    call HistoryFileOpen

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'U' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'eastward wind', 'm s-1' )               ! (in)

    call HistoryAutoAddVariable( 'V' , &         ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'northward wind', 'm s-1' )              ! (in)

    call HistoryAutoAddVariable( 'Temp' , &      ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &  ! (in)
      & 'temperature', 'K' )                     ! (in)

    do n = 1, ncmax
      call HistoryAutoAddVariable( a_QMixName(n) , & ! (in)
        & (/ 'lon ', 'lat ', 'sig ', 'time' /),    & ! (in)
        & a_QMixLongName(n), 'kg kg-1' )             ! (in)
    end do

    call HistoryAutoAddVariable( 'Ps' , &        ! (in)
      & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
      & 'surface pressure', 'Pa' )               ! (in)


    ! ҥȥǡ (Ȼ)
    ! History data output (Start time)
    !
    call HistoryAutoPut( TimeN, 'U', xyz_UN )
    call HistoryAutoPut( TimeN, 'V', xyz_VN )
    call HistoryAutoPut( TimeN, 'Temp', xyz_TempN )
    do n = 1, ncmax
      call HistoryAutoPut( TimeN, a_QMixName(n), xyzf_QMixN(:,:,:,n) )
    end do
    call HistoryAutoPut( TimeN, 'Ps', xy_PsN )


    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )

      ! ɽ̲٥ꥹȥǡեν
      ! Initialization of restart data file of surface temperature
      !
      call RestartSurfTempOpen

      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'SurfTemp' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface temperature', 'K' )

      call HistoryAutoAddVariable( 'SoilTemp', &
        & (/ 'lon ', 'lat ', 'ssz ', 'time' /), &
        & 'soil temperature', 'K' )

      call HistoryAutoAddVariable( 'SoilMoist' , & ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
        & 'soil moisture', 'kg m-2' )              ! (in)

      call HistoryAutoAddVariable( 'SurfSnow'  , & ! (in)
        & (/ 'lon ', 'lat ', 'time' /), &          ! (in)
        & 'surface snow amount', 'kg m-2' )        ! (in)

      call HistoryAutoAddVariable( 'Rain', &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'precipitation', 'W m-2' )

      call HistoryAutoAddVariable( 'DTempDtCond' , &
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
        & 'condensation heating', 'K s-1' )

      call HistoryAutoAddVariable( 'DQVapDtCond' , &
        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
        & 'condensation moistening', 'kg kg-1 s-1' )

    end select


    ! ѿγ
    ! Allocation of diagnostic variables
    !
    allocate( xyz_DUDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DVDt    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax) )

    allocate( xy_SurfHeight (0:imax-1, 1:jmax) )

    select case ( IDPhyMode )
    case ( IDPhyModeFullPhysics )
      allocate( xy_SurfAlbedo         (0:imax-1, 1:jmax) )
      allocate( xy_SurfHumidCoef      (0:imax-1, 1:jmax) )
      allocate( xy_SurfRoughLength    (0:imax-1, 1:jmax) )
      allocate( xy_SurfHeatCapacity   (0:imax-1, 1:jmax) )
      allocate( xy_SeaIceConc         (0:imax-1, 1:jmax) )
      allocate( xy_SurfCond           (0:imax-1, 1:jmax) )
      allocate( xy_DeepSubSurfHeatFlux(0:imax-1, 1:jmax) )
      allocate( xy_SoilHeatCap        (0:imax-1, 1:jmax) )
      allocate( xy_SoilHeatDiffCoef   (0:imax-1, 1:jmax) )

      allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Height (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Height (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Exner  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyr_RadLFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLFluxA    (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1) )

      allocate( xyr_MomFluxX  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_MomFluxY  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_HeatFlux  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyrf_QMixFlux (0:imax-1, 1:jmax, 0:kmax, 1:ncmax) )

      allocate( xyr_SoilHeatFlux(0:imax-1, 1:jmax, 0:kslmax) )

      allocate( xyr_VelTransCoef (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_TempTransCoef(0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_QMixTransCoef(0:imax-1, 1:jmax, 0:kmax) )

      allocate( xy_SurfVelTransCoef (0:imax-1, 1:jmax) )
      allocate( xy_SurfTempTransCoef(0:imax-1, 1:jmax) )
      allocate( xy_SurfQVapTransCoef(0:imax-1, 1:jmax) )

      allocate( xyr_SoilTempTransCoef (0:imax-1, 1:jmax, 0:kslmax) )

      allocate( xy_DSurfTempDt (0:imax-1, 1:jmax) )
      allocate( xyz_DSoilTempDt(0:imax-1, 1:jmax, 1:kslmax) )

      allocate( xy_DSoilMoistDt(0:imax-1, 1:jmax) )
      allocate( xy_DSurfSnowDt (0:imax-1, 1:jmax) )

      allocate( xyz_DTempDtVDiff(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )


      allocate( xy_Rain         (0:imax-1, 1:jmax) )
      allocate( xyz_DTempDtCond (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DQVapDtCond (0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyz_DDelLWDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DDelLWDtLSC (0:imax-1,1:jmax,1:kmax) )

      allocate( xyz_DQH2OLiqDtCum (0:imax-1,1:jmax,1:kmax) )
      allocate( xyz_DQH2OLiqDtLSC (0:imax-1,1:jmax,1:kmax) )


      ! ҥȥǡϤΤΤؤѿϿ
      ! Register of variables for history data output
      !
      call HistoryAutoAddVariable( 'SeaIceConc' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'sea ice concentration', '1' )

      call HistoryAutoAddVariable( 'SurfAlbedo' , &
        & (/ 'lon ', 'lat ', 'time' /), &
        & 'surface albedo', '1' )

    case ( IDPhyModeVenusSimple )

      allocate( xyr_Temp   (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Height (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Height (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_Exner  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Exner  (0:imax-1, 1:jmax, 0:kmax) )

    case ( IDPhyModeJupiterSimple )

      allocate( xyz_Press  (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyr_Press  (0:imax-1, 1:jmax, 0:kmax) )

      allocate( xyz_DTempDtVDiff(0:imax-1, 1:jmax, 1:kmax) )

      allocate( xyr_HeatFlux  (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadLFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyr_RadSFlux     (0:imax-1, 1:jmax, 0:kmax) )
      allocate( xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax) )
      allocate( xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1) )

    end select

    ! ϥ顼ˡѤ뤿, t Ⱦʬ
    ! Delta t is reduced to half in order to use Euler method at initial step
    !
    if ( flag_initial ) then
      call TimesetDelTimeHalf
    end if

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! ⥸塼 ; USE statements
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! ϳز (ڥȥˡ, Arakawa and Suarez (1983))
    ! Dynamical process (Spectral method, Arakawa and Suarez (1983))
    !
    use dynamics_hspl_vas83, only: DynamicsFinalize

    ! Held and Suarez (1994) ˤ붯Ȼ
    ! Forcing and dissipation suggested by Held and Suarez (1994)
    !
    use held_suarez_1994, only: Hs94Finalize

    ! ͥեå (Хɥǥ)
    ! Radiation flux (band model)
    !
    use rad_DennouAGCM, only: RadDennouAGCMFinalize

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetFinalize

    ! ٤Ⱦҥ٥, ȹ٤λ
    ! Interpolate temperature on half sigma level, 
    ! and calculate pressure and height
    !
    use auxiliary, only: AuxFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data file
    !
    call RestartFileClose

    if ( IDPhyMode == IDPhyModeFullPhysics ) then
      ! ɽ̲٥ꥹȥǡե륯
      ! Close restart data file of surface temperature
      !
      call RestartSurfTempClose
    end if

    ! ҥȥǡե륯
    ! Close history data files
    !
    call HistoryFileClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
    deallocate( xyz_UB     )
    deallocate( xyz_VB     )
    deallocate( xyz_TempB  )
    deallocate( xyzf_QMixB )
    deallocate( xy_PsB     )

    deallocate( xyz_UN     )
    deallocate( xyz_VN     )
    deallocate( xyz_TempN  )
    deallocate( xyzf_QMixN )
    deallocate( xy_PsN     )

    deallocate( xyz_UA     )
    deallocate( xyz_VA     )
    deallocate( xyz_TempA  )
    deallocate( xyzf_QMixA )
    deallocate( xy_PsA     )

    ! ѿγղ
    ! Dellocation of diagnostic variables
    !
    deallocate( xyz_DUDt     )
    deallocate( xyz_DVDt     )
    deallocate( xyz_DTempDt  )
    deallocate( xyzf_DQMixDt )

    deallocate( xy_SurfHeight )

    if ( IDPhyMode == IDPhyModeFullPhysics ) then
      deallocate( xy_SurfAlbedo          )
      deallocate( xy_SurfHumidCoef       )
      deallocate( xy_SurfRoughLength     )
      deallocate( xy_SurfHeatCapacity    )
      deallocate( xy_SeaIceConc          )
      deallocate( xy_SurfCond            )
      deallocate( xy_DeepSubSurfHeatFlux )
      deallocate( xy_SoilHeatCap         )
      deallocate( xy_SoilHeatDiffCoef    )

      deallocate( xyr_Temp   )
      deallocate( xyz_Press  )
      deallocate( xyr_Press  )
      deallocate( xyz_Height )
      deallocate( xyr_Height )
      deallocate( xyz_Exner  )
      deallocate( xyr_Exner  )

      deallocate( xyr_RadLFlux     )
      deallocate( xyr_RadLFluxA    )
      deallocate( xyr_RadSFlux     )
      deallocate( xyra_DelRadLFlux )

      deallocate( xyr_MomFluxX  )
      deallocate( xyr_MomFluxY  )
      deallocate( xyr_HeatFlux  )
      deallocate( xyrf_QMixFlux )

      deallocate( xyr_VelTransCoef  )
      deallocate( xyr_TempTransCoef )
      deallocate( xyr_QMixTransCoef )

      deallocate( xy_SurfVelTransCoef  )
      deallocate( xy_SurfTempTransCoef )
      deallocate( xy_SurfQVapTransCoef )

      deallocate( xy_DSurfTempDt )
      deallocate( xyz_DSoilTempDt )

      deallocate( xy_DSoilMoistDt )
      deallocate( xy_DSurfSnowDt )

      deallocate( xyz_DTempDtVDiff )

      deallocate( xyz_DTempDtRadL )
      deallocate( xyz_DTempDtRadS )


      deallocate( xy_Rain          )
      deallocate( xyz_DTempDtCond  )
      deallocate( xyz_DQVapDtCond  )

      deallocate( xyz_DDelLWDtCum  )
      deallocate( xyz_DDelLWDtLSC  )

      deallocate( xyz_DQH2OLiqDtCum  )
      deallocate( xyz_DQH2OLiqDtLSC  )
    end if ! FlagFullPhysics



    ! ƥ⥸塼ѿγղ
    ! Dellocation of variables in modules
    !
    call DynamicsFinalize
    call AuxFinalize

    if ( IDPhyMode == IDPhyModeHS94 ) then
      call Hs94Finalize
    end if

    if ( IDPhyMode == IDPhyModeFullPhysics ) then
      ! ղȥꥹȥեνλ
      ! Dellocation and close a restart file
      !
      call RadDennouAGCMFinalize
    end if

    call AxessetFinalize

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! Finalize MPI
    !
    call MPIWrapperFinalize


  end subroutine MainTerminate

end program dcpam_main
