!= ɽ̥ǡץ
!
!= dcpam main program for generation of surface data
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: sst_data.f90,v 1.3 2010-08-30 01:54:45 yot Exp $
! Tag Name::  $Name: dcpam5-20110407 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program sst_data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɽ̥ǡեޤ. 
  !
  ! Surface data file is created. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ɽ̥ǡ
  ! Prepare surface data
  !
  use surface_data, only: SetSurfData

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature input/output
  !
  use restart_surftemp_io, only: RestartSurfTempOutput

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ѿ
  ! Variables
  !
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature

  ! ѿ
  ! Work variables
  !

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ɽ̥ǡκ
  ! Generate surface data
  !
  call SetSurfData( xy_SurfTemp = xy_SurfTemp )  ! (out) optional

  ! ɽ̲٥ꥹȥǡ
  ! Restart data of surface temperature output
  !
  call RestartSurfTempOutput( &
    & xy_SurfTemp  )             ! (in)

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperInit

    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax    ! ٳʻ. 
                               ! Number of grid points in latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempOpen, RestartSurfTempGet

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'sst_data'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name: dcpam5-20110407 $' // &
      & '$Id: sst_data.f90,v 1.3 2010-08-30 01:54:45 yot Exp $'
                              ! ץΥС
                              ! Main program version
    character(STRING)      :: opt_nml_filename
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

    ! ¹ʸ ; Executable statement
    !

    ! Initialize MPI
    !
    call MPIWrapperInit

    brief = 'SST data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(       &
      & opt_nml_filename,    & ! (out)
      & prog_name,           & ! (in )
      & brief                & ! (in )
      & )

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit( &
      & opt_nml_filename  & ! (in)
      & )

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ɽ̲ѿγ
    ! Allocation of a variable of surface temperature
    !
    allocate( xy_SurfTemp (0:imax-1, 1:jmax) )

    ! ɽ̲٥ꥹȥǡեν
    ! Initialization of restart data file of surface temperature
    !
    call RestartSurfTempOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! MPI
    !
    use mpi_wrapper, only : MPIWrapperFinalize

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ɽ̲٥ꥹȥǡ
    ! Restart data of surface temperature input/output
    !
    use restart_surftemp_io, only: RestartSurfTempClose

    ! ҥȥǡ
    ! History data output
    !
    use history_file_io, only: HistoryFileClose

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    ! ɽ̲٥ꥹȥǡե륯
    ! Close restart data file of surface temperature
    !
    call RestartSurfTempClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! ɽ̲ѿγղ
    ! Deallocation of a variable of surface temperature
    !
    deallocate( xy_SurfTemp )

    ! Finalize MPI
    !
    call MPIWrapperFinalize

  end subroutine MainTerminate

end program sst_data
