!= ˡˤʬΤΥ롼
!
!= Routines for time integration with implicit scheme
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: phy_implicit_utils.f90,v 1.1 2010-09-18 01:41:22 yot Exp $
! Tag Name::  $Name: dcpam5-20110407 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_implicit_utils
  !
  != ˡˤʬΤΥ롼
  !
  != Routines for time integration with implicit scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! PhyImplEvalRadLFluxA :: Ĺȥեå
  ! ------------         :: ------------
  ! PhyImplEvalRadLFluxA :: Longwave flux correction
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#phy_implicit_utils_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: ncmax, IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: PhyImplEvalRadLFluxA, PhyImplLUDecomp3, PhyImplLUSolve3

  ! ѿ
  ! Public variables
  !
  logical, save, public:: phy_implicit_utils_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'phy_implicit_utils'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110407 $' // &
    & '$Id: phy_implicit_utils.f90,v 1.1 2010-09-18 01:41:22 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !-------------------------------------------------------------------

  subroutine PhyImplEvalRadLFluxA( &
    & xyr_RadLFlux, &                                  ! (in)
    & xyz_DTempDt, xy_DSurfTempDt, xyra_DelRadLFlux, & ! (in)
    & xyr_RadLFluxA &                                  ! (out)
    & )
    !
    ! $ t-\Delta t $ ˤѲΨ򸵤, 
    ! $ t+\Delta t $ Ĺȥեå (xyr_RadLFluxA) 򻻽Фޤ. 
    ! 
    ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA) 
    ! from the tendency at $ t-\Delta t $ . 
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $ [s]
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ĺȥեå. 
                              ! Longwave flux
    real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(in):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax,  0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with longwave
    real(DP), intent(out):: xyr_RadLFluxA (0:imax-1, 1:jmax, 0:kmax)
                              ! $ t-\Delta t $ ˤѲΨ򸵤
                              ! Ф줿 $ t+\Delta t $ ˤ
                              ! Ĺȥեå. 
                              !
                              ! Longwave flux at $ t+\Delta t $ 
                              ! calculated from the tendency at 
                              ! $ t-\Delta t $ . 

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. phy_implicit_utils_inited ) call PhyImplInit

    ! $ t+\Delta t $ Ĺȥեå (xyr_RadLFluxA) 򻻽
    ! Evaluate longwave flux at $ t+\Delta t $ (xyr_RadLFluxA)
    !
    do k = 0, kmax
      xyr_RadLFluxA(:,:,k) = &
        &   xyr_RadLFlux(:,:,k) &
        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
        &   * 2. * DelTime
    end do

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine PhyImplEvalRadLFluxA

  !-------------------------------------------------------------------

  subroutine PhyImplLUDecomp3( &
    & jna_LUMtx, &            ! (inout)
    & JDim, NDim &            ! (in)
    & )
    !
    ! 3 гѹ LU ʬԤޤ. 
    !
    ! LU decomposition of triple diagonal matrix.
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(inout):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix

    ! ѿ
    ! Work variables
    ! 
    integer:: j, n            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! LU ʬ
    ! LU decomposition
    !
    do j = 1, JDim
      jna_LUMtx(j,1,1) = jna_LUMtx(j,1,1) / jna_LUMtx(j,1,0)
    end do

    do n = 2, NDim-1
      do j = 1, JDim
        jna_LUMtx(j,n,0)  =   jna_LUMtx(j,n,0) &
          &                 - jna_LUMtx(j,n,-1) * jna_LUMtx(j,n-1,1)

        jna_LUMtx(j,n,1)  =   jna_LUMtx(j,n,1) / jna_LUMtx(j,n,0)
      end do
    end do

    do j = 1, JDim
      jna_LUMtx(j,NDim,0) =   jna_LUMtx(j,NDim, 0) &
        &                   - jna_LUMtx(j,NDim,-1) * jna_LUMtx(j,NDim-1,1)
    end do

  end subroutine PhyImplLUDecomp3

  !-------------------------------------------------------------------

  subroutine PhyImplLUSolve3( &
    & ijn_Vector, &       ! (inout)
    & jna_LUMtx, &        ! (in)
    & IDim, JDim, NDim &  ! (in)
    & )
    !
    ! LU ʬˤη׻ (3гѹ) Ԥޤ.
    !
    ! Solve with LU decomposition (For triple diagonal matrix). 
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: IDim
    integer, intent(in):: JDim
    integer, intent(in):: NDim
    real(DP), intent(in):: jna_LUMtx(JDim, NDim, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP), intent(inout):: ijn_Vector(IDim, JDim, NDim)
                              ! ե٥ȥ / . 
                              ! Right-hand side vector / solution

    ! ѿ
    ! Work variables
    ! 
    integer:: i, j, n         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Forward substitution
    !
    do i = 1, IDim
      do j = 1, JDim
        ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMtx(j,1,0)
      end do
    end do

    do n = 2, NDim
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) = (   ijn_Vector(i,j,n) &
            &                   - ijn_Vector(i,j,n-1) * jna_LUMtx(j,n,-1) &
            &                  ) / jna_LUMtx(j,n,0)
        end do
      end do
    end do

    ! 
    ! Backward substitution
    !
    do n = NDim-1, 1, -1
      do i = 1, IDim
        do j = 1, JDim
          ijn_Vector(i,j,n) =   ijn_Vector(i,j,n) &
            &                 - ijn_Vector(i,j,n+1) * jna_LUMtx(j,n,1)
        end do
      end do
    end do

  end subroutine PhyImplLUSolve3

  !-------------------------------------------------------------------

  subroutine PhyImplInit
    !
    ! phy_implicit_utils ⥸塼νԤޤ. 
    ! NAMELIST#phy_implicit_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "phy_implicit_utils" module is initialized. 
    ! "NAMELIST#phy_implicit_utils_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /phy_implicit_nml/
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "phy_implicit#PhyImplInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "phy_implicit#PhyImplInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( phy_implicit_utils_inited ) return

    ! ǥեͤ
    ! Default values settings
    !

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = phy_implicit_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    phy_implicit_utils_inited = .true.
  end subroutine PhyImplInit

  !-------------------------------------------------------------------

end module phy_implicit_utils
