!= ̤
!
!= Mass fixer
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: mass_fixer.f90,v 1.3 2011-02-18 04:48:04 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110407 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module mass_fixer
  !
  != ̤
  !
  != Mass fixer
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̤ޤ.
  !
  ! Fix masses
  !
  !== Procedures List
  !
  ! MassFixer   :: ̤
  ! ----------  :: ---------------
  ! MassFixer   :: Fix masses
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#mass_fixer_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax
                              ! ʬο
                              ! Number of composition

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: MassFixer

  ! ѿ
  ! Public variables
  !
  logical, save, public:: mass_fixer_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'mass_fixer'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110407 $' // &
    & '$Id: mass_fixer.f90,v 1.3 2011-02-18 04:48:04 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface MassFixer
    module procedure MassFixer
  end interface

contains

  subroutine MassFixer(           &
    & xyr_Press,                  & ! (in)
    & xyzf_QMix,                  & ! (inout)
    & xyr_PressRef,               & ! (in) optional
    & xyzf_QMixRef,               & ! (in) optional
    & xyzf_DQMixDt                & ! (out) optional
    & )
    !
    ! ʬμ̤ޤ. 
    ! *xyzf_QMixRef* Ϳ줿ˤ, ʬͤ *xyzf_QMixRef* Τ
    ! Ʊˤʤ褦ޤ. 
    ! *xyzf_QMixRef* Ϳʤˤ, ʬͤΤ
    ! Ʊˤʤ褦ޤ. 
    ! *xyzf_DQMixDt* ˤ *xyz_QMix* Ѳ̤֤ޤ. 
    !
    ! Fix masses of constituents
    ! If *xyzf_QMixRef* is given, the mass is fixed to match its global integrated 
    ! value is the same as that of *xyzf_QMixRef*.
    ! If *xyzf_QMixRef* is not given, the mass is fixed to match its global integrated 
    ! value is the same as that of pre-fixed value. 
    ! Variation of *xyzf_QMix* is returned to *xyz_DQMixDt*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration

    ! ʬʿѤ
    ! Operation for integral and average
    !
    use intavr_operate, only: IntLonLat_xy

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop


    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in   )          :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(inout)          :: xyzf_QMix   (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in   ), optional:: xyr_PressRef(0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in   ), optional:: xyzf_QMixRef(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q \Delta p / g $ . ʬͤ碌ʬμ. 
                              ! Reference specific mass of constituent in a layer
    real(DP), intent(out  ), optional:: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ .  漾Ψ. 
                              ! Specific humidity correction

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_QMixBefCor    (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾.
                              ! Specific humidity before correction. 
    real(DP):: xyz_DelMass       (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta p / g $
                              ! 
    real(DP):: xyz_DelMassRef    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Delta p / g $ of reference
                              ! 
    real(DP):: xyz_DelConsMass   (0:imax-1, 1:jmax, 1:kmax)
                              ! ʬμ.
                              ! Mass of constituents in a layer.
    real(DP):: xyz_DelConsMassRef(0:imax-1, 1:jmax, 1:kmax)
                              ! ʬͤ碌ʬμ.
                              ! Reference mass of constituents.
    real(DP):: xy_ConsMass          (0:imax-1, 1:jmax)
                              ! ʬΥ.
                              ! Mass of constituents in a layer.
    real(DP):: xy_ConsMassRef       (0:imax-1, 1:jmax)
                              ! ʬͤ碌ʬΥ.
                              ! Reference mass of constituents in a layer.
    real(DP):: ConsMass
                              ! γʬμ
                              ! Total mass of constituents
    real(DP):: ConsMassRef
                              ! ʬͤ碌γʬμ
                              ! Reference total mass of constituents.
                              !

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitudinal direction
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitudinal direction
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. mass_fixer_inited ) call MassFixerInit


    ! Check arguments
    !
    if ( present( xyr_PressRef ) .or. present( xyzf_QMixRef ) ) then
      if ( .not. ( present( xyr_PressRef ) .and. present( xyzf_QMixRef ) ) ) then
        call MessageNotify( 'E', module_name, 'If xyr_PressRef or xyzf_QMixRef is given, both have to be given.' )
      end if
    end if


    ! $ \Delta p / g $ η׻
    ! Calculate $ \Delta p / g $
    !
    do k = 1, kmax
      xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do

    if ( present( xyr_PressRef ) ) then
      do k = 1, kmax
        xyz_DelMassRef(:,:,k) = ( xyr_PressRef(:,:,k-1) - xyr_PressRef(:,:,k) ) / Grav
      end do
    end if

    do n = 1, ncmax

      ! Calculate mass of constituents
      !
      xyz_DelConsMass = xyzf_QMix(:,:,:,n) * xyz_DelMass

      if ( present( xyzf_QMixRef ) ) then
        xyz_DelConsMassRef = xyzf_QMixRef(:,:,:,n) * xyz_DelMassRef
      else
        xyz_DelConsMassRef = xyz_DelConsMass
      end if
      if ( present( xyzf_DQMixDt ) ) then
        xyz_QMixBefCor = xyzf_QMix(:,:,:,n)
      end if


      ! μ̤ľؤμ̤碌.
      ! Negative mass is removed by filling it with the mass in a layer just below.
      !
      do k = kmax, 2, -1
        do j = 1, jmax
          do i = 0, imax-1
            if ( xyz_DelConsMass(i,j,k) < 0.0_DP ) then
              xyz_DelConsMass(i,j,k-1) = xyz_DelConsMass(i,j,k-1) &
                & + xyz_DelConsMass(i,j,k)
              xyz_DelConsMass(i,j,k  ) = 0.0_DP
            end if
          end do
        end do
      end do

      k = 1
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_DelConsMass(i,j,k) < 0.0_DP ) then
            xyz_DelConsMass(i,j,k) = 0.0_DP
          end if
        end do
      end do


      ! Ǥ
      ! Correction in globe
      !   ¸ΤΤμ̤򸺾.
      !   Total mass is decreased to conserve mass. 
      !
      xy_ConsMass    = 0.0d0
      xy_ConsMassRef = 0.0d0
      do k = kmax, 1, -1
        xy_ConsMass    = xy_ConsMass    + xyz_DelConsMass   (:,:,k)
        xy_ConsMassRef = xy_ConsMassRef + xyz_DelConsMassRef(:,:,k)
      end do
      ConsMass    = IntLonLat_xy( xy_ConsMass    )
      ConsMassRef = IntLonLat_xy( xy_ConsMassRef )


      if ( ConsMassRef < 0.0_DP ) then 
        call MessageNotify( 'M', module_name, 'ConsMassRef is negative. ConsMassRef is reset to zero, n = %d, ConsMassRef = %f.', &
          & i = (/ n /), d = (/ ConsMassRef /) )
        ConsMassRef = 0.0_DP
!!$        call MessageNotify( 'E', module_name, 'ConsMassRef is negative, n = %d.', i = (/ n /) )
      end if
      if ( ConsMass /= 0.0_DP ) then 
        xyz_DelConsMass = ConsMassRef / ConsMass * xyz_DelConsMass
      else
        xyz_DelConsMass = 0.0_DP
      end if

      xyzf_QMix(:,:,:,n) = xyz_DelConsMass / xyz_DelMass

      ! 漾Ѳλ
      ! Calculate specific humidity variance
      !
      if ( present( xyzf_DQMixDt ) ) then
        xyzf_DQMixDt(:,:,:,n) =     &
          &   xyzf_DQMixDt(:,:,:,n) &
          & + ( xyzf_QMix(:,:,:,n) - xyz_QMixBefCor ) / ( 2.0_DP * DelTime )
      end if

    end do


    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyzf_QMix(i,j,k,1) < 0.0_DP ) then
            write( 6, * ) 'NEGATIVE: ', i, j, k, xyzf_QMix(i,j,k,1)
          end if
        end do
      end do
    end do


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine MassFixer

  !-------------------------------------------------------------------

  subroutine MassFixerInit
    !
    ! negative_moist ⥸塼νԤޤ. 
    ! NAMELIST#negative_moist_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "negative_moist" module is initialized. 
    ! "NAMELIST#negative_moist_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /negative_moist_nml/
          !
          ! ǥեͤˤĤƤϽ³ "negative_moist#MassFixerInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "negative_moist#MassFixerInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( mass_fixer_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = negative_moist_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    mass_fixer_inited = .true.
  end subroutine MassFixerInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module mass_fixer
