    program main

      use vtype_module
      use const_module
      use fft6_module

      implicit none

!      integer(i4b), parameter :: mm = 5, nn = 2**2 * 3 * 5
!      integer(i4b), parameter :: mm = 5, nn = 3**4
!      integer(i4b), parameter :: mm = 5, nn = 2**8
      integer(i4b), parameter :: mm = 5, nn = 120
!      integer(i4b), parameter :: mm = 1, nn = 2**8
      real(dp)                :: data  ( mm, nn )
      real(dp)                :: datar ( mm, nn ), datai ( mm, nn )
      real(dp)                :: data1 ( nn )
      real(dp)                :: data1r( nn ), data1i( nn )
      integer(i4b)            :: isign
      real(dp)                :: amp, phase
      integer(i4b)            :: m, n

      integer(i4b)            :: ita( 5 )
      real(dp)                :: dta( nn, 2 )


      call fft6_fft_init( nn, ita, dta )


      do n = 1, nn
         data1( n ) = 2.0d0 &
              +  1.0d0 * cos(   1 * pix2/nn * ( n-1 ) -   1   * pi/6.0d0 ) &
              +  2.0d0 * cos(   2 * pix2/nn * ( n-1 ) -   2   * pi/6.0d0 ) &
              +  3.0d0 * cos(   3 * pix2/nn * ( n-1 ) -  11.5 * pi/6.0d0 ) &
              + 10.0d0 * cos(  10 * pix2/nn * ( n-1 ) -   5.5 * pi/6.0d0 )
!         data1( n ) = 0.0d0 &
!              +  2.0d0 * cos( pix2 / ( nn / 2 ) * ( n-1 ) -   1   * pi/6.0d0 )
      end do
      data1r( : ) = data1( : )
      data1i( : ) = 0.0d0
      !
      do m = 1, mm
         data( m, : ) = data1( : ) * m
      end do
      datar( :, : ) = data( :, : )
      datai( :, : ) = 0.0d0


      m = 1
      do n = 1, nn
         write( 61, * ) n-1, datar( m, n ), datai( m, n )
      end do


      isign = 1
!      call fft6_fft_prototype( mm, nn, datar, datai, isign )
!      call fft6_fft_base2( mm, nn, datar, datai, isign )
!      call fft6_fft( mm, nn, ita, dta, datar, datai, isign )
      call fft6_fftreal( mm, nn, ita, dta, data, datar, datai, isign )
!      call fft6_fft1( nn, ita, dta, data1r, data1i, isign )
!      do m = 1, mm
!         datar( m, : ) = data1r( : )
!         datai( m, : ) = data1i( : )
!      end do
!      call fft6_fftreal1( nn, ita, dta, data1, data1r, data1i, isign )
!      do m = 1, mm
!         datar( m, : ) = data1r( : )
!         datai( m, : ) = data1i( : )
!      end do

      m = 1
      do n = 1, nn
         amp   = sqrt( ( datar( m, n )**2 + datai( m, n )**2 ) ) * 2
         phase = atan( datai( m, n ) / datar( m, n ) ) * r2d
         if( datar( m, n ) .lt. 0.0d0 ) phase = phase + 180.0d0
         phase = -phase
         if( phase .lt. 0.0d0 ) phase = phase + 360.0d0
         write( 63, * ) fft6_i2m( nn, n ), amp, phase, &
              datar( m, n ), datai( m, n )
      end do

      isign = -1
!      call fft6_fft_prototype( mm, nn, datar, datai, isign )
!      call fft6_fft_base2( mm, nn, datar, datai, isign )
      call fft6_fft( mm, nn, ita, dta, datar, datai, isign )
!      call fft6_fftreal( mm, nn, ita, dta, data, datar, datai, isign )
!      datar( :, : ) = data( :, : )
!      call fft6_fft1( nn, ita, dta, data1r, data1i, isign )
!      do m = 1, mm
!         datar( m, : ) = data1r( : )
!         datai( m, : ) = data1i( : )
!      end do
!      call fft6_fftreal1( nn, ita, dta, data1, data1r, data1i, isign )
!      do m = 1, mm
!         datar( m, : ) = data1( : )
!      end do
!      datai( :, : ) = 0.0d0

      m = 1
      do n = 1, nn
         write( 62, * ) n-1, datar( m, n ), datai( m, n )
      end do


    end program main
