#ver1.0
#2012/11/22 x-tを追加
#2012/11/29 x-tを変更月ごとの図にすることにする
require 'gphys_const_v1.1'
require "numru/ggraph"
include NumRu
include NMath

#########################################################################################
def maketime ( dir, iyrs, iyre, gphys )

  ls = GPhys::IO.open(dir+'/'+"PlanetLonFromVE.nc","PlanetLonFromVE")
  lat = gphys.coord("lat")

  daysOfYear = 0
  DaysOfMonth.each do |i|
    daysOfYear += i
  end

  ts = (iyrs - 1) * daysOfYear * DataNumOfDay
  te = iyre * daysOfYear * DataNumOfDay
  lscut = ls.cut("time"=>ts..te)
  ls = NArray.sfloat(daysOfYear)

  for i in 0..daysOfYear*(iyre - iyrs + 1) - 1
    ls[i] = lscut[(i * 24)..(i * 24 +23)].mean(0).val
  end
   

 gphyscut = gphys.cut("time"=>ts..te) 
 

  sagyoufile = NetCDF.create('sagyou.nc')
  sagyoufile.def_dim(lat.name, lat.length)
  sagyoufile.def_dim('Ls', ls.size)
  #軸定義
  sagyou = sagyoufile.def_var(lat.name, lat.ntype, [lat.name])
  #属性定義
  for i in 0..lat.att_names.size - 1
    sagyou.put_att(lat.att_names[i], lat.get_att(lat.att_names[i]))
  end
  sagyoufile.enddef
  sagyou.put(lat.val)
  sagyoufile.redef
  time = sagyoufile.def_var('Ls', lscut.ntype, ['Ls'])
  for i in 0..lscut.att_names.size-1
    time.put_att(lscut.att_names[i], lscut.get_att(lscut.att_names[i]))
  end
  # 変数定義
  sagyou =  sagyoufile.def_var(gphys.name, gphys.ntype,[lat.name,'Ls'])
  for i in 0..gphys.att_names.size-1
   sagyou.put_att(gphys.att_names[i], gphys.get_att(gphys.att_names[i]))
  end
  sagyoufile.enddef
  index = 0
  ls.each do |times|
    sagyou.put(gphyscut.mean(0)[false, (index * 24)..(index * 24 + 23)].mean(-1).val, "start"=>[0,index], "end"=>[-1,index])
    time.put(times, "index"=>[index])
    index = index + 1
  end
  sagyoufile.close 
  gphystime = GPhys::IO.open("sagyou.nc", gphys.name)

  return gphystime
end

######################################################################
########

def dcpam_hours(iyrs, iyre, lt)

  daysOfYear = 0
  DaysOfMonth.each do |i|
    daysOfYear += i
  end

  tsyear = (iyrs - 1) * daysOfYear * DataNumOfDay
  ts = Array.new(lt.size,tsyear)
  te = Array.new(lt.size,tsyear + DaysOfMonth[0] * 24)
  for i in 0..lt.size-1
     for mon in 0..lt[i] - 2
       if lt[i] - 2 <= 0 then
         ts[i] = 0
       else
         ts[i] = ts[i] + DaysOfMonth[mon] * 24
       end
       te[i] = te[i] + DaysOfMonth[mon+1] * 24
     end
  end
  hours = [ts,te]
  return hours
end
def dcpam_lt( hour, gphys)

  gphyscut = gphys.cut("time"=>hour)
  return gphyscut
end
def dcpam_lt3d( hour, lev, gphys)

  gphyscut = gphys.cut("time"=>hour, "level"=>lev)
  return gphyscut
end

def dcpam_x_t2d ( dir, hourss, hourse, iyrs, iyre, lat, gphys )

  ls = GPhys::IO.open(dir+'/'+"PlanetLonFromVE.nc","PlanetLonFromVE")
  lon = gphys.coord("lon")

  daysOfYear = 0
  DaysOfMonth.each do |i|
    daysOfYear += i
  end
  dayss = 0
  for days in 0..hourss-2 
    dayss += DaysOfMonth[days]
  end
  dayse = 0
  for days in 0..hourse-1
    dayse += DaysOfMonth[days]
  end
  ts = (iyrs - 1) * daysOfYear * DataNumOfDay + dayss * DataNumOfDay
  te = iyre * daysOfYear * DataNumOfDay + dayse * DataNumOfDay
  lscut = ls.cut("time"=>ts..te)
  ls = NArray.sfloat(dayse - dayss)

  for i in 0..(dayse - dayss - 1)
    ls[i] = lscut[(i * 24)..(i * 24 +23)].mean(0).val
  end
   

 gphyscut = gphys.cut("lat"=>lat,"time"=>ts..te) 
 

  sagyoufile = NetCDF.create('sagyou.nc')
  sagyoufile.def_dim(lon.name, lon.length)
  sagyoufile.def_dim('Ls', ls.size)
  #軸定義
  sagyou = sagyoufile.def_var(lon.name, lon.ntype, [lon.name])
  #属性定義
  for i in 0..lon.att_names.size - 1
    sagyou.put_att(lon.att_names[i], lon.get_att(lon.att_names[i]))
  end
  sagyoufile.enddef
  sagyou.put(lon.val)
  sagyoufile.redef
  time = sagyoufile.def_var('Ls', lscut.ntype, ['Ls'])
  for i in 0..lscut.att_names.size-1
    time.put_att(lscut.att_names[i], lscut.get_att(lscut.att_names[i]))
  end
  # 変数定義
  sagyou =  sagyoufile.def_var(gphys.name, gphys.ntype,[lon.name,'Ls'])
  for i in 0..gphys.att_names.size-1
   sagyou.put_att(gphys.att_names[i], gphys.get_att(gphys.att_names[i]))
  end
  sagyoufile.enddef
  index = 0
  ls.each do |times|
    sagyou.put(gphyscut[false, (index * 24)..(index * 24 + 23)].mean(-1).val, "start"=>[0,index], "end"=>[-1,index])
    time.put(times, "index"=>[index])
    index = index + 1
  end
  sagyoufile.close 
  gphysxt = GPhys::IO.open("sagyou.nc", gphys.name)

  return gphysxt
end
def dcpam_x_t3d ( dir, hourss, hourse, iyrs, iyre, lat, alt, gphys )

  ls = GPhys::IO.open(dir+'/'+"PlanetLonFromVE.nc","PlanetLonFromVE")
  lon = gphys.coord("lon")

  daysOfYear = 0
  DaysOfMonth.each do |i|
    daysOfYear += i
  end

  dayss = 0
  for days in 0..hourss-2 
    dayss += DaysOfMonth[days]
  end
  dayse = 0
  for days in 0..hourse-1
    dayse += DaysOfMonth[days]
  end
  ts = (iyrs - 1) * daysOfYear * DataNumOfDay + dayss * DataNumOfDay
  te = iyre * daysOfYear * DataNumOfDay + dayse * DataNumOfDay
  lscut = ls.cut("time"=>ts..te)
  ls = NArray.sfloat(dayse - dayss)

  for i in 0..(dayse - dayss - 1)
    ls[i] = lscut[(i * 24)..(i * 24 +23)].mean(0).val
  end

 gphyscut = gphys.cut("lat"=>lat, "level"=>alt, "time"=>ts..te) 
 

  sagyoufile = NetCDF.create('sagyou.nc')
  sagyoufile.def_dim(lon.name, lon.length)
  sagyoufile.def_dim('Ls', ls.size)
  #軸定義
  sagyou = sagyoufile.def_var(lon.name, lon.ntype, [lon.name])
  #属性定義
  for i in 0..lon.att_names.size - 1
    sagyou.put_att(lon.att_names[i], lon.get_att(lon.att_names[i]))
  end
  sagyoufile.enddef
  sagyou.put(lon.val)
  sagyoufile.redef
  time = sagyoufile.def_var('Ls', lscut.ntype, ['Ls'])
  for i in 0..lscut.att_names.size-1
    time.put_att(lscut.att_names[i], lscut.get_att(lscut.att_names[i]))
  end
  # 変数定義
  sagyou =  sagyoufile.def_var(gphys.name, gphys.ntype,[lon.name,'Ls'])
  for i in 0..gphys.att_names.size-1
   sagyou.put_att(gphys.att_names[i], gphys.get_att(gphys.att_names[i]))
  end
  sagyoufile.enddef
  index = 0
  ls.each do |times|
    sagyou.put(gphyscut[false, (index * 24)..(index * 24 + 23)].mean(-1).val, "start"=>[0,index], "end"=>[-1,index])
    time.put(times, "index"=>[index])
    index = index + 1
  end
  sagyoufile.close 
  gphysxt = GPhys::IO.open("sagyou.nc", gphys.name)

  return gphysxt
end
