#!/usr/bin/env ruby
# -*- coding: utf-8 -*-
#これはalbedo=水平平均のデータ作成スクリプトである
# 2012/12/12 荻原弘尭 

#-------------宣言文-------------------
require "numru/gphys"
include NumRu
include Math

#-------------ファイル定義--------------
topogfilename = "./sp_for_Mars_T021_MGS.nc"
notopfilename = "./sp_for_Mars_T021_Notalbedo.nc"
#-------------変数定義-------------------
topog = GPhys::IO.open(topogfilename, "topog")
albedo = GPhys::IO.open(topogfilename, "albedo")
ti = GPhys::IO.open(topogfilename, "ti")
imax,jmax = topog.shape
xy_topog = topog.val
xy_albedo = albedo.val
xy_ti = ti.val

#--------------計算----------------------
for j in 0..jmax-1
  for i in 0..imax-1
    xy_albedo[i,j] = albedo.mean(0,1).val
  end
end

newto = albedo.copy
newto.replace_val(xy_albedo)
#newto.rename("Tau")
#new.set_att("long_name","surface stress power")
#new.set_att("units","N m-1")

#-------------ファイル出力----------------
newsp=NetCDF.create(notopfilename)
GPhys::IO.write(newsp,topog)
GPhys::IO.write(newsp,newto)
GPhys::IO.write(newsp,ti)
newsp.close
