# -*- coding: iso-2022-jp -*-
require 'gphys_methods_v1'
require "numru/ggraph"
include NumRu
include NMath

dir = ARGV[0]
vname = ARGV[1]
ts = ARGV[2].to_i
te = ARGV[3].to_i

title = ARGV[4]


gphysArr3d = GPhys::IO.open( dir+'/'+vname+'.nc', vname )

time = gphysArr3d.coord(3).val


if vname == 'Temp'
  gphyszm = gphysArr3d.cut('time'=>time[ts]..time[te]).mean('lon').mean('time')
elsif vname == 'U'
  gphyszm = gphysArr3d.cut('time'=>time[ts]..time[te]).mean('lon').mean('time')
elsif vname == 'V'
  gphyszm = calc_msf( gphysArr3d.cut('time'=>time[ts]..time[te]).mean('lon').mean('time') )
  dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )

elsif vname == 'QVap'
  gphyszm = gphysArr3d.cut('time'=>time[ts]..time[te]).mean('lon').mean('time')
end
rmiss = gphysArr3d.get_att('missing_value')[0]


# $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
# $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
if vname == 'Temp'
  levels = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'U'
  levels = [-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45,50]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,90999]
elsif vname == 'V'
  levels = [-14e2,-12e2,-10e2,-8e2,-6e2,-4e2,-2e2,0,2e2,4e2,6e2,8e2,10e2,12e2,14e2]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'QVap'
  levels = [1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3]
  patterns = [1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999]
end



DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2$B$K2hLLJ,3d(B, 'y'=yoko: $B:8>e"*1&>e"*:82<(B...
DCL.sgpset('lcntl', false)   # $B@)8fJ8;z$r2r<a$7$J$$(B
DCL.sgpset('lfull',true)     # $BA42hLLI=<((B
DCL.uzfact(0.7)             # $B:BI8<4$NJ8;zNs%5%$%:$r(B 0.75 $BG\(B
DCL.sgpset('lfprop',true)    # $B%W%m%]!<%7%g%J%k%U%)%s%H$r;H$&(B

DCL.glpset('lmiss',true)
DCL.glpset('rmiss',rmiss)

#< GGraph $B$K$h$k(B $BIA2h(B >
GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e5,1e3]
GGraph.set_axes('xlabelint'=>30)

GGraph.tone( gphyszm, true, 'lev'=>levels, 'pat'=>patterns )
if vname == 'V' || vname =='U'
  GGraph.contour( gphyszm, false, 'lev'=>[0], 'index'=>3 )
end
GGraph.color_bar

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
