!= ʪΤߤη׻Τϳز
!
!= A dynamics for calculation with physical processes only
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: dynamics_physicsonly.f90,v 1.3 2011-07-08 03:55:18 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dynamics_physicsonly
  !
  != ʪΤߤη׻Τϳز
  !
  != A dynamics for calculation with physical processes only
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  !== NAMELIST
  !
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level
  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: &
    &                    ncmax
                              ! ʬο
                              ! Number of composition

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: DynamicsPhysicsOnly
  public :: DynamicsPhysicsOnlyInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: dynamics_physicsonly_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  character(*), parameter:: module_name = 'dynamics_physicsonly'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: dynamics_physicsonly.f90,v 1.3 2011-07-08 03:55:18 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  subroutine DynamicsPhysicsOnly(                                &
    & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyzf_DQMixDtPhy, & ! (in)
    & xy_PsB, xyz_UB, xyz_VB, xyz_TempB, xyzf_QMixB,             & ! (in)
    & xy_PsA, xyz_UA, xyz_VA, xyz_TempA, xyzf_QMixA              & ! (out)
    & )

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_DUDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{u}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ®Ѳ.
                              ! Eastward wind tendency by external force terms (physical processes)
    real(DP), intent(in):: xyz_DVDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{v}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ®Ѳ.
                              ! Northward wind tendency by external force terms (physicalprocesses)
    real(DP), intent(in):: xyz_DTempDtPhy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{T}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ벹Ѳ.
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in):: xyzf_DQMixDtPhy (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \left(\DP{q}{t}\right)^{phy} $ .
                              ! Ϲ (ʪ) ˤ漾Ѳ.
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in ):: xy_PsB(0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(in ):: xyz_UB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in ):: xyz_VB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(in ):: xyz_TempB(0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in ):: xyzf_QMixB(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(out):: xy_PsA(0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyz_UA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(out):: xyz_VA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind
    real(DP), intent(out):: xyz_TempA(0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(out):: xyzf_QMixA(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity


    ! ѿ
    ! Work variables
    !

!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
!!$    integer:: j               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in latitude
!!$    integer:: k

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. dynamics_physicsonly_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    xy_PsA     = xy_PsB
    xyz_UA     = xyz_UB     + xyz_DUDtPhy     * 2.0d0 * DelTime
    xyz_VA     = xyz_VB     + xyz_DVDtPhy     * 2.0d0 * DelTime
    xyz_TempA  = xyz_TempB  + xyz_DTempDtPhy  * 2.0d0 * DelTime
    xyzf_QMixA = xyzf_QMixB + xyzf_DQMixDtPhy * 2.0d0 * DelTime


  end subroutine DynamicsPhysicsOnly

  !-------------------------------------------------------------------

  subroutine DynamicsPhysicsOnlyInit

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /surface_flux_bulk_nml/ &
!!$      & VelMinForRi, VelMinForVel, VelMinForTemp, VelMinForQVap, &
!!$      & VelMaxForVel, VelMaxForTemp, VelMaxForQVap, &
!!$! 
!!$      & Neutral, ConstBulkCoef, &
!!$      & VelBulkCoefMin, TempBulkCoefMin, QVapBulkCoefMin, &
!!$      & VelBulkCoefMax, TempBulkCoefMax, QVapBulkCoefMax
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "surface_flux_bulk#SurfFluxInit" 
!!$          ! Υɤ򻲾ȤΤ. 
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "surface_flux_bulk#SurfFluxInit" for the default values. 
!!$          !

    ! ¹ʸ ; Executable statement
    !

    if ( dynamics_physicsonly_inited ) return


    ! ǥեͤ
    ! Default values settings
    !



    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &                ! (in)
!!$        & nml = surface_flux_bulk_nml, &  ! (out)
!!$        & iostat = iostat_nml )        ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if
!!$
!!$    ! ҥȥǡϤΤΤؤѿϿ
!!$    ! Register of variables for history data output
!!$    !
!!$    call HistoryAutoAddVariable( 'TauX', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'surface stress(x)  ', 'N m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'TauY', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'surface stress(y)  ', 'N m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'Sens', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'sensible heat flux', 'W m-2' )
!!$
!!$    call HistoryAutoAddVariable( 'EVap', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'latent heat flux  ', 'W m-2' )
!!$
!!$    !  ; Print
!!$    !
!!$    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$
!!$    call MessageNotify( 'M', module_name, '  VelMinForRi   = %f', d = (/ VelMinForRi   /) )
!!$    call MessageNotify( 'M', module_name, '  VelMinForVel  = %f', d = (/ VelMinForVel  /) )
!!$    call MessageNotify( 'M', module_name, '  VelMinForTemp = %f', d = (/ VelMinForTemp /) )
!!$    call MessageNotify( 'M', module_name, '  VelMinForQVap = %f', d = (/ VelMinForQVap /) )
!!$    call MessageNotify( 'M', module_name, '  VelMaxForVel  = %f', d = (/ VelMaxForVel  /) )
!!$    call MessageNotify( 'M', module_name, '  VelMaxForTemp = %f', d = (/ VelMaxForTemp /) )
!!$    call MessageNotify( 'M', module_name, '  VelMaxForQVap = %f', d = (/ VelMaxForQVap /) )
!!$
!!$    call MessageNotify( 'M', module_name, 'Bulk coefficients:' )
!!$    call MessageNotify( 'M', module_name, '  Neutral         = %b', l = (/ Neutral          /) )
!!$    call MessageNotify( 'M', module_name, '  ConstBulkCoef   = %f', d = (/ ConstBulkCoef   /) )
!!$    call MessageNotify( 'M', module_name, '  VelBulkCoefMin  = %f', d = (/ VelBulkCoefMin  /) )
!!$    call MessageNotify( 'M', module_name, '  TempBulkCoefMin = %f', d = (/ TempBulkCoefMin /) )
!!$    call MessageNotify( 'M', module_name, '  QVapBulkCoefMin = %f', d = (/ QVapBulkCoefMin /) )
!!$    call MessageNotify( 'M', module_name, '  VelBulkCoefMax  = %f', d = (/ VelBulkCoefMax  /) )
!!$    call MessageNotify( 'M', module_name, '  TempBulkCoefMax = %f', d = (/ TempBulkCoefMax /) )
!!$    call MessageNotify( 'M', module_name, '  QVapBulkCoefMax = %f', d = (/ QVapBulkCoefMax /) )
!!$    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dynamics_physicsonly_inited = .true.

  end subroutine DynamicsPhysicsOnlyInit

  !--------------------------------------------------------------------------------------

end module dynamics_physicsonly
