!= ʬѲ
!
!= Phase change of atmospheric major component
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: major_comp_saturate.f90,v 1.1 2012-09-08 15:16:39 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module major_comp_saturate
  !
  != ʬѲ
  !
  != Phase change of atmospheric major component
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#major_comp_saturate_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private


  integer, save      :: IndexSpc
  integer, parameter :: IndexSpcCO2     = 1


  real(DP), parameter :: LatentHeatCO2Subl = 5.9d5
                              ! Latent heat of CO2 (J kg^{-1})
                              ! This value is obtained from Pollack et al. 
                              ! (1981) and Forget et al. (1998).

  ! ³
  ! Public procedure
  !
  public :: MajorCompSaturateCalcCondTemp
  public :: MajorCompSaturateInqLatentHeat
  public :: MajorCompSaturateInit

  ! ѿ
  ! Public variables
  !
  logical, save, public:: major_comp_saturate_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: module_name = 'major_comp_saturate'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: major_comp_saturate.f90,v 1.1 2012-09-08 15:16:39 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


  interface MajorCompSaturateCalcCondTemp
    module procedure &
      MajorCompSaturateCalcCondTemp3D, &
      MajorCompSaturateCalcCondTemp2D
  end interface


contains

  !--------------------------------------------------------------------------------------

  subroutine MajorCompSaturateCalcCondTemp3D(  &
    & xyz_Press,                               &  ! (in)
    & xyz_TempCond                             &  ! (inout)
    & )
    !
    ! ʬѲ
    !
    ! Major component phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyz_TempCond(0:imax-1, 1:jmax, 1:kmax)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. major_comp_saturate_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( IndexSpc )
    case ( IndexSpcCO2 )
      call CalcCO2CondTemp3D(  &
        & xyz_Press,       &  ! (in)
        & xyz_TempCond     &  ! (inout)
        & )
    end select


  end subroutine MajorCompSaturateCalcCondTemp3D

  !--------------------------------------------------------------------------------------

  subroutine MajorCompSaturateCalcCondTemp2D(  &
    & xy_Press,                                &  ! (in)
    & xy_TempCond                              &  ! (inout)
    & )
    !
    ! ʬѲ
    !
    ! Major component phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_Press   (0:imax-1, 1:jmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xy_TempCond(0:imax-1, 1:jmax)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. major_comp_saturate_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( IndexSpc )
    case ( IndexSpcCO2 )
      call CalcCO2CondTemp2D(  &
        & xy_Press,            &  ! (in)
        & xy_TempCond          &  ! (inout)
        & )
    end select


  end subroutine MajorCompSaturateCalcCondTemp2D

  !--------------------------------------------------------------------------------------

  subroutine CalcCO2CondTemp3D(  &
    & xyz_Press,                 &  ! (in)
    & xyz_TempCond               &  ! (inout)
    & )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyz_TempCond(0:imax-1, 1:jmax, 1:kmax)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. major_comp_saturate_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_TempCond = 149.2_DP + 6.48_DP * log( 0.135_DP * xyz_Press * 1.0d-2 )


  end subroutine CalcCO2CondTemp3D

  !--------------------------------------------------------------------------------------

  subroutine CalcCO2CondTemp2D(  &
    & xy_Press,                  &  ! (in)
    & xy_TempCond                &  ! (inout)
    & )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xy_Press   (0:imax-1, 1:jmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xy_TempCond(0:imax-1, 1:jmax)
                              !
                              ! Condensation temperature

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. major_comp_saturate_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xy_TempCond = 149.2_DP + 6.48_DP * log( 0.135_DP * xy_Press * 1.0d-2 )


  end subroutine CalcCO2CondTemp2D

  !--------------------------------------------------------------------------------------

  function MajorCompSaturateInqLatentHeat( ) result( LatentHeat )
    !
    ! ʬǮ֤ޤ. 
    !
    ! Inquiry of latent heat of major component
    !

    ! ⥸塼 ; USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP) :: LatentHeat


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. major_comp_saturate_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Set latent heat
    select case ( IndexSpc )
    case ( IndexSpcCO2  )
      LatentHeat = LatentHeatCO2Subl
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select


  end function MajorCompSaturateInqLatentHeat

  !--------------------------------------------------------------------------------------

  subroutine MajorCompSaturateInit(  &
    & CondMajCompName                & ! (in)
    & )
    !
    ! major_comp_saturate ⥸塼νԤޤ. 
    ! NAMELIST#major_comp_saturate_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "major_comp_saturate" module is initialized. 
    ! "NAMELIST#major_comp_saturate_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

!!$    ! NAMELIST եϤ˴ؤ桼ƥƥ
!!$    ! Utilities for NAMELIST file input
!!$    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
!!$
!!$    ! ե
!!$    ! File I/O support
!!$    !
!!$    use dc_iounit, only: FileOpen
!!$
!!$    ! ̷ѥ᥿
!!$    ! Kind type parameter
!!$    !
!!$    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA


    ! ʸ ; Declaration statements
    !
    implicit none

    character(*), intent(in) :: CondMajCompName
                                        ! Condensable major component


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /major_comp_saturate_nml/ &
!!$      & FlagUse

          ! ǥեͤˤĤƤϽ³ "major_comp_saturate#MajorCompSaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "major_comp_saturate#MajorCompSaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( major_comp_saturate_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                    &  ! (in)
!!$        & nml = major_comp_saturate_nml, &  ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
!!$    end if


    ! Set index
    select case ( CondMajCompName )
    case ( 'CO2' )
      IndexSpc = IndexSpcCO2
    case default
      call MessageNotify( 'E', module_name, 'This specice is not supported.' )
    end select



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    major_comp_saturate_inited = .true.

  end subroutine MajorCompSaturateInit

  !-------------------------------------------------------------------

end module major_comp_saturate
