!= Nakajima et al. (1992) Ѥ˰漾λ
!
!= Evaluate saturation specific humidity with Nakajima et al. (1992)
!
! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA
! Version::   $Id: saturate_nha1992.f90,v 1.5 2011-06-19 10:56:27 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module saturate_nha1992
  !
  != Nakajima et al. (1992) Ѥ˰漾λ
  !
  != Evaluate saturation specific humidity with Nakajima et al. (1992)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Nakajima et al. (1992) Ѥ줿˰¾ $ p^{*} $ ˴ؤʲμ
  ! Ѥ, ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a folloing formula for saturation watar vapor pressure 
  ! $ p^{*} $ in Nakajima et al. (1992). 
  ! 
  ! \[
  !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right). 
  ! \]
  !
  ! , $ T $ ϲ, $ R $ ׵Ǥ. 
  ! $ R $ Ǯ $ l $ , 
  ! ˰¶ $ p_0^{*} $ ϰʲΤ褦Ϳޤ. 
  !
  ! where $ T $ is temperature, $ R $ is the gas constant. 
  ! $ R $ and latent heat $ l $ , 
  ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
  ! 
  ! * $ R = 8.314 $ [J mol-1 K-1]
  ! * $ l = 43655 $ [J mol-1]
  ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
  !
  ! ˰¿˰漾 $ q^{*} $ ݤˤ, ʲμѤޤ. 
  !
  ! Saturation specific humidity $ q^{*} $ is calculated from 
  ! saturation watar vapor pressure as follows.
  !
  ! \[
  !    q^{*} (T, p) = \varepsilon \frac{p^{*} (T)}{p}
  ! \]
  !
  !  $ \varepsilon $ ϶ŷʬ絤ʬ, 
  ! $ p $ ϵǤ. 
  !
  ! where $ \varepsilon $ is molecular weight ratio of water vapor to air, 
  ! $ p $ is air pressure. 
  ! 
  ! ä, ˰漾, ˰漾βѲ뼰ϰʲΤ褦
  ! ʤޤ. 
  !
  ! Therefore, saturation specific humidity and temperature derivative of it 
  ! are calculated as follows. 
  !
  ! \[
  !    q^{*} (T, p) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
  !    \DP{q^{*} (T, p)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right) 
  !    = q^{*} \frac{l}{RT^2}
  ! \]
  !
  !== References
  !
  ! * Nakajima, S., Hayashi, Y.-Y., Abe, Y., 1992: 
  !   A study on the "runaway greenhouse effect" with a 
  !   one dimensional radiative convective equilibrium model. 
  !   <i>J. Atmos. Sci.</i>, <b>49</b>, 2256--2266.
  !
  !== Procedures List
  !
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! ------------  :: ------------
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#saturate_nha1992_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: xy_CalcQVapSat , xy_CalcDQVapSatDTemp
  public:: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: saturate_nha1992_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), parameter:: LatHeat = 43655_DP
                              ! $ l $ [J mol-1].
                              ! ζŷǮ. Latent heat of condensation of water vapor
  real(DP), parameter:: P0 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa].
                              ! ˰¶. constant for water vapor saturation curve

  character(*), parameter:: module_name = 'saturate_nha1992'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: saturate_nha1992.f90,v 1.5 2011-06-19 10:56:27 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  function xyz_CalcQVapSat( is, ie, js, je, ks, ke, xyz_Temp, xyz_Press ) result( xyz_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & EpsV                  ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in):: is
    integer , intent(in):: ie
    integer , intent(in):: js
    integer , intent(in):: je
    integer , intent(in):: ks
    integer , intent(in):: ke
    real(DP), intent(in):: xyz_Temp (is:ie, js:je, ks:ke)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press(is:ie, js:je, ks:ke)
                              ! $ p $ . . Air pressure
    real(DP):: xyz_QVapSat(is:ie, js:je, ks:ke)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    xyz_QVapSat = EpsV * ( P0 / xyz_Press ) * exp ( - LatHeat / ( GasRUniv * xyz_Temp ) )


  end function xyz_CalcQVapSat

  !--------------------------------------------------------------------------------------

  function xyz_CalcDQVapSatDTemp( is, ie, js, je, ks, ke, xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
                              ! ׵.  Universal gas constant

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in):: is
    integer , intent(in):: ie
    integer , intent(in):: js
    integer , intent(in):: je
    integer , intent(in):: ks
    integer , intent(in):: ke
    real(DP), intent(in):: xyz_Temp   (is:ie, js:je, ks:ke)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_QVapSat(is:ie, js:je, ks:ke)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(is:ie, js:je, ks:ke)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾βʬη׻
    ! Calculate temperature derivative of saturation specific humidity
    !
    xyz_DQVapSatDTemp = xyz_QVapSat * LatHeat / ( GasRUniv * xyz_Temp**2 )


  end function xyz_CalcDQVapSatDTemp

  !--------------------------------------------------------------------------------------

  function xy_CalcQVapSat( is, ie, js, je, xy_Temp, xy_Press ) result( xy_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in):: is
    integer , intent(in):: ie
    integer , intent(in):: js
    integer , intent(in):: je
    real(DP), intent(in):: xy_Temp (is:ie, js:je)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press(is:ie, js:je)
                              ! $ p $ . . Air pressure
    real(DP):: xy_QVapSat(is:ie, js:je)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_Temp   (is:ie, js:je, 1:1)
                              ! $ T $ . . Temperature
    real(DP):: xyz_Press  (is:ie, js:je, 1:1)
                              ! $ p $ . . Air pressure
    real(DP):: xyz_QVapSat(is:ie, js:je, 1:1)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity

    ! ¹ʸ ; Executable statement
    !

    ! ˰漾η׻
    ! Calculate saturation specific humidity
    !
    xyz_Temp (:,:,1) = xy_Temp
    xyz_Press(:,:,1) = xy_Press

    xyz_QVapSat = xyz_CalcQVapSat( is, ie, js, je, 1, 1, xyz_Temp, xyz_Press )

    xy_QVapSat = xyz_QVapSat(:,:,1)


  end function xy_CalcQVapSat

  !--------------------------------------------------------------------------------------

  function xy_CalcDQVapSatDTemp( is, ie, js, je, xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
    !
    !  *Temp* ˰漾 *QVapSat* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and saturation specific humidity *QVapSat*. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in):: is
    integer , intent(in):: ie
    integer , intent(in):: js
    integer , intent(in):: je
    real(DP), intent(in):: xy_Temp   (is:ie, js:je)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_QVapSat(is:ie, js:je)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xy_DQVapSatDTemp(is:ie, js:je)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_Temp         (is:ie, js:je, 1:1)
                              ! $ T $ . . Temperature
    real(DP):: xyz_QVapSat      (is:ie, js:je, 1:1)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity
    real(DP):: xyz_DQVapSatDTemp(is:ie, js:je, 1:1)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 


    xyz_Temp   (:,:,1) = xy_Temp
    xyz_QVapSat(:,:,1) = xy_QVapSat

    xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( is, ie, js, je, 1, 1, xyz_Temp, xyz_QVapSat )

    xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)


  end function xy_CalcDQVapSatDTemp

  !--------------------------------------------------------------------------------------

  subroutine SaturateInit
    !
    ! saturate_nha1992 ⥸塼νԤޤ. 
    !--
    ! NAMELIST#saturate_nha1992_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !++
    !
    ! "saturate_nha1992" module is initialized. 
    !--
    ! "NAMELIST#saturate_nha1992_nml" is loaded in this procedure. 
    !++

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /saturate_nha1992_nml/ 
          !
          ! ǥեͤˤĤƤϽ³ "saturate_nha1992#SaturateInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "saturate_nha1992#SaturateInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( saturate_nha1992_inited ) return


    ! ǥեͤ
    ! Default values settings
    !


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = saturate_nha1992_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    saturate_nha1992_inited = .true.

  end subroutine SaturateInit

  !--------------------------------------------------------------------------------------

end module saturate_nha1992
