# -*- coding: euc-jp -*-
require "./gphys_methods_v1.91"
require "numru/ggraph"
include NumRu

dir   = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
imon = ARGV[4].to_i

title = MonNames[imon-1]


gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)

#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

if vname == 'SurfTemp'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,200,320]
elsif vname == 'PRCP'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,10e-5]
elsif vname == 'SoilMoist'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,20]
elsif vname == 'SurfSnow'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,20]
elsif vname == 'OLRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,100,300]
elsif vname == 'OSRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'SLRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,100]
elsif vname == 'SSRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
end

GGraph.set_axes('xlabelint'=>30)

gphysout = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )
gphysout = gphysout.mean('lon')

if vname == 'SurfTemp'
elsif vname == 'PRCP'
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
elsif vname == 'OSRA'
  gphysout = -gphysout
elsif vname == 'SLRA'
elsif vname == 'SSRA'
  gphysout = -gphysout
end

GGraph.line( gphysout, true, 'annotate'=>false, 'index'=>23 )

dirNCEP = "./data/NCEP"
if vname == 'SurfTemp'
  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/skt.sfc.mon.mean.nc', 'skt')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = gphysout + 273.15
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
elsif vname == 'PRCP'
  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/prate.sfc.mon.mean.nc', 'prate')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/ulwrf.ntat.mon.mean.nc', 'ulwrf')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
elsif vname == 'OSRA'
  gphysNCEP1 = GPhys::NetCDF_IO.open(dirNCEP+'/dswrf.ntat.mon.mean.nc', 'dswrf')
  gphysNCEP2 = GPhys::NetCDF_IO.open(dirNCEP+'/uswrf.ntat.mon.mean.nc', 'uswrf')
  gphysNCEP  = gphysNCEP1 - gphysNCEP2
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
elsif vname == 'SLRA'
  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nlwrs.sfc.mon.mean.nc', 'nlwrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
elsif vname == 'SSRA'
  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nswrs.sfc.mon.mean.nc', 'nswrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
  gphysout = clim_mon_mean_with_mon_mean( 1948, 1, 1988, 2007, imon, gphysNCEP )
  gphysout = -gphysout
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>33, 'annotate'=>false )
end


dirECMWF = "./data/ECMWF"
if vname == 'SurfTemp'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/skt.sfc.mon.mean.nc', 'skt')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout + 273.15
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
elsif vname == 'PRCP'
  gphysECMWF1 = GPhys::NetCDF_IO.open(dirECMWF+'/cp.nc', 'cp')
  gphysECMWF2 = GPhys::NetCDF_IO.open(dirECMWF+'/lsp.nc', 'lsp')
  gphysECMWF = gphysECMWF1 + gphysECMWF2
  gphysECMWF = gphysECMWF * 1.0e3 / 21600.0
#  gphysout = ecmwf_clim_mean_with_mon_mean( 1982, 2001, imon, gphysECMWF )
  gphysout = clim_mon_mean_with_mon_mean( 1957, 9, 1982, 2001, imon, gphysECMWF )
  gphysout = gphysout.mean('longitude')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>43, 'annotate'=>false )
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
  gphysECMWF = GPhys::NetCDF_IO.open(dirECMWF+'/ttr.nc', 'ttr')
  gphysECMWF = - gphysECMWF / 21600.0
#  gphysout = ecmwf_clim_mean_with_mon_mean( 1982, 2001, imon, gphysECMWF )
  gphysout = clim_mon_mean_with_mon_mean( 1957, 9, 1982, 2001, imon, gphysECMWF )
  gphysout = gphysout.mean('longitude')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>43, 'annotate'=>false )
elsif vname == 'OSRA'
  gphysECMWF = GPhys::NetCDF_IO.open(dirECMWF+'/tsr.nc', 'tsr')
  gphysECMWF = gphysECMWF / 21600.0
#  gphysout = ecmwf_clim_mean_with_mon_mean( 1982, 2001, imon, gphysECMWF )
  gphysout = clim_mon_mean_with_mon_mean( 1957, 9, 1982, 2001, imon, gphysECMWF )
  gphysout = gphysout.mean('longitude')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>43, 'annotate'=>false )
elsif vname == 'SLRA'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nlwrs.sfc.mon.mean.nc', 'nlwrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
elsif vname == 'SSRA'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nswrs.sfc.mon.mean.nc', 'nswrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = -gphysout
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
end


dirNOAAIOLR = "./data/NOAA_Int_OLR"
if vname == 'SurfTemp'
elsif vname == 'PRCP'
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
  gphysNOAAIOLR = GPhys::NetCDF_IO.open(dirNOAAIOLR+'/olr.mon.mean.nc', 'olr')
  gphysout = clim_mon_mean_with_mon_mean( 1974, 6, 1988, 2007, imon, gphysNOAAIOLR )
  gphysout = gphysout.mean('lon')
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>13, 'annotate'=>false )
elsif vname == 'OSRA'
elsif vname == 'SLRA'
elsif vname == 'SSRA'
end


dirGPCP = "./data/GPCP"
if vname == 'SurfTemp'
elsif vname == 'PRCP'
  gphysGPCP = GPhys::NetCDF_IO.open(dirGPCP+'/precip.mon.mean.nc', 'precip')
  gphysout = clim_mon_mean_with_mon_mean( 1979, 1, 1988, 2007, imon, gphysGPCP )
  gphysout = gphysout.mean('lon')
  gphysout = gphysout * 1.0e-3 * 1.0e3 / 86400.0
  GGraph.line( gphysout, false, 'type'=>1, 'index'=>13, 'annotate'=>false )
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
elsif vname == 'OSRA'
elsif vname == 'SLRA'
elsif vname == 'SSRA'
end


dirCMAP = "/home/yot/work/CMAP/data"
if vname == 'SurfTemp'
elsif vname == 'PRCP'
#  gphysCMAP = GPhys::NetCDF_IO.open(dirCMAP+'/precip.mon.mean.nc', 'precip')
#  gphysout = clim_mon_mean_with_mon_mean( 1979, 1, 1988, 2007, imon, gphysCMAP )
#  gphysout = gphysout.mean('lon')
#  gphysout = gphysout * 1.0e-3 * 1.0e3 / 86400.0
#  GGraph.line( gphysout, false, 'type'=>1, 'index'=>17, 'annotate'=>false )
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
elsif vname == 'OSRA'
elsif vname == 'SLRA'
elsif vname == 'SSRA'
end


DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
