require './gphys_const_v1.2'
require './gphys_methods_v1.91'
require "numru/ggraph"
include NumRu
include NMath

dir = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
imon = ARGV[4].to_i

title = MonNames[imon-1]


if vname == 'MSF'
  vnameinfile = 'V'
elsif vname == 'ANGMOM'
  vnameinfile = 'U'
elsif vname == 'QH2OCond'
  vnameinfile = 'QH2OLiq'
elsif vname == 'DTempDtRad'
  vnameinfile = 'DTempDtRadS'
else
  vnameinfile = vname
end
gphys = GPhys::IO.open( dir+'/'+vnameinfile+'.nc', vnameinfile )


#if vname == 'RH'
#  tempfile = 'Temp'
#  gphyst = GPhys::IO.open( dir+'/'+tempfile+'.nc', tempfile )
#  gphys = gphys / calc_qsat_tetens( gphyst )
#  gphys.long_name = 'relative humidity'
#  gphys.units     = '1'
#end

gphyszm = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )
gphyszm = gphyszm.mean('lon')
if vname == 'MSF'
  gphyszm = calc_msf( gphyszm )
elsif vname == 'ANGMOM'
  gphyszm = calc_angmom( gphyszm )
elsif vname == 'QH2OCond'
  vnameinfile = 'QH2OSol'
  gphystmp = GPhys::IO.open( dir+'/'+vnameinfile+'.nc', vnameinfile )
  gphystmpzm = dcpam_clim_mean( iyrs, iyre, gphystmp )
  gphystmpzm = gphystmpzm.mean('lon')
  gphyszm = gphyszm + gphystmpzm
  gphyszm.long_name = 'QH2OCond'
elsif vname == 'DTempDtRadS' || vname == 'DTempDtRadL'
  gphyszm = gphyszm * 60.0 * 60.0 * 24.0
  gphyszm.units = 'K day-1'
elsif vname == 'DTempDtRad'
  vnameinfile = 'DTempDtRadL'
  gphystmp = GPhys::IO.open( dir+'/'+vnameinfile+'.nc', vnameinfile )
  gphystmpzm = dcpam_clim_mean( iyrs, iyre, gphystmp )
  gphystmpzm = gphystmpzm.mean('lon')
  gphyszm = gphyszm + gphystmpzm
  gphyszm.long_name = 'DTempDtRad'
  gphyszm = gphyszm * 60.0 * 60.0 * 24.0
  gphyszm.units = 'K day-1'
end
rmiss = gphys.get_att('missing_value')[0]


# ٥ѥۤ˻
# ѥ1¿ޡޤ
if vname == 'Temp'
  levels = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'U'
  levels = [-50,-45,-40,-35,-30,-25,-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45,50]
  patterns = [10999,12999,15999,20999,25999,30999,32999,35999,40999,45999,50999,55999,60999,65999,70999,72999,75999,80999,85999,90999,92999,95999]
elsif vname == 'V'
  levels = [-5.0,-4.5,-4.0,-3.5,-3.0,-2.5,-2.0,-1.5,-1.0,-0.5,0.0,0.5,1.0,1.5,2.0,2.5,3.0,3.5,4.0,4.5,5.0]
  patterns = [10999,12999,15999,20999,25999,30999,32999,35999,40999,45999,50999,55999,60999,65999,70999,72999,75999,80999,85999,90999,92999,95999]
elsif vname == 'ANGMOM'
  levels = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999]
elsif vname == 'MSF'
#  levels = [-14e2,-12e2,-10e2,-8e2,-6e2,-4e2,-2e2,0,2e2,4e2,6e2,8e2,10e2,12e2,14e2]
#  levels = [-21e2,-18e2,-15e2,-12e2,-9e2,-6e2,-3e2,0,3e2,6e2,9e2,12e2,15e2,18e2,21e2]
#  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999,90999,95999]
  levels = [-20e2,-17.5e2,-15e2,-12.5e2,-10e2,-7.5e2,-5e2,-2.5e2,0,2.5e2,5e2,7.5e2,10e2,12.5e2,15e2,17.5e2,20e2]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'QH2OVap'
  levels = [1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3]
  patterns = [1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999]
elsif vname == 'QH2OLiq' || vname == 'QH2OSol' || vname == 'QH2OCond'
#  levels = [1e-6,2e-5,4e-5,6e-5,8e-5,10e-5,12e-5,14e-5,16e-5,18e-5,20e-5]
#  levels = [1e-7,2e-6,4e-6,6e-6,8e-6,10e-6,12e-6,14e-6,16e-6,18e-6,20e-6]
#  patterns = [1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999]
  levels = [1e-7,2e-6,4e-6,6e-6,8e-6,10e-6,12e-6,14e-6,16e-6,18e-6,20e-6,22e-6,24e-6,26e-6,28e-6,30e-6,32e-6,34e-6,36e-6,38e-6,40e-6,42e-6,44e-6,46e-6,48e-6,50e-6,52e-6,54e-6,56e-6,58e-6,60e-6,62e-6,64e-6,66e-6,68e-6,70e-6,72e-6,74e-6,76e-6,78e-6,80e-6,82e-6,84e-6,86e-6,88e-6,90e-6,92e-6,94e-6,96e-6,98e-6]
  patterns = [1,10999,12999,13999,15999,17999,19999,20999,22999,23999,25999,27999,29999,30999,32999,33999,35999,37999,40999,42999,43999,45999,47999,50999,52999,53999,55999,57999,60999,62999,65999,67999,70999,72999,75999,77999,78999,80999,82999,83999,84999,85999,87999,89999,90999,92999,93999,94999,95999,97999,99999]
elsif vname == 'RH'
  levels = [0,0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.45,0.5,0.55,0.6,0.65,0.7,0.75,0.8,0.85,0.9,0.95,1.0]
  patterns = [1,10999,12999,15999,20999,25999,30999,35999,40999,45999,50999,52999,55999,60999,65999,70999,75999,80999,85999,90999,92999,95999]
elsif vname == 'DTempDtRadS' || vname == 'DTempDtRadL' || vname == 'DTempDtRad'
  levels = [-5.0,-4.75,-4.5,-4.25,-4.0,-3.75,-3.5,-3.25,-3.0,-2.75,-2.5,-2.25,-2.0,-1.75,-1.5,-1.25,-1.0,-0.75,-0.5,-0.25,0.0,0.25,0.5,0.75,1.0,1.25,1.5,1.75,2.0,2.25,2.5,2.75,3.0,3.25,3.5,3.75,4.0,4.25,4.5,4.75,5.0]
  patterns = [10999,12999,14999,15999,17999,20999,21999,22999,23999,25999,27999,30999,32999,35999,37999,40999,42999,45999,47999,50999,52999,55999,57999,60999,62999,65999,67999,70999,72999,75999,80999,82999,85999,87999,90999,92999,93999,94999,95999,96999,98999,99999]
end


# Color map is changed for mass stream function.
if vname == 'U' || vname == 'V' || vname == 'DTempDtRadS' || vname == 'DTempDtRadL' || vname == 'DTempDtRad'
#  DCL.sgscmn(4)  # blue-cyan-white-yellow-red
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'MSF'
  DCL.sgscmn(14) # blue-white-red
end


DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.7)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

DCL.glpset('lmiss',true)
DCL.glpset('rmiss',rmiss)

#< GGraph ˤ  >
GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e5,1e3]
GGraph.set_axes('xlabelint'=>30)

GGraph.tone( gphyszm, true, 'lev'=>levels, 'pat'=>patterns, 'annotate'=>false )
#if vname == 'MSF' || vname =='U'
#  GGraph.contour( gphyszm, false, 'lev'=>[0], 'index'=>3, 'annotate'=>false )
#end
if vname == 'Temp'
#  levels = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
elsif vname == 'U'
  levels = [-100,-95,-90,-85,-80,-75,-70,-65,-60,-55,-50,-45,-40,-35,-30,-25,-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100]
elsif vname == 'ANGMOM'
#  levels = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
elsif vname == 'MSF'
  levels = [-35.0e2,-32.5e2,-30.0e2,-27.5e2,-25.0e2,-22.5e2,-20e2,-17.5e2,-15e2,-12.5e2,-10e2,-7.5e2,-5e2,-2.5e2,0,2.5e2,5e2,7.5e2,10e2,12.5e2,15e2,17.5e2,20e2,22.5e2,25.0e2,27.5e2,30.0e2,32.5e2,35.0e2]
elsif vname == 'QH2OVap'
#  levels = [1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3]
elsif vname == 'RH'
#  levels = [0,0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.45,0.5,0.55,0.6,0.65,0.7,0.75,0.8,0.85,0.9,0.95,1.0]
end
GGraph.contour( gphyszm, false, 'lev'=>levels, 'index'=>3, 'annotate'=>false )
GGraph.color_bar

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
