module pbl_mym_flux
  implicit none
contains
  subroutine pbl_mym_flux_run_level3(&
    & dfm, dfh, &
    & dfu_cg, dfv_cg, dft_cg, dfq_cg, &
    & u, v, tl, qw, &
    & rdz_h, f2h_m, f2h_p, &
    & taux, tauy, ftl, fqw)
    use pp_vardef
    use pbl_grid, only: nz
    implicit none

    real(r_size), intent(in) :: dfm(nz)
    real(r_size), intent(in) :: dfh(nz)
    real(r_size), intent(in) :: dfu_cg(nz)
    real(r_size), intent(in) :: dfv_cg(nz)
    real(r_size), intent(in) :: dft_cg(nz)
    real(r_size), intent(in) :: dfq_cg(nz)
    real(r_size), intent(in) :: u(nz)
    real(r_size), intent(in) :: v(nz)
    real(r_size), intent(in) :: tl(nz)
    real(r_size), intent(in) :: qw(nz)
    real(r_size), intent(in) :: rdz_h(nz-1)
    real(r_size), intent(in) :: f2h_m(nz-1)
    real(r_size), intent(in) :: f2h_p(nz-1)


    real(r_size), intent(out) :: taux(nz)
    real(r_size), intent(out) :: tauy(nz)
    real(r_size), intent(out) :: ftl(nz)
    real(r_size), intent(out) :: fqw(nz)

    integer(4) :: kz
    real(r_size) :: df_h
    real(r_size) :: diff
    real(r_size) :: cg_h


    do kz = 1, nz - 1
      df_h = f2h_m(kz) * dfm(kz) + f2h_p(kz) * dfm(kz + 1)

      diff = (u(kz + 1) - u(kz)) * rdz_h(kz)
      cg_h = f2h_m(kz) * dfu_cg(kz) + f2h_p(kz) * dfu_cg(kz + 1)
      taux(kz) = - (df_h * diff + cg_h)

      diff = (v(kz + 1) - v(kz)) * rdz_h(kz)
      cg_h = f2h_m(kz) * dfv_cg(kz) + f2h_p(kz) * dfv_cg(kz + 1)
      tauy(kz) = - (df_h * diff + cg_h)

      df_h = f2h_m(kz) * dfh(kz) + f2h_p(kz) * dfh(kz + 1)

      diff = (tl(kz + 1) - tl(kz)) * rdz_h(kz)
      cg_h = f2h_m(kz) * dft_cg(kz) + f2h_p(kz) * dft_cg(kz + 1)
      ftl(kz) = - (df_h * diff + cg_h)

      diff = (qw(kz + 1) - qw(kz)) * rdz_h(kz)
      cg_h = f2h_m(kz) * dfq_cg(kz) + f2h_p(kz) * dfq_cg(kz + 1)
      fqw(kz) = - (df_h * diff + cg_h)

    end do
    taux(nz) = 0.0_r_size
    tauy(nz) = 0.0_r_size
    ftl(nz) = 0.0_r_size
    fqw(nz) = 0.0_r_size

    return
  end subroutine pbl_mym_flux_run_level3
  !
  subroutine pbl_mym_flux_run_level25(&
    & dfm, dfh, u, v, tl, qw, &
    & rdz_h, f2h_m, f2h_p, &
    & taux, tauy, ftl, fqw)
    use pp_vardef
    use pbl_grid, only: nz
    implicit none

    real(r_size), intent(in) :: dfm(nz)
    real(r_size), intent(in) :: dfh(nz)
    real(r_size), intent(in) :: u(nz)
    real(r_size), intent(in) :: v(nz)
    real(r_size), intent(in) :: tl(nz)
    real(r_size), intent(in) :: qw(nz)
    real(r_size), intent(in) :: rdz_h(nz-1)
    real(r_size), intent(in) :: f2h_m(nz-1)
    real(r_size), intent(in) :: f2h_p(nz-1)

    real(r_size), intent(out) :: taux(nz)  ! on half levels
    real(r_size), intent(out) :: tauy(nz)
    real(r_size), intent(out) :: ftl(nz)
    real(r_size), intent(out) :: fqw(nz)

    integer(4) :: kz
    real(r_size) :: df_h
    real(r_size) :: diff

    do kz = 1, nz - 1
      df_h = f2h_m(kz) * dfm(kz) + f2h_p(kz) * dfm(kz + 1)

      diff = (u(kz + 1) - u(kz)) * rdz_h(kz)
      taux(kz) = - (df_h * diff )

      diff = (v(kz + 1) - v(kz)) * rdz_h(kz)
      tauy(kz) = - (df_h * diff)

      df_h = f2h_m(kz) * dfh(kz) + f2h_p(kz) * dfh(kz + 1)

      diff = (tl(kz + 1) - tl(kz)) * rdz_h(kz)
      ftl(kz) = - (df_h * diff)

      diff = (qw(kz + 1) - qw(kz)) * rdz_h(kz)
      fqw(kz) = - (df_h * diff)

    end do
    taux(nz) = 0.0_r_size
    tauy(nz) = 0.0_r_size
    ftl(nz) = 0.0_r_size
    fqw(nz) = 0.0_r_size

    return
  end subroutine pbl_mym_flux_run_level25

end module pbl_mym_flux
