!c Description: 
!c   Ķη׻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-12-15    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module basicenv
  !--- ۤηػ
  implicit none

  !--- save °
  save

  !--- ⥸塼ѿ
  real(8), allocatable   :: temp_bs(:,:)
  real(8), allocatable   :: vtheta_bs(:,:)
  real(8), allocatable   :: pres_bs(:,:)
  real(8), allocatable   :: pi_bs(:,:)
  real(8), allocatable   :: dens_bs(:,:)
  real(8), allocatable   :: qv_bs(:,:)

contains
  subroutine basicenv_init
    !--- ⥸塼ɤ߹
    use gridset
    use physprm
    use prm 
    use grid

    !--- ѿ
    integer       :: i
    character(80) :: type

    !--- ¸
    type = "uni_temp"

    !--- 
    allocate(temp_bs(-bm:im+bm,-bm:km+bm), &
         &   vtheta_bs(-bm:im+bm,-bm:km+bm), &
         &   pres_bs(-bm:im+bm,-bm:km+bm), &
         &   pi_bs(-bm:im+bm,-bm:km+bm), &
         &   dens_bs(-bm:im+bm,-bm:km+bm), &
         &   qv_bs(-bm:im+bm,-bm:km+bm))
    
    !---  case ʬ
    select case (type)
       
    !---------------------------------------------
    !--- پ
    !---------------------------------------------
    case ("uni_temp")
       !--- پ temp_sfc ǰ
       temp_bs = temp_sfc
       
       !--- ϾϽϤ(g=0 ʤ鰵ϰ)
       call basicpres(temp_bs, vtheta_bs, pres_bs, pi_bs, dens_bs, qv_bs)

    !---------------------------------------------
    !--- ܾβ٤ǮΨ
    !---------------------------------------------
    case ("adiabat")
       !--- ٤ϼǮΨǸ
       do i = -bm, km+bm
          temp_bs(:,i) = temp_sfc - dtdz * z(i) 
       end do
       
       !--- ϾϽϤ
       call basicpres(temp_bs, vtheta_bs, pres_bs, pi_bs, dens_bs, qv_bs)

    end select

  end subroutine basicenv_init


  
  subroutine basicpres(temp_bs, vtheta_bs, pres_bs, pi_bs, dens_bs, qv_bs)

    !--- ⥸塼ɤ߹
    use gridset
    use physprm
    use prm
    use jacobian
    
    !--- ѿ
    real(8), intent(in)    :: temp_bs(-bm:,-bm:)
    real(8), intent(out)   :: vtheta_bs(-bm:,-bm:)
    real(8), intent(out)   :: pres_bs(-bm:,-bm:)
    real(8), intent(out)   :: pi_bs(-bm:,-bm:)
    real(8), intent(out)   :: dens_bs(-bm:,-bm:)
    real(8), intent(out)   :: qv_bs(-bm:,-bm:)
    
    !--- ѿ
    real(8), allocatable   :: vtemp_bs(:,:)
    real(8), allocatable   :: theta_bs(:,:)
    integer                :: i, k
    
    !--- γ
    allocate(vtemp_bs(-bm:im+bm,-bm:km+bm), &
         &   theta_bs(-bm:im+bm,-bm:km+bm))
    
    !--- 
    vtheta_bs = 0.0d0
    pres_bs = 0.0d0
    pi_bs = 0.0d0
    dens_bs = 0.0d0
    qv_bs = 0.0d0
    vtemp_bs = 0.0d0
    theta_bs = 0.0d0
    
    !--- ɽ̤Ǥγ. پ줫
    !---- 
    pres_bs(:,-bm) = pres_sfc  
    !---- ̵
    pi_bs(:,-bm) = (pres_bs(:,-bm) / pres_sfc) ** ((gasr / rho) / cp)
    !---- 
    vtemp_bs(:,-bm) = temp_bs(:,-bm)
    !---- 
    theta_bs(:,-bm) = temp_bs(:,-bm) / pi_bs(:,-bm)
    !---- 
    vtheta_bs(:,-bm) = vtemp_bs(:,-bm) / pi_bs(:,-bm)
    !---- ̩ ()
    dens_bs(:,-bm) = (pres_sfc / ((gasr / rho) * vtheta_bs(:,-bm))) &
         & * (pi_bs(:,-bm)) ** (cp / (gasr / rho)) 
    
    !--- ɽ̤Ǥγ
    do k = -bm+1, km+bm
       do i = -bm, im+bm
          !----  (ſ尵ʿ) 
          pres_bs(i,k) = pres_bs(i,k-1) &
               & - dens_bs(i,k-1) * grav * jcb(i, k) * dz
          !---- ̵ (ſ尵ʿ)
          pi_bs(i,k) = pi_bs(i,k-1) &
               & - dz * jcb(i,k) * grav / (cp * vtheta_bs(i,k-1))
          !---- 
          theta_bs(i,k) = temp_bs(i,k) / pi_bs(i,k)
          !---- 
          vtheta_bs(i,k) = theta_bs(i,k) * (1.0d0 + 6.1d-1 * qv_bs(i,k))
          !---- ̩
          dens_bs(i,k) = (pres_sfc / ((gasr / rho) * vtheta_bs(i,k))) &
               & * (pi_bs(i,k)) ** (cp/(gasr / rho)) 
       end do
    end do


    !--- β
    deallocate(vtemp_bs, theta_bs)

  end subroutine basicpres


end module basicenv
