!c Description: 
!c   ʪѥ⥸塼
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-12    
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module physprm
  implicit none
  save
  real(8), parameter :: gasr          = 8.3143D0    !׵
  real(8), parameter :: temp_ref      = 298.15d0    !ɸಹ
  real(8), parameter :: pres_ref      = 1.0d5       !ɸవ
  real(8), parameter :: grav_jupiter  = 23.2d0      !ν
  real(8), parameter :: grav_earth    = 9.8d0       !ϵν
  real(8), parameter :: grav_mars     = 3.724d0     !ν
  real(8), parameter :: grav_venus    = 8.918d0     !ν
  real(8), parameter :: grav_saturn   = 9.92d0      !ν
  real(8), parameter :: grav_uranus   = 8.61d0      !ŷν
  real(8), parameter :: grav_neptune  = 11.1d0      !ν
  real(8), parameter :: nuh = 1.d-5     ! ʿοǴη
  real(8), parameter :: nuv = 1.0d-5    ! ľοǴη
  real(8)            :: grav            ! 
  character(80)      :: planet

contains
  subroutine physprm_init
    use fileset, only: cfgfile
    
    !--- NAMELIST 
    NAMELIST /planets/ planet
    
    !--- ѿμФ
    open (10, FILE=cfgfile)
    read(10, NML=planets)
    close(10)
    
    !--- Ϥ
    grav = 0.0d0

    select case(planet)
    case ("earth")
       grav = grav_earth
    case ("mars")
       grav = grav_mars
    case ("venus")
       grav = grav_venus
    case ("jupiter")
       grav = grav_jupiter
    case ("saturn") 
       grav = grav_saturn
    case ("uranus") 
       grav = grav_uranus
    case ("neptune")
       grav = grav_neptune
    end select

!    write(*,*) planet, grav

  end subroutine physprm_init
end module physprm

