!c Description: 
!c   ʬ黻. ׻Ǥʤΰ, ˵ͤ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_bibun
  interface bibun

     subroutine bibun_1d(type, var, var_bibun)
       use gridset
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(-bm:)
       real(8), intent(out), allocatable :: var_bibun(:)
     end subroutine bibun_1d
     
     subroutine bibun_2d(type, var, var_bibun)
       use gridset
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(-bm:,-bm:)
       real(8), intent(out), allocatable :: var_bibun(:,:)
     end subroutine bibun_2d
     
  end interface
end module if_bibun



subroutine bibun_1d(type, var, var_bibun)
  !--- ⥸塼ɤ߹
  use gridset
  
  !--- ۤηػ
  implicit none

  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(-bm:)
  real(8), intent(out), allocatable :: var_bibun(:)


  select case (type)

  case (111)
     allocate(var_bibun(-bm:im+bm))
     var_bibun = 0.0d0
     var_bibun(-bm+1:im+bm-1) =      &
          &  (                       &
          &     var(-bm+2:im+bm)     &
          &   - var(-bm:im+bm-2)     &
          &  ) *5.0d-1 / dx
     var_bibun(-bm) = var_bibun(-bm+1)
     var_bibun(im+bm) = var_bibun(im+bm-1)
     
  case (112)
     allocate(var_bibun(-bm:km+bm))
     var_bibun = 0.0d0
     var_bibun(-bm+1:km+bm-1) =      &
          &  (                       &
          &     var(-bm+2:km+bm)     &
          &   - var(-bm:km+bm-2)     &
          &  ) * 5.0d-1 / dz
     var_bibun(-bm) = var_bibun(-bm+1)
     var_bibun(km+bm) = var_bibun(km+bm-1)
     
  case (121)
     allocate(var_bibun(-bm:im+bm))
     var_bibun = 0.0d0
     var_bibun(-bm:im+bm-1) =        &
          &  (                       &
          &     var(-bm+1:im+bm)     &
          &   - var(-bm:im+bm-1)     &
          &  ) / dx
     var_bibun(im+bm) = var_bibun(im+bm-1)
     
  case (132)
     allocate(var_bibun(-bm:km+bm))
     var_bibun = 0.0d0
     var_bibun(-bm:km+bm-1) =        &
          &  (                       &
          &     var(-bm+1:km+bm)     &
          &   - var(-bm:km+bm-1)     &
          &  ) / dz
     var_bibun(km+bm) = var_bibun(km+bm-1)     

  end select
  
  if (.not. allocated(var_bibun)) then 
     write(*,*) "type is not known ", type, " by bibun.f90"
  end if

end subroutine bibun_1d




subroutine bibun_2d(type, var, var_bibun)
  !--- ⥸塼ɤ߹
  use gridset

  !--- ۤηػ
  implicit none

  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(-bm:,-bm:)
  real(8), intent(out), allocatable :: var_bibun(:,:)

  !--- ѿ
  allocate(var_bibun(-bm:im+bm, -bm:km+bm))
  var_bibun = 0.0d0


  !----------------------------------------------------
  !--- ʬ
  !----- case1x: ʻǤ
  !------- case1*1: x ʬ
  !------- case1*2: z ʬ
  !----- case2x: u Ǥ
  !------- case2*1: x ʬ
  !------- case2*2: zʬ
  !----- case3x: w Ǥ
  !------- case3*1: x ʬ
  !------- case3*2: z ʬ
  !----- case4x: ʻǤ
  !------- case4*1: x ʬ
  !------- case4*2: z ʬ
  !----------------------------------------------------

  select case (type)

  case (111)
     var_bibun(-bm+1:im+bm-1,-bm:km+bm) =      &
          &  (                                 &
          &     var(-bm+2:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-2,-bm:km+bm)     &
          &  ) * 5.0d-1 / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     
  case (112)
     var_bibun(-bm:im+bm,-bm+1:km+bm-1) =      &
          &  (                                 &
          &     var(-bm:im+bm,-bm+2:km+bm)   &
          &   - var(-bm:im+bm,-bm:km+bm-2)   &
          &  ) * 5.0d-1 / dz
     var_bibun(:,-bm) = var_bibun(:,-bm+1)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)     

  case (121)
     var_bibun(-bm:im+bm-1,-bm:km+bm) =        &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-1,-bm:km+bm)     &
          &  ) / dx
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)

  case (122)
     var_bibun(-bm:im+bm-1,-bm+1:km+bm-1) =    &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+2:km+bm)   &
          &   + var(-bm:im+bm-1,-bm+2:km+bm)   &
          &   - var(-bm+1:im+bm,-bm:km+bm-2)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-2)   &
          &  ) * 2.5d-1 / dz
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     var_bibun(:,-bm) = var_bibun(:,-bm+1)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)

  case (131)
     var_bibun(-bm+1:im+bm-1,-bm:km+bm-1) =    &
          &  (                                 &
          &     var(-bm+2:im+bm,-bm+1:km+bm)   &
          &   + var(-bm+2:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-2,-bm+1:km+bm)   &
          &   - var(-bm:im+bm-2,-bm:km+bm-1)   &
          &  ) * 2.5d-1 / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)

  case (132)
     var_bibun(-bm:im+bm,-bm:km+bm-1) =        &
          &  (                                 &
          &     var(-bm:im+bm,-bm+1:km+bm)     &
          &   - var(-bm:im+bm,-bm:km+bm-1)     &
          &  ) / dz
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)

  case (211)
     var_bibun(-bm+1:im+bm,-bm:km+bm) =        &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-1,-bm:km+bm)     &
          &  ) / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)

  case (212)
     var_bibun(-bm+1:im+bm,-bm+1:km+bm-1) =    &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+2:km+bm)   &
          &   + var(-bm:im+bm-1,-bm+2:km+bm)   &
          &   - var(-bm+1:im+bm,-bm:km+bm-2)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-2)   &
          &  ) * 2.5d-1 / dz
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(:,-bm) = var_bibun(:,-bm+1)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)
     
  case (221)
     var_bibun(-bm+1:im+bm-1,-bm:km+bm) =      &
          &  (                                 &
          &     var(-bm+2:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-2,-bm:km+bm)     &
          &  ) * 5.0d-1 / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)

  case (222)
     var_bibun(-bm:im+bm,-bm+1:km+bm-1) =      &
          &  (                                 &
          &     var(-bm:im+bm,-bm+2:km+bm)     &
          &   - var(-bm:im+bm,-bm:km+bm-2)     &
          &  ) * 5.0d-1 / dz
     var_bibun(:,-bm) = var_bibun(:,-bm+1)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)

  case (231)
     var_bibun(-bm+1:im+bm,-bm:km+bm-1) =    &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+1:km+bm)   &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-1,-bm+1:km+bm)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-1)   &
          &  ) * 5.0d-1/ dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)

  case (232)
     var_bibun(-bm+1:im+bm,-bm:km+bm-1) =      &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+1:km+bm)   &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)   &
          &   - var(-bm+1:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-1)   &
          &  ) * 5.0d-1 / dz
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)


  case (311)
     var_bibun(-bm+1:im+bm-1,-bm+1:km+bm) =    &
          &  (                                 &
          &     var(-bm+2:im+bm,-bm+1:km+bm)   &
          &   + var(-bm+2:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-2,-bm+1:km+bm)   &
          &   - var(-bm:im+bm-2,-bm:km+bm-1)   &
          &  ) * 2.5d-1 / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     var_bibun(:,-bm) = var_bibun(:,km+bm-1)
     
  case (312)
     var_bibun(-bm:im+bm,-bm+1:km+bm) =        &
          &  (                                 &
          &   + var(-bm:im+bm,-bm+1:km+bm)     &
          &   - var(-bm:im+bm,-bm:km+bm-1)     &
          &  ) / dz
     var_bibun(:,-bm) = var_bibun(:,-bm+1)

  case (321)
     var_bibun(-bm:im+bm-1,-bm+1:km+bm) =    &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+1:km+bm)   &
          &   + var(-bm+1:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-1,-bm+1:km+bm)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-1)   &
          &  ) * 5.0d-1/ dx
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     var_bibun(:,-bm) = var_bibun(:,km+bm-1)

  case (322)
     var_bibun(-bm:im+bm-1,-bm+1:km+bm) =      &
          &  (                                 &
          &     var(-bm+1:im+bm,-bm+1:km+bm)   &
          &   + var(-bm:im+bm-1,-bm+1:km+bm)   &
          &   - var(-bm+1:im+bm,-bm:km+bm-1)   &
          &   - var(-bm:im+bm-1,-bm:km+bm-1)   &
          &  ) * 5.0d-1 / dz
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)
     var_bibun(:,-bm) = var_bibun(:,-bm+1)

  case (331)
     var_bibun(-bm+1:im+bm-1,-bm:km+bm) =      &
          &  (                                 &
          &     var(-bm+2:im+bm,-bm:km+bm)     &
          &   - var(-bm:im+bm-2,-bm:km+bm)     &
          &  ) * 5.0d-1 / dx
     var_bibun(-bm,:) = var_bibun(-bm+1,:)
     var_bibun(im+bm,:) = var_bibun(im+bm-1,:)

  case (332)
     var_bibun(-bm:im+bm,-bm+1:km+bm-1) =      &
          &  (                                 &
          &     var(-bm:im+bm,-bm+2:km+bm)     &
          &   - var(-bm:im+bm,-bm:km+bm-2)     &
          &  ) * 5.0d-1 / dz
     var_bibun(:,-bm) = var_bibun(:,-bm+1)
     var_bibun(:,km+bm) = var_bibun(:,km+bm-1)
     
  end select
  
end subroutine bibun_2d
