!c Description: 
!c   ʪ̤־ѹ. ʿѲ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Comment: 
!c   
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2004-08-11    ̰ϯ 
!c   1.1        2004-08-24    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

module if_avr

  interface ss_avr1d_ss
     function ss_avr_ss(var)
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: ss_avr_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_avr_ss
  end interface

  interface ss_avr_fs
     function ss_avr1d_fs(var)
       use gridset
       real(8), intent(in)  :: var(DimZMin:DimZMax)
       real(8)              :: ss_avr1d_fs(DimZMin:DimZMax)
     end function ss_avr1d_fs

     function ss_avr2d_fs(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: ss_avr2d_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_avr2d_fs
  end interface

  interface ss_avr_sf
     function ss_avr1d_sf(var)
       use gridset
       real(8), intent(in)  :: var(DimZMin:DimZMax)
       real(8)              :: ss_avr1d_sf(DimZMin:DimZMax)
     end function ss_avr1d_sf

     function ss_avr2d_sf(var)
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: ss_avr2d_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_avr2d_sf
  end interface

  interface fs_avr_ss
     function fs_avr1d_ss(var)
       use gridset
       real(8), intent(in)  :: var(DimZMin:DimZMax)
       real(8)              :: fs_avr1d_ss(DimZMin:DimZMax)
     end function fs_avr1d_ss

     function fs_avr2d_ss(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: fs_avr2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_avr2d_ss
  end interface

  interface sf_avr_ss
     function sf_avr1d_ss(var) 
       use gridset
       real(8), intent(in)  :: var(DimZMin:DimZMax)
       real(8)              :: sf_avr1d_ss(DimZMin:DimZMax)
     end function sf_avr1d_ss

     function sf_avr2d_ss(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: sf_avr2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_avr2d_ss
  end interface

  interface fs_avr_fs
     function fs_avr_fs(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: fs_avr_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_avr_fs
  end interface

  interface sf_avr_fs
     function sf_avr_fs(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: sf_avr_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_avr_fs
  end interface

  interface sf_avr_sf
     function sf_avr_sf(var) 
       use gridset
       real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)              :: sf_avr_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_avr_sf
  end interface

end module if_avr



!!!
!!!顼ΰ֤Ǥʿ
!!!  
function ss_avr1d_fs(var)
  use gridset
  implicit none 
  
  real(8), intent(in)  :: var(DimZMin:DimZMax)
  real(8)              :: ss_avr1d_fs(DimZMin:DimZMax)

  ss_avr1d_fs = 0.0d0
  ss_avr1d_fs(DimZMin+1:DimZMax) =          &
       &  (                       &
       &     var(DimZMin+1:DimZMax)     &
       &   + var(DimZMin:DimZMax-1)     &
       &  ) * 5.0d-1
end function ss_avr1d_fs


function ss_avr1d_sf(var)
  use gridset
  implicit none 
  
  real(8), intent(in)  :: var(DimZMin:DimZMax)
  real(8)              :: ss_avr1d_sf(DimZMin:DimZMax)
  
  ss_avr1d_sf = 0.0d0
  ss_avr1d_sf(DimZMin+1:DimZMax) =          &
       &  (                       &
       &     var(DimZMin+1:DimZMax)     &
       &   + var(DimZMin:DimZMax-1)     &
       &  ) * 5.0d-1
end function ss_avr1d_sf


function ss_avr_ss(var)
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: ss_avr_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_avr_ss = var
end function ss_avr_ss


function ss_avr2d_fs(var) 
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: ss_avr2d_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_avr2d_fs = 0.0d0 
  ss_avr2d_fs(DimXMin+1:DimXMax,DimZMin:DimZMax) =          &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin:DimZMax)     &
       &   + var(DimXMin:DimXMax-1,DimZMin:DimZMax)     &
       &  ) * 5.0d-1
end function ss_avr2d_fs
  
  
function ss_avr2d_sf(var)
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: ss_avr2d_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_avr2d_sf = 0.0d0 
  ss_avr2d_sf(DimXMin:DimXMax,DimZMin+1:DimZMax) =          &
       &  (                                 &
       &     var(DimXMin:DimXMax,DimZMin+1:DimZMax)     &
       &   + var(DimXMin:DimXMax,DimZMin:DimZMax-1)     &
       &  ) * 5.0d-1
end function ss_avr2d_sf
  
  
!!!
!!!® u ΰ֤Ǥʿ
!!!  

function fs_avr1d_ss(var)
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimZMin:DimZMax)
  real(8)              :: fs_avr1d_ss(DimZMin:DimZMax)

  fs_avr1d_ss = 0.0d0 
  fs_avr1d_ss(DimZMin:DimZMax-1) =        &
       &  (                       &
       &     var(DimZMin+1:DimZMax)     &
       &   + var(DimZMin:DimZMax-1)     &
       &  ) * 5.0d-1
end function fs_avr1d_ss


function fs_avr2d_ss(var) 
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: fs_avr2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_avr2d_ss = 0.0d0 
  fs_avr2d_ss(DimXMin:DimXMax-1,DimZMin:DimZMax) =         &
       &  (                                &
       &     var(DimXMin+1:DimXMax,DimZMin:DimZMax)    &
       &   + var(DimXMin:DimXMax-1,DimZMin:DimZMax)    &
       &  ) * 5.0d-1
end function fs_avr2d_ss


function fs_avr_fs(var) 
  use gridset
  implicit none

  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: fs_avr_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_avr_fs = var
end function fs_avr_fs


function fs_avr_sf(var) 
  use gridset
  implicit none

  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: fs_avr_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_avr_sf = 0.0d0 
  fs_avr_sf(DimXMin:DimXMax-1,DimZMin+1:DimZMax) =       &
       &  (                                &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)  &
       &   + var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)  &
       &   + var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)  &
       &   + var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)  &
       &  ) * 2.5d-1
end function fs_avr_sf
  
  
!!!
!!!® w ΰ֤Ǥʿ
!!!  
  
function sf_avr1d_ss(var) 
  use gridset
  implicit none

  real(8), intent(in)  :: var(DimZMin:DimZMax)
  real(8)              :: sf_avr1d_ss(DimZMin:DimZMax)
  
  sf_avr1d_ss = 0.0d0
  sf_avr1d_ss(DimZMin:DimZMax-1) =          &
       &  (                       &
       &     var(DimZMin+1:DimZMax)     &
       &   + var(DimZMin:DimZMax-1)     &
       &  ) * 5.0d-1
end function sf_avr1d_ss


function sf_avr2d_ss(var) 
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: sf_avr2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_avr2d_ss = 0.0d0 
  sf_avr2d_ss(DimXMin:DimXMax,DimZMin:DimZMax-1) =         &
       &  (                                &
       &     var(DimXMin:DimXMax,DimZMin+1:DimZMax)    &
       &   + var(DimXMin:DimXMax,DimZMin:DimZMax-1)    &
       &  ) * 5.0d-1
end function sf_avr2d_ss

  
function sf_avr_fs(var) 
  use gridset
  implicit none
  
  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: sf_avr_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_avr_fs = 0.0d0 
  sf_avr_fs(DimXMin+1:DimXMax,DimZMin:DimZMax-1) =       &
       &  (                                &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)  &
       &   + var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)  &
       &   + var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)  &
       &   + var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)  &
       &  ) * 2.5d-1
end function sf_avr_fs


function sf_avr_sf(var) 
  use gridset
  implicit none

  real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)              :: sf_avr_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_avr_sf = var
end function sf_avr_sf
