C**********************************************************************
C**********************************************************************
C
      SUBROUTINE NLVISC
     I   ( U, V, W, EDFM1, VNLV,
     I     IDF,
     O     DUNLV, DVNLV, DWNLV,
     B     DENS0, FDZ, FDZM,
     D     NX, NZ, NXB, NZB, NROT )
C
C**********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C**********************************************************************
C
      DIMENSION
     \   U( -2:NXB, -2:NZB, NROT ),
     \   V( -2:NXB, -2:NZB, NROT ),
     \   W( -2:NXB, -2:NZB, NROT ),
     \   EDFM1( -2:NXB, -2:NZB ),
     \   DUNLV( -2:NXB, -2:NZB ),
     \   DVNLV( -2:NXB, -2:NZB ),
     \   DWNLV( -2:NXB, -2:NZB ),
     \   DENS0( -2:NZB ),
     \   FDZ ( -2:NZB ) ,
     \   FDZM( -2:NZB )
C
C======================================================================
C
      TNLV = 1000.0D0
C
      DO 11 IZ = 0, NZ
      DO 11 IX = 1, NX

         DUNLV(IX,IZ) =
     \     (   ( U(IX+1,IZ,IDF) - U(IX  ,IZ,IDF) )**3
     \       - ( U(IX  ,IZ,IDF) - U(IX-1,IZ,IDF) )**3
     \       + ( U(IX,IZ+1,IDF) - U(IX,IZ  ,IDF) )**3  * 0.1D0
     \       - ( U(IX,IZ  ,IDF) - U(IX,IZ-1,IDF) )**3  * 0.1D0  )
     \    / ( 16.0D0 * VNLV**2 * TNLV * DENS0(IZ) * FDZ(IZ) )
C
         DVNLV(IX,IZ) =
     \     (   ( V(IX+1,IZ,IDF) - V(IX  ,IZ,IDF) )**3
     \       - ( V(IX  ,IZ,IDF) - V(IX-1,IZ,IDF) )**3
     \       + ( V(IX,IZ+1,IDF) - V(IX,IZ  ,IDF) )**3  * 0.1D0
     \       - ( V(IX,IZ  ,IDF) - V(IX,IZ-1,IDF) )**3  * 0.1D0  )
     \    / ( 16.0D0 * VNLV**2 * TNLV * DENS0(IZ) * FDZ(IZ) )
C
         DWNLV(IX,IZ) =
     \     (   ( W(IX+1,IZ,IDF) - W(IX  ,IZ,IDF) )**3
     \       - ( W(IX  ,IZ,IDF) - W(IX-1,IZ,IDF) )**3
     \       + ( W(IX,IZ+1,IDF) - W(IX,IZ  ,IDF) )**3  * 0.1D0
     \       - ( W(IX,IZ  ,IDF) - W(IX,IZ-1,IDF) )**3  * 0.1D0  )
     \    / ( 16.0D0 * VNLV**2 * TNLV )
     \    / ( ( DENS0(IZ) + DENS0(IZ-1) ) / 2.0D0 )
     \    / FDZM(IZ)

   11 CONTINUE
C
C
C
      CALL BOUND ( DUNLV, NX, NZ, NXB, NZB, 1, 1, 1, 1 )
      CALL BOUND ( DVNLV, NX, NZ, NXB, NZB, 1, 1, 1, 1 )
      CALL BOUND ( DWNLV, NX, NZ, NXB, NZB, 1,-1, 0, 1 )
C
C=====================================================================
C
      RETURN
      E N D
