.TH SLARF l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
SLARF - applie a real elementary reflector H to a real m by n matrix C, from either the left or the right
.SH SYNOPSIS
.TP 18
SUBROUTINE SLARF(
SIDE, M, N, V, INCV, TAU, C, LDC, WORK )
.TP 18
.ti +4
CHARACTER
SIDE
.TP 18
.ti +4
INTEGER
INCV, LDC, M, N
.TP 18
.ti +4
REAL
TAU
.TP 18
.ti +4
REAL
C( LDC, * ), V( * ), WORK( * )
.SH PURPOSE
SLARF applies a real elementary reflector H to a real m by n matrix C, from either the left or the right. H is represented in the form 
      H = I - tau * v * v'
.br

where tau is a real scalar and v is a real vector.
.br

If tau = 0, then H is taken to be the unit matrix.
.br

.SH ARGUMENTS
.TP 8
SIDE    (input) CHARACTER*1
= 'L': form  H * C
.br
= 'R': form  C * H
.TP 8
M       (input) INTEGER
The number of rows of the matrix C.
.TP 8
N       (input) INTEGER
The number of columns of the matrix C.
.TP 8
V       (input) REAL array, dimension
(1 + (M-1)*abs(INCV)) if SIDE = 'L'
or (1 + (N-1)*abs(INCV)) if SIDE = 'R'
The vector v in the representation of H. V is not used if
TAU = 0.
.TP 8
INCV    (input) INTEGER
The increment between elements of v. INCV <> 0.
.TP 8
TAU     (input) REAL
The value tau in the representation of H.
.TP 8
C       (input/output) REAL array, dimension (LDC,N)
On entry, the m by n matrix C.
On exit, C is overwritten by the matrix H * C if SIDE = 'L',
or C * H if SIDE = 'R'.
.TP 8
LDC     (input) INTEGER
The leading dimension of the array C. LDC >= max(1,M).
.TP 8
WORK    (workspace) REAL array, dimension
(N) if SIDE = 'L'
or (M) if SIDE = 'R'
