!= Module HeatFlux
!
! Authors::   ODAKA Masatsugu, TAKAHASHI Yoshiyuki
! Version::   $Id: surfaceflux_bulk.f90,v 1.1 2012-10-01 06:25:03 odakker Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006-2012. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module Surfaceflux_bulk
  !
  != ǤΥեåη׻⥸塼
  !
  != Surface flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Louis et al. (1982) ˡ˴Ťɽ̥եå׻. 
  !
  ! Surface fluxes are calculated by using the scheme by Louis et al. (1982). 
  !
  !== References
  !
  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
  ! A short history of the PBL parameterization at ECMWF, 
  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
  ! 1982.
  !== Variable List
  !
  !== Procedures List
  !

  ! ⥸塼; USE statement
  !  

  ! GTOOL ѿȼ³
  ! GTOOL variables and procedures
  !
  use dc_types, only: DP, STRING
  use dc_iounit, only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  ! ѿ
  ! Parallel processing variable 
  !       
  Use mpi_wrapper,only: myrank

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imin, & ! x 󲼸 
    &                      & ! Upper limit of array in x
    &                imax, & ! x  
    &                      & ! Lower limit of array in x
    &                jmin, & ! y 󲼸 
    &                      & ! Upper limit of array in y
    &                jmax, & ! y  
    &                      & ! Lower limit of array in y
    &                kmin, & ! z 󲼸 
    &                      & ! Upper limit of array in z
    &                kmax, & ! z  
    &                      & ! Lower limit of array in z
    &                nx,   & ! x ʻ 
    &                      & ! Number of grid point in x
    &                ny,   & ! y ʻ 
    &                      & ! Number of grid point in y
    &                nz,   & ! z ʻ 
    &                      & ! Number of grid point in z
    &                ncmax   ! ο       
                             ! Number of spices

  use gridset_surfaceflux, only: GridsetSurfacefluxInit

  ! ɸȱ黻
  ! Axes and operator settings
  !
  use axesset, only: z_dz,        & ! z ʻֳ 
    &                             & ! Grid size in z
    &                xyz_Z,       & ! z ɸ
    &                             & ! z coordinate
    &                xyz_avr_pyz, & ! ʿ
    &                             & ! Average operator
    &                xyz_avr_xqz, & ! ʿ
    &                             & ! Average operator
    &                xyr_avr_xyz, & ! ʿ
    &                             & ! Average operator
    &                pyz_avr_xyz, & ! ʿ
    &                             & ! Average operator
    &                xqz_avr_xyz, & ! ʿ
    &                             & ! Average operator
    &                pyr_avr_xyr, & ! ʿ
    &                             & ! Average operator
    &                xqr_avr_xyr    ! ʿ
                                    ! Average operator

  ! ܾѿ
  ! Basic state variables
  !
  use basicset, only: xyz_ExnerBZ,  & ! ϴؿ
    &                               & ! Exner function
    &                 xyz_PressBZ,  & ! 
    &                               & ! Pressure
    &                 xyz_PTempBZ,  & ! 
    &                               & ! Potential temperature
    &                 xyz_TempBZ,   & ! 
    &                               & ! Temperature
    &                 xyzf_QMixBZ,  & ! 
    &                               & ! Mixing ration
    &                 xyz_DensBZ      ! ̩    
                                      ! Density

  ! 
  ! Constatns
  !
  use constants, only: Grav,       & ! ϲ®
    &                              & ! Gravity
    &                  MolWtDry,   & ! ʬ 
    &                              & ! Molecular weight of dry air
    &                  PressBasis, & ! ̤δవ
    &                              & ! Reference pressure
    &                  TempSfc,    & ! ɽ̲
    &                              & ! Surface temperature
    &                  PressSfc,   & ! ɽ̵
    &                              & ! Surface pressure
    &                  CpDry,      & ! 갵Ǯ 
    &                              & ! Specific heat of dry air
    &                  GasRDry       ! 
                                     ! Gas constant of dry air

  use constants0, only: FKarm        ! ޥ
                                     ! Karmann constant

  ! ˴ؤѿ
  ! Setting for atmospheric composition
  ! 
  use composition, only: IdxCG,       & ! ŷ()ź 
    &                                 & ! Index of vapor
    &                    IdxCC,       & ! ŷ()ź 
    &                                 & ! Index of cloud
    &                    IdxG,        & ! ŷ()ź 
    &                                 & ! Index of vapor
    &                    SpcWetID,    & !ŷʬβؼID
    &                                 & ! ID number of moist condensation spices
    &                    CondNum,     & ! ο
    &                                 & ! Number of cloud component
    &                    MolWtWet,    & ! ŷʬʬ
    &                                 & ! Molecular weight of moist air
    &                    SpcWetSymbol   ! ŷʬβؼ̾
                                        ! Chemical formula of condensation spices

  ! ̷׻˴ؤ
  ! Settings for chemical calculation
  !
  use chemcalc, only: SvapPress ! ˰¾
                                ! Saturation vapor pressure

  ! NAMELIST ˴ؤ
  ! Settings for NAMELIST
  !
  use namelist_util, only: namelist_filename ! NAMELIST ե̾
                                             ! NAMELIST file name
  ! ˴ؤ
  ! Setting for time
  !
  use timeset, only:  TimeN !  t 
                            ! Time "t"

  ! Ѳ
  ! Tendency of variable
  use DExnerDt, only: xy_DExnerDt_xy_xyf ! D$\pi$/Dt

  ! dcpam Ϣ⥸塼
  use surfaceflux_bulk_core, only: SurfaceFluxInit_Core => SurfaceFluxInit, &
                                    SurfaceFlux_Core => SurfaceFlux

  ! ۤηػ
  ! Implicit none
  !
  implicit none

  ! °λ
  !
  private

  ! ³
  ! Public procedure
  !
  public surfaceflux_bulk_init
  public surfaceflux_bulk_forcing

  ! ѿ
  ! Privete variables
  ! 
  logical, save:: FlagConstBulkCoef
                            ! Flag for using constant bulk coefficient
  logical, save:: FlagUseOfBulkCoefInNeutralCond
                            ! Flag for using bulk coefficient in neutral condition
  real(DP), save:: ConstBulkCoef
                            ! Х륯. 
                            ! Steady value of bulk coefficient
  real(DP), save :: VelMinForRi = 1.0d-8 
                            ! 㡼ɿ׻®ٲ
                            ! Lower limit of velocity for Ri
  real(DP), save :: SfcRoughLength = 1.0d-2
                            ! Ĺ
                            ! Roughness length
  real(DP), save :: VelBulkCoefMin = 0.0d0
                            ! $ u $ Х륯Ǿ. 
                            ! Minimum value of $ u $ bulk coefficient
  real(DP), save :: TempBulkCoefMin = 0.0d0
                            ! $ T $ Х륯Ǿ. 
                            ! Minimum value of $ T $ bulk coefficient
  real(DP), save :: QmixBulkCoefMin = 0.0d0
                            ! $ q $ Х륯Ǿ. 
                            ! Minimum value of $ q $ bulk coefficient
  real(DP), save :: VelBulkCoefMax = 1.0d2
                            ! $ u $ Х륯. 
                            ! Maximum value of $ u $ bulk coefficient
  real(DP), save :: TempBulkCoefMax = 1.0d2
                            ! $ T $ Х륯. 
                            ! Maximum value of $ T $ bulk coefficient
  real(DP), save :: QmixBulkCoefMax = 1.0d2
                            ! $ q $ Х륯. 
                            ! Maximum value of $ q $ bulk coefficient

  real(DP), save :: PTempFluxMin = 0.0d0
                            ! ̥եåǾ. 
                            ! Minimum value of potential temp. flux
  real(DP), save :: ExnerFluxMin = 0.0d0
                            ! ϴؿեåǾ. 
                            ! Minimum value of exner function flux
  real(DP), save :: QmixFluxMin = 0.0d0
                            ! եåǾ. 
                            ! Minimum value of mixing ratio flux
  real(DP), save  :: Vel0 = 0.0d0  ! ؤǤοʿ®ٿ夲
                                   ! 

  character(*), parameter:: module_name = 'surfaceflux_bulk'
                                   ! ⥸塼̾.
                                   ! Module name

contains
!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Bulk_init
    !
    ! NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    ! ۤηػ
    ! Implicit none
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer    :: l,   &! ˲ DO 롼Ѻѿ
      &                & ! Work variables for DO loop in dimension of constituents
      &           unit   ! ֹ
                         ! Device number 

    !---------------------------------------------------------------
    ! ʻν
    !
    call GridsetSurfacefluxInit

    !---------------------------------------------------------------
    ! NAMELIST 
    !
!    NAMELIST /surface_flux_bulk_nml/ &
!      &  SfcRoughLength, Vel0                 

!    call FileOpen(unit, file=namelist_filename, mode='r')
!    read(unit, NML=surface_flux_bulk_nml)
!    close(unit)  

    ! dcpam νץ call
    call SurfaceFluxInit_Core

!    if (myrank == 0) then 
!      call MessageNotify( "M", module_name, "SfcRoughLength = %f",  &
!        &  d=(/SfcRoughLength/))
!      call MessageNotify( "M", module_name, "Vel0 = %f", d=(/Vel0/))
!    end if

    call HistoryAutoAddVariable(      &
      & varname='PTempSfcFlux',       &
      & dims=(/'x','y','t'/),         &
      & longname='surface potential temperature flux (heat flux divided by density and specific heat)', &
      & units='K.m.s-1',             &
      & xtype='float')

    call HistoryAutoAddVariable(      &
      & varname='ExnerSfcFlux',       &
      & dims=(/'x','y','t'/),         &
      & longname='surface exner function flux (heat flux divided by density and specific heat)', &
      & units='s-1',             &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSfcFlux',    &
      & dims=(/'x','y','t'/),     &
      & longname='surface flux of x-component of velocity (momentum flux divided by density)', &
      & units='m2.s-2',           &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSfcFlux',    &
      & dims=(/'x','y','t'/),     &
      & longname='surface flux of y-component of velocity (momentum flux divided by density)', &
      & units='m2.s-2',           &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_SfcFlux', & 
        & dims=(/'x','y','t'/),     &
        & longname='surface flux of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio (mass flux divided by density)',  &
        & units='m.s-1',    &
        & xtype='float')
    end do


    call HistoryAutoAddVariable(  &
      & varname='PTempSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='potential temperature tendency by surface flux', &
      & units='K.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='exner function tendency by surface flux', &
      & units='K.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='x-component velocity tendency by surface flux', &
      & units='m.s-2',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='y-component velocity tendency by surface flux', &
      & units='m.s-2',            &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Sfc', & 
        & dims=(/'x','y','z','t'/),     &
        & longname=trim(SpcWetSymbol(l))//' mixing ratio tendency by surface flux',  &
        & units='s-1',    &
        & xtype='float')
    end do


    call HistoryAutoAddVariable(       &
      & varname='SfcHeatFlux',         &
      & dims=(/'x','y','t'/),          &
      & longname='surface heat flux',  &
      & units='W.m-2',                 &
      & xtype='float')

    call HistoryAutoAddVariable(                      &
      & varname='SfcXMomFlux',                        &
      & dims=(/'x','y','t'/),                         &
      & longname='surface x-component momentum flux', &
      & units='kg.m-2.s-1',                           &
      & xtype='float')

    call HistoryAutoAddVariable(                      &
      & varname='SfcYMomFlux',                        &
      & dims=(/'x','y','t'/),                         &
      & longname='surface y-component momentum flux', &
      & units='kg.m-2.s-1',                           &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(                               &
        & varname=trim(SpcWetSymbol(l))//'_SfcMassFlux',         &
        & dims=(/'x','y','t'/),                              &
        & longname=trim(SpcWetSymbol(l))//' surface mass flux',  &
        & units='kg.m-2.s-1',                                    &
        & xtype='float')
    end do

  end subroutine Surfaceflux_Bulk_init
!!!------------------------------------------------------------------------!!!
  !---------------------------------------------------------------
  ! ɽ̲ my_sfcTemp ɲ (mkuriki)
  ! subroutine Surfaceflux_Bulk_forcing( &
  !   &   pyz_VelX, xqz_VelY, xyz_PTemp, xyz_Exner, xyzf_QMix, &
  !   &   pyz_DVelXDt, xqz_DVelYDt, xyz_DPTempDt, xyz_DExnerDt, xyzf_DQMixDt &
  !   & )
  subroutine Surfaceflux_Bulk_forcing( &
    &   pyz_VelX, xqz_VelY, xyz_PTemp, xyz_Exner, xyzf_QMix, &
    &   pyz_DVelXDt, xqz_DVelYDt, xyz_DPTempDt, xyz_DExnerDt, xyzf_DQMixDt, &
    &   my_sfcTemp &
    & )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    ! ۤηػ
    ! Implicit none
    !
    implicit none

    ! ѿ
    ! variables
    !
    real(DP), intent(in)   :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ®
                              ! X-component velocity
    real(DP), intent(in)   :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ®
                              ! Y-component velocity
    real(DP), intent(in)   :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
                              ! 
                              ! Potential temperature
    real(DP), intent(in)   :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿ
                              ! Exner function
    real(DP), intent(in)   :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! 
                              ! Mixing ration
    real(DP), intent(inout):: pyz_DVelXDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ®ѲΨ
                              ! X-component velocity tendency
    real(DP), intent(inout):: xqz_DVelYDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ®ѲΨ
                              ! Y-component velocity tendency
    real(DP), intent(inout):: xyz_DPTempDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ̻ѲΨ
                              ! Potential tempreture tendency
    real(DP), intent(inout):: xyz_DExnerDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿѲΨ
                              ! Exner function tendency
    real(DP), intent(inout):: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! ѲΨ
                              ! Mixing ratio tendency

    ! ѿ
    ! Work variables
    real(DP) :: xy_SurfRoughLength(imin:imax,jmin:jmax)
                              ! Ĺ
                              ! Roughness length
    real(DP) :: xy_SurfTemp(imin:imax,jmin:jmax)
                              ! ɽ̲
                              ! surface temperature
    real(DP) :: xy_SurfHumidCoef(imin:imax,jmin:jmax)
                              ! 
                              ! 
    real(DP) :: xy_SurfHeight(imin:imax,jmin:jmax)
                              ! 
                              ! 
    real(DP) :: xy_SurfVelTransCoef(imin:imax,jmin:jmax)
                              ! Х륯(ư)
                              ! Bulk coefficient for momentum
    real(DP) :: xy_SurfTempTransCoef(imin:imax,jmin:jmax)
                              ! Х륯(Ǯ)
                              ! Bulk coefficient for heat
    real(DP) :: xy_SurfQMixTransCoef(imin:imax,jmin:jmax)
                              ! Х륯()
                              ! Bulk coefficient for mixing ratio
    real(DP) :: xyr_MomFluxX(imin:imax,jmin:jmax,kmin:kmax)
                              ! x ư̥եå
                              ! momentum flux in x
    real(DP) :: pyr_MomFluxX(imin:imax,jmin:jmax,kmin:kmax)
                              ! x ư̥եå
                              ! momentum flux in x
    real(DP) :: xyr_MomFluxY(imin:imax,jmin:jmax,kmin:kmax)
                              ! y ư̥եå
                              ! momentum flux in y
    real(DP) :: xqr_MomFluxY(imin:imax,jmin:jmax,kmin:kmax)
                              ! y ư̥եå
                              ! momentum flux in y
    real(DP) :: xyr_HeatFlux(imin:imax,jmin:jmax,kmin:kmax)
                              ! Ǯեå
                              ! heat flux
    real(DP) :: xyrf_QMixFlux(imin:imax,jmin:jmax,kmin:kmax,ncmax)
                              ! ŷʬեå
                              ! Mixing ratio flux
    real(DP) :: xy_PTempFlux(imin:imax,jmin:jmax)
                              ! ̥եå
                              ! Potential temperature flux
    real(DP) :: py_VelXFlux(imin:imax,jmin:jmax)
                              ! ®٥եå
                              ! velocity flux
    real(DP) :: xq_VelYFlux(imin:imax,jmin:jmax)
                              ! ®٥եå
                              ! velocity flux
    real(DP) :: xyf_QMixFlux(imin:imax,jmin:jmax,ncmax)
                              ! ŷʬեå
                              ! Mixing ratio flux
    real(DP) :: xy_ExnerFlux(imin:imax,jmin:jmax)
                              !
                              !
    real(DP) :: xyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xyz ʻ)
                              ! X-component velocity (xyz grid)
    real(DP) :: xyz_VelY(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xyz ʻ)
                              ! Y-component velocity (xyz grid)
    real(DP) :: xyz_PTempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of potential temperature
    real(DP) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of potential temperature
    real(DP) :: xyr_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of potential temperature
    real(DP) :: xyz_VirTempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of virtual temperature
    real(DP) :: xyr_VirTempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of virtual temperature
    real(DP) :: xyz_ExnerAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿ(ܾ + )
                              ! Total value of exner function
    real(DP) :: xyr_ExnerAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿ(ܾ + )
                              ! Total value of exner function
    real(DP) :: xyz_PressAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of pressure
    real(DP) :: xyr_PressAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of pressure
    real(DP) :: xyz_DensAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of pressure
    real(DP) :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! (ܾ + )
                              ! Total value of mixing ratios
    real(DP) :: xyzf_QMixPerMolWt(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! (ܾ + )/ʬ
                              ! mixing ratios per molecular weight

    real(DP) :: xy_DPTempDtBulk(imin:imax,jmin:jmax)
                              ! Ѳ()
                              ! potential temperature tendency by surface flux
    real(DP) :: xy_DExnerDtBulk(imin:imax,jmin:jmax)
                              ! Ѳ(ϴؿ)
                              ! Exner function tendency by surface flux
    real(DP) :: xyf_DQMixDtBulk(imin:imax,jmin:jmax, ncmax)
                              ! Ѳ()
                              ! Mixing ratio tendency by surface flux
    real(DP) :: py_DVelXDtBulk (imin:imax,jmin:jmax)
                              ! Ѳ(U)
                              ! x-component velocity tendency by surface flux
    real(DP) :: xq_DVelYDtBulk (imin:imax,jmin:jmax)
                              ! Ѳ(V)
                              ! y-component velocity tendency by surface flux
    real(DP) :: xyz_DPTempDtBulk(imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ()
                              ! potential temperature tendency by surface flux
    real(DP) :: xyz_DExnerDtBulk(imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(ϴؿ)
                              ! Exner function tendency by surface flux
    real(DP) :: xyzf_DQMixDtBulk(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! Ѳ()
                              ! Mixing ratio tendency by surface flux
    real(DP) :: pyz_DVelXDtBulk (imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(U)
                              ! x-component velocity tendency by surface flux
    real(DP) :: xqz_DVelYDtBulk (imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(V)
                              ! y-component velocity tendency by surface flux
    integer  :: kz            ! ź
                              ! Arrzy index
    integer  :: s             ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituen                         

    ! 
    ! Initialization
    ! 
    kz = 1

!    xyr_MomFluxX = 0.0d0
!    xyr_MomFluxY = 0.0d0
!    xyr_HeatFlux = 0.0d0
!    xyrf_QMixFlux = 0.0d0
!    xy_SurfVelTransCoef = 0.0d0
!    xy_SurfTempTransCoef = 0.0d0
!    xy_SurfQMixTransCoef = 0.0d0

    ! Ĺλ
    ! Specify surface length

    ! ɽͤλ
    ! Specify surface values
    xy_SurfHeight = 0.0d0
    ! ----------------------------------------
    ! 老ȤѤ my_sfcTemp ɽ̲٤Ȥ (mkuriki)
    ! xy_SurfTemp = TempSfc
    xy_SurfTemp = my_sfcTemp
    xy_SurfHumidCoef = 1.0d0
    xy_SurfRoughLength = SfcRoughLength

    ! ̤η׻
    ! Calculate total value of thermodynamic variables
    ! 
!    xyz_PTempAll  = xyz_PTemp + xyz_PTempBZ
!    xyz_ExnerAll  = xyz_Exner + xyz_ExnerBZ
!    xyzf_QMixAll  = xyzf_QMix + xyzf_QMixBZ

    xyz_PTempAll  = xyz_PTempBZ
    xyz_ExnerAll  = xyz_ExnerBZ
    xyzf_QMixAll  = xyzf_QMixBZ

    xyz_TempAll   = xyz_PTempAll * xyz_ExnerAll
    xyr_TempAll   = xyr_avr_xyz(xyz_TempAll)

    do s = 1, ncmax
      xyzf_QMixPerMolWt(:,:,:,s) = xyzf_QMixAll(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do

!    xyz_VirTempAll = xyz_TempAll / &
!      & (                          &
!      &   (1.0d0 / ( 1.0d0 + MolWtDry * sum(xyzf_QMixPerMolWt, 4) ) ) /  & 
!      &   (1.0d0 + sum(xyzf_QMixAll, 4))     &
!      & )
!    xyr_VirTempAll = xyr_avr_xyz(xyz_VirTempAll)

    xyz_VirTempAll = xyz_TempAll
    xyr_VirTempAll = xyr_avr_xyz(xyz_TempAll)

    xyz_PressAll  = PressBasis * xyz_ExnerAll**(CpDry / GasRDry)
    xyr_PressAll  = xyr_avr_xyz(xyz_PressAll)
    xyr_ExnerAll  = xyr_avr_xyz(xyz_ExnerAll)

    xyz_DensAll   = xyz_PressAll / (GasRDry * xyz_VirTempAll)

    write(*,*) 'ExnerAll(0,0,0)=', xyr_ExnerAll(1,1,0) 
    write(*,*) 'ExnerAll(0,0,1)=', xyz_ExnerAll(1,1,1)
    write(*,*) 'TempAll(0,0,1)=', xyz_TempAll(1,1,1)
!    write(*,*) 'PTempAll(0,0,1)=', xyz_PTempAll(0,0,1)
    write(*,*) 'DensAll(0,0,1)=', xyz_DensAll(1,1,1)
    write(*,*) 'SurfTemp(0,0)=', xy_SurfTemp(1,1)
    

    ! Perturbation component of Exner function at the surface is assumed 
    ! to be same as that at the lowest layer. (YOT, 2011/09/03)
    ! 
    !ExnerBZSfc    = (PressSfc / PressBasis) ** (GasRDry / CpDry)
    !xy_PressSfc   = (PressBasis * xyz_ExnerAll(:,:,kz))**(CpDry / GasRDry)

    ! xyz ʻ®٤η׻
    ! Calculate velocities at xyz grid points
    !
    xyz_VelX = xyz_avr_pyz(pyz_VelX)
    xyz_VelY = xyz_avr_xqz(xqz_VelY)

    ! եåη׻
    ! Surface fluxes are calculated. 
    !
    ! dcpam  call
    ! 
    xyrf_QMixFlux = 0.0_DP
    xyf_QMixFlux  = 0.0_DP

    call SurfaceFlux_Core( &
      & xyz_VelX   (1:nx,1:ny,1:nz), & ! (in)
      & xyz_VelY   (1:nx,1:ny,1:nz), & ! (in)
      & xyz_TempAll(1:nx,1:ny,1:nz), & ! (in)
      & xyr_TempAll(1:nx,1:ny,0:nz), & ! (in)
      & xyr_VirTempAll(1:nx,1:ny,0:nz), & ! (in)
      & xyzf_QMixAll(1:nx,1:ny,1:nz,1:ncmax), & ! (in)
      & xyr_PressAll(1:nx,1:ny,0:nz), & ! (in)
      & xy_SurfHeight(1:nx,1:ny),     & ! (in)
      & xyz_Z(1:nx,1:ny,1:nz),        & ! (in)
      & xyz_ExnerAll(1:nx,1:ny,1:nz), & ! (in)
      & xyr_ExnerAll(1:nx,1:ny,0:nz), & ! (in)
      & xy_SurfTemp(1:nx,1:ny),       & ! (in)
      & xy_SurfHumidCoef(1:nx,1:ny),  & ! (in)
      & xy_SurfRoughLength(1:nx,1:ny),& ! (in)
      & xyr_MomFluxX(1:nx,1:ny,0:nz), & ! (inout)
      & xyr_MomFluxY(1:nx,1:ny,0:nz), & ! (inout)
      & xyr_HeatFlux(1:nx,1:ny,0:nz), & ! (inout)
      & xyrf_QMixFlux(1:nx,1:ny,0:nz,1:ncmax), & ! (inout)
      & xy_SurfVelTransCoef(1:nx,1:ny), & ! (inout)
      & xy_SurfTempTransCoef(1:nx,1:ny),& ! (out)
      & xy_SurfQMixTransCoef(1:nx,1:ny) & ! (out)
      & )


    ! եåѴ
    ! convert surface flux
    !
    pyr_MomFluxX = pyr_avr_xyr(xyr_MomFluxX)
    xqr_MomFluxY = xqr_avr_xyr(xyr_MomFluxY)

    xy_PTempFlux(1:nx,1:ny) = xyr_HeatFlux(1:nx,1:ny,0)/ &
      &                         xyz_DensAll(1:nx,1:ny,kz) / CpDry
    py_VelXFlux(1:nx,1:ny)  = pyr_MomFluxX(1:nx,1:ny,0)/ &
      &                         xyz_DensAll(1:nx,1:ny,kz)
    xq_VelYFlux(1:nx,1:ny)  = xqr_MomFluxY(1:nx,1:ny,0)/ &
      &                         xyz_DensAll(1:nx,1:ny,kz)

    xyf_QMixFlux(1:nx,1:ny,:) = xyrf_QmixFlux(1:nx,1:ny,0,:)


    ! ζη׻
    ! 
    xy_ExnerFlux = xy_DExnerDt_xy_xyf(xy_PTempFlux, xyf_QMixFlux, kz)


    ! ɽեåˤѲ׻
    ! Tendencies by surface fluxes (convergences of fluxes) are calculated.
    !
    xy_DPTempDtBulk = - ( 0.0d0 - xy_PTempFlux ) / z_dz(kz)
    !
    xy_DExnerDtBulk = - ( 0.0d0 - xy_ExnerFlux ) / z_dz(kz)
    !
    xyf_DQMixDtBulk = - ( 0.0d0 - xyf_QMixFlux ) / z_dz(kz)
    !
    py_DVelXDtBulk = - ( 0.0d0 - py_VelXFlux ) / z_dz(kz)
    !
    xq_DVelYDtBulk = - ( 0.0d0 - xq_VelYFlux ) / z_dz(kz)

    
    ! سǼ
    ! Add tendency by surface flux convergence
    !
    xyz_DPTempDt(:,:,kz) = xyz_DPTempDt(:,:,kz) + xy_DPTempDtBulk
    xyz_DExnerDt(:,:,kz) = xyz_DExnerDt(:,:,kz) + xy_DExnerDtBulk
    do s = 1, ncmax
      xyzf_DQMixDt(:,:,kz,s) = xyzf_DQMixDt(:,:,kz,s) + xyf_DQMixDtBulk(:,:,s)
    end do
    pyz_DVelXDt (:,:,kz) = pyz_DVelXDt (:,:,kz) + py_DVelXDtBulk
    xqz_DVelYDt (:,:,kz) = xqz_DVelYDt (:,:,kz) + xq_DVelYDtBulk

    ! 
    ! Output
    !
    xyz_DPTempDtBulk = 0.0d0
    xyz_DExnerDtBulk = 0.0d0
    xyzf_DQMixDtBulk = 0.0d0
    pyz_DVelXDtBulk  = 0.0d0
    xqz_DVelYDtBulk  = 0.0d0

    xyz_DPTempDtBulk(:,:,kz) = xy_DPTempDtBulk
    xyz_DExnerDtBulk(:,:,kz) = xy_DExnerDtBulk
    do s = 1, ncmax
      xyzf_DQMixDtBulk(:,:,kz,s) = xyf_DQMixDtBulk(:,:,s)
    end do
    pyz_DVelXDtBulk (:,:,kz) = py_DVelXDtBulk
    xqz_DVelYDtBulk (:,:,kz) = xq_DVelYDtBulk
    !
    call HistoryAutoPut(TimeN, 'PTempSfc', xyz_DPTempDtBulk(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerSfc', xyz_DExnerDtBulk(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSfc',  pyz_DVelXDtBulk (1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSfc',  xqz_DVelYDtBulk (1:nx,1:ny,1:nz))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_Sfc', &
        & xyzf_DQMixDtBulk(1:nx,1:ny,1:nz,s))
    end do

    call HistoryAutoPut(TimeN, 'PTempSfcFlux', xy_PTempFlux(1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'ExnerSfcFlux', xy_ExnerFlux(1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'VelXSfcFlux',  py_VelXFlux (1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'VelYSfcFlux',  xq_VelYFlux (1:nx,1:ny))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_SfcFlux', &
        & xyf_QMixFlux(1:nx,1:ny,s))
    end do

    call HistoryAutoPut(TimeN, 'SfcHeatFlux', xyr_HeatFlux(1:nx,1:ny,0) )
    call HistoryAutoPut(TimeN, 'SfcXMomFlux', xyr_MomFluxX(1:nx,1:ny,0) )
    call HistoryAutoPut(TimeN, 'SfcYMomFlux', xyr_MomFluxY(1:nx,1:ny,0) )
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_SfcMassFlux', &
        & xyz_DensAll(1:nx,1:ny,1) * xyf_QMixFlux(1:nx,1:ny,s))
    end do

  end subroutine Surfaceflux_Bulk_forcing
!!!------------------------------------------------------------------------!!!  
end module Surfaceflux_bulk
