module gms_def_var
  use datatype
  use model_info
  use mem_manager
  implicit none

  interface def_var
     module procedure def_var_x
     module procedure def_var_y
     module procedure def_var_z
     module procedure def_var_xy
     module procedure def_var_xz
     module procedure def_var_yz
     module procedure def_var_xyz
  end interface

contains
  subroutine def_var_x(input, grid)
    type(var_x), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_x(input)

    input%grid(1) = grid(1)
    input%grid(2) = gms_none_grid
    input%grid(3) = gms_none_grid

  end subroutine def_var_x

  subroutine def_var_y(input, grid)
    type(var_y), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_y(input)

    input%grid(1) = gms_none_grid
    input%grid(2) = grid(2)
    input%grid(3) = gms_none_grid

  end subroutine def_var_y

  subroutine def_var_z(input, grid)
    type(var_z), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_z(input)

    input%grid(1) = gms_none_grid
    input%grid(2) = gms_none_grid
    input%grid(3) = grid(3)

  end subroutine def_var_z

  subroutine def_var_xy(input, grid)
    type(var_xy), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_xy(input)

    input%grid(1) = grid(1)
    input%grid(2) = grid(2)
    input%grid(3) = gms_none_grid

  end subroutine def_var_xy

  subroutine def_var_xz(input, grid)
    type(var_xz), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_xz(input)

    input%grid(1) = grid(1)
    input%grid(2) = gms_none_grid
    input%grid(3) = grid(3)

  end subroutine def_var_xz

  subroutine def_var_yz(input, grid)
    type(var_yz), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_yz(input)

    input%grid(1) = gms_none_grid
    input%grid(2) = grid(2)
    input%grid(3) = grid(3)

  end subroutine def_var_yz

  subroutine def_var_xyz(input, grid)
    type(var_xyz), intent(inout):: input
    integer, intent(in) :: grid(3)

    call set_save_var_xyz(input)

    input%grid(1) = grid(1)
    input%grid(2) = grid(2)
    input%grid(3) = grid(3)
    
  end subroutine def_var_xyz

end module gms_def_var
