module gms_get
  use model_info
  use datatype
  use mem_manager
  implicit none

  interface get
     module procedure get_x
     module procedure get_y
     module procedure get_z
     module procedure get_xy
     module procedure get_xz
     module procedure get_yz
     module procedure get_xyz
  end interface
contains
  function get_x(input) result(output)
    type(var_x) ::input
    real(8), dimension(plb1+input%grid(1):pub1) ::output


    output(plb1+input%grid(1):pub1) = work_x(plb1+input%grid(1):pub1,1,1,input%id)
  end function get_x

  function get_y(input) result(output)
    type(var_y) ::input
    real(8), dimension(plb2+input%grid(2):pub2) ::output


    output(plb2+input%grid(2):pub2) = work_y(1,plb2+input%grid(2):pub2,1,input%id)
  end function get_y

  function get_z(input) result(output)
    type(var_z) ::input
    real(8), dimension(plb3+input%grid(3):pub3) ::output


    output(plb3+input%grid(3):pub3) = work_z(1,1,plb3+input%grid(3):pub3,input%id)
     end function get_z

  function get_xy(input) result(output)
    type(var_xy) ::input
    real(8), dimension(plb1+input%grid(1):pub1, plb2+input%grid(2):pub2) ::output


    output(plb1+input%grid(1):pub1, plb2+input%grid(2):pub2) &
 = work_xy(plb1+input%grid(1):pub1, plb2+input%grid(2):pub2,1,input%id)
  end function get_xy

  function get_xz(input) result(output)
    type(var_xz) ::input
    real(8), dimension(plb1+input%grid(1):pub1, plb3+input%grid(3):pub3) ::output


    output(plb1+input%grid(1):pub1, plb3+input%grid(3):pub3) &
 = work_xz(plb1+input%grid(1):pub1, 1, plb3+input%grid(3):pub3,input%id)
  end function get_xz

  function get_yz(input) result(output)
    type(var_yz) ::input
    real(8), dimension(plb2+input%grid(2):pub2, plb3+input%grid(3):pub3) ::output


    output(plb2+input%grid(2):pub2, plb3+input%grid(3):pub3) &
 = work_xz(1,plb2+input%grid(2):pub2, plb3+input%grid(3):pub3,input%id)
  end function get_yz

  function get_xyz(input) result(output)
    type(var_xyz) ::input
    real(8), dimension(plb1+input%grid(1):pub1,plb2+input%grid(2):pub2, plb3+input%grid(3):pub3) ::output


    output(plb1+input%grid(1):pub1,plb2+input%grid(2):pub2, plb3+input%grid(3):pub3) &
 = work_xyz(plb1+input%grid(1):pub1,plb2+input%grid(2):pub2, plb3+input%grid(3):pub3,input%id)
  end function get_xyz
  
end module gms_get
