module gms_math_function
  use datatype
  use mem_manager
  implicit none
  interface abs
    module procedure abs_x, abs_y, abs_z, abs_xy, abs_xz, abs_yz, abs_xyz
 end interface

  interface acos
    module procedure acos_x, acos_y, acos_z, acos_xy, acos_xz, acos_yz, acos_xyz
 end interface

  interface aint
    module procedure aint_x, aint_y, aint_z, aint_xy, aint_xz, aint_yz, aint_xyz
 end interface

  interface anint
    module procedure anint_x, anint_y, anint_z, anint_xy, anint_xz, anint_yz, anint_xyz
 end interface

  interface asin
    module procedure asin_x, asin_y, asin_z, asin_xy, asin_xz, asin_yz, asin_xyz
 end interface

  interface atan
    module procedure atan_x, atan_y, atan_z, atan_xy, atan_xz, atan_yz, atan_xyz
 end interface

  interface cosh
    module procedure cosh_x, cosh_y, cosh_z, cosh_xy, cosh_xz, cosh_yz, cosh_xyz
 end interface

  interface exp
    module procedure exp_x, exp_y, exp_z, exp_xy, exp_xz, exp_yz, exp_xyz
 end interface

  interface log
    module procedure log_x, log_y, log_z, log_xy, log_xz, log_yz, log_xyz
 end interface

  interface log10
    module procedure log10_x, log10_y, log10_z, log10_xy, log10_xz, log10_yz, log10_xyz
 end interface

  interface sin
    module procedure sin_x, sin_y, sin_z, sin_xy, sin_xz, sin_yz, sin_xyz
 end interface

  interface sinh
    module procedure sinh_x, sinh_y, sinh_z, sinh_xy, sinh_xz, sinh_yz, sinh_xyz
 end interface

  interface sqrt
    module procedure sqrt_x, sqrt_y, sqrt_z, sqrt_xy, sqrt_xz, sqrt_yz, sqrt_xyz
 end interface

  interface tan
    module procedure tan_x, tan_y, tan_z, tan_xy, tan_xz, tan_yz, tan_xyz
 end interface

  interface tanh
    module procedure tanh_x, tanh_y, tanh_z, tanh_xy, tanh_xz, tanh_yz, tanh_xyz
 end interface

  interface atan2
    module procedure atan2_x, atan2_y, atan2_z, atan2_xy, atan2_xz, atan2_yz, atan2_xyz
     module procedure atan2_real_x, atan2_real_y, atan2_real_z, atan2_real_xy, atan2_real_xz, atan2_real_yz, atan2_real_xyz
     module procedure atan2_x_real, atan2_y_real, atan2_z_real, atan2_xy_real, atan2_xz_real, atan2_yz_real, atan2_xyz_real
 end interface

  interface max
    module procedure max_x, max_y, max_z, max_xy, max_xz, max_yz, max_xyz
     module procedure max_real_x, max_real_y, max_real_z, max_real_xy, max_real_xz, max_real_yz, max_real_xyz
     module procedure max_x_real, max_y_real, max_z_real, max_xy_real, max_xz_real, max_yz_real, max_xyz_real
 end interface

  interface min
    module procedure min_x, min_y, min_z, min_xy, min_xz, min_yz, min_xyz
     module procedure min_real_x, min_real_y, min_real_z, min_real_xy, min_real_xz, min_real_yz, min_real_xyz
     module procedure min_x_real, min_y_real, min_z_real, min_xy_real, min_xz_real, min_yz_real, min_xyz_real
 end interface

  interface mod
    module procedure mod_x, mod_y, mod_z, mod_xy, mod_xz, mod_yz, mod_xyz
     module procedure mod_real_x, mod_real_y, mod_real_z, mod_real_xy, mod_real_xz, mod_real_yz, mod_real_xyz
     module procedure mod_x_real, mod_y_real, mod_z_real, mod_xy_real, mod_xz_real, mod_yz_real, mod_xyz_real
 end interface

  interface modulo
    module procedure modulo_x, modulo_y, modulo_z, modulo_xy, modulo_xz, modulo_yz, modulo_xyz
     module procedure modulo_real_x, modulo_real_y, modulo_real_z, modulo_real_xy, modulo_real_xz, modulo_real_yz, modulo_real_xyz
     module procedure modulo_x_real, modulo_y_real, modulo_z_real, modulo_xy_real, modulo_xz_real, modulo_yz_real, modulo_xyz_real
 end interface

  interface sign
    module procedure sign_x, sign_y, sign_z, sign_xy, sign_xz, sign_yz, sign_xyz
     module procedure sign_real_x, sign_real_y, sign_real_z, sign_real_xy, sign_real_xz, sign_real_yz, sign_real_xyz
     module procedure sign_x_real, sign_y_real, sign_z_real, sign_xy_real, sign_xz_real, sign_yz_real, sign_xyz_real
 end interface

contains
  function abs_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = abs(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_x

  function abs_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = abs(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_y

  function abs_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = abs(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_z

  function abs_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = abs(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_xy

  function abs_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = abs(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_xz

  function abs_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = abs(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_yz

  function abs_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = abs(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function abs_xyz

  function acos_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = acos(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_x

  function acos_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = acos(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_y

  function acos_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = acos(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_z

  function acos_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = acos(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_xy

  function acos_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = acos(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_xz

  function acos_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = acos(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_yz

  function acos_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = acos(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function acos_xyz

  function aint_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = aint(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_x

  function aint_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = aint(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_y

  function aint_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = aint(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_z

  function aint_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = aint(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_xy

  function aint_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = aint(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_xz

  function aint_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = aint(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_yz

  function aint_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = aint(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function aint_xyz

  function anint_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = anint(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_x

  function anint_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = anint(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_y

  function anint_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = anint(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_z

  function anint_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = anint(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_xy

  function anint_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = anint(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_xz

  function anint_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = anint(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_yz

  function anint_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = anint(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function anint_xyz

  function asin_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = asin(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_x

  function asin_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = asin(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_y

  function asin_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = asin(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_z

  function asin_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = asin(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_xy

  function asin_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = asin(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_xz

  function asin_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = asin(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_yz

  function asin_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = asin(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function asin_xyz

  function atan_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = atan(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_x

  function atan_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = atan(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_y

  function atan_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = atan(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_z

  function atan_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = atan(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_xy

  function atan_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = atan(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_xz

  function atan_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = atan(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_yz

  function atan_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = atan(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function atan_xyz

  function cosh_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = cosh(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_x

  function cosh_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = cosh(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_y

  function cosh_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = cosh(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_z

  function cosh_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = cosh(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_xy

  function cosh_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = cosh(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_xz

  function cosh_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = cosh(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_yz

  function cosh_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = cosh(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function cosh_xyz

  function exp_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = exp(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_x

  function exp_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = exp(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_y

  function exp_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = exp(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_z

  function exp_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = exp(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_xy

  function exp_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = exp(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_xz

  function exp_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = exp(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_yz

  function exp_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = exp(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function exp_xyz

  function log_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = log(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_x

  function log_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = log(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_y

  function log_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = log(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_z

  function log_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = log(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_xy

  function log_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = log(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_xz

  function log_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = log(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_yz

  function log_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = log(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log_xyz

  function log10_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = log10(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_x

  function log10_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = log10(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_y

  function log10_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = log10(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_z

  function log10_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = log10(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_xy

  function log10_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = log10(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_xz

  function log10_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = log10(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_yz

  function log10_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = log10(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function log10_xyz

  function sin_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sin(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_x

  function sin_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sin(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_y

  function sin_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sin(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_z

  function sin_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sin(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_xy

  function sin_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sin(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_xz

  function sin_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sin(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_yz

  function sin_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sin(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sin_xyz

  function sinh_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sinh(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_x

  function sinh_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sinh(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_y

  function sinh_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sinh(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_z

  function sinh_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sinh(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_xy

  function sinh_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sinh(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_xz

  function sinh_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sinh(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_yz

  function sinh_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sinh(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sinh_xyz

  function sqrt_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sqrt(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_x

  function sqrt_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sqrt(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_y

  function sqrt_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sqrt(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_z

  function sqrt_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sqrt(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_xy

  function sqrt_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sqrt(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_xz

  function sqrt_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sqrt(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_yz

  function sqrt_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sqrt(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function sqrt_xyz

  function tan_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = tan(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_x

  function tan_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = tan(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_y

  function tan_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = tan(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_z

  function tan_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = tan(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_xy

  function tan_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = tan(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_xz

  function tan_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = tan(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_yz

  function tan_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = tan(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tan_xyz

  function tanh_x(input) result(output)
    type(var_x), intent(in) :: input
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = tanh(work_x(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_x

  function tanh_y(input) result(output)
    type(var_y), intent(in) :: input
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = tanh(work_y(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_y

  function tanh_z(input) result(output)
    type(var_z), intent(in) :: input
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = tanh(work_z(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_z

  function tanh_xy(input) result(output)
    type(var_xy), intent(in) :: input
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = tanh(work_xy(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_xy

  function tanh_xz(input) result(output)
    type(var_xz), intent(in) :: input
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = tanh(work_xz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_xz

  function tanh_yz(input) result(output)
    type(var_yz), intent(in) :: input
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = tanh(work_yz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_yz

  function tanh_xyz(input) result(output)
    type(var_xyz), intent(in) :: input
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = tanh(work_xyz(:,:,:,input%id))

    output%id = new_id
    output%grid = input%grid
  end function tanh_xyz

  function atan2_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = atan2(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_x

  function atan2_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = atan2(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_x_real

  function atan2_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = atan2(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_y

  function atan2_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = atan2(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_y_real

  function atan2_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = atan2(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_z

  function atan2_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = atan2(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_z_real

  function atan2_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = atan2(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xy

  function atan2_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = atan2(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xy_real

  function atan2_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = atan2(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xz

  function atan2_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = atan2(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xz_real

  function atan2_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = atan2(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_yz

  function atan2_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = atan2(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_yz_real

  function atan2_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = atan2(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xyz

  function atan2_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = atan2(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function atan2_xyz_real

  function atan2_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = atan2(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_x

  function atan2_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = atan2(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_y

  function atan2_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = atan2(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_z

  function atan2_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = atan2(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_xy

  function atan2_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = atan2(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_xz

  function atan2_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = atan2(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_yz

  function atan2_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = atan2(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function atan2_real_xyz

  function max_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = max(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_x

  function max_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = max(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_x_real

  function max_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = max(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_y

  function max_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = max(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_y_real

  function max_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = max(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_z

  function max_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = max(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_z_real

  function max_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = max(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_xy

  function max_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = max(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_xy_real

  function max_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = max(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_xz

  function max_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = max(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_xz_real

  function max_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = max(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_yz

  function max_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = max(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_yz_real

  function max_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = max(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function max_xyz

  function max_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = max(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function max_xyz_real

  function max_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = max(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_x

  function max_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = max(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_y

  function max_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = max(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_z

  function max_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = max(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_xy

  function max_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = max(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_xz

  function max_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = max(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_yz

  function max_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = max(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function max_real_xyz

  function min_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = min(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_x

  function min_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = min(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_x_real

  function min_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = min(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_y

  function min_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = min(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_y_real

  function min_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = min(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_z

  function min_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = min(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_z_real

  function min_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = min(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_xy

  function min_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = min(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_xy_real

  function min_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = min(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_xz

  function min_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = min(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_xz_real

  function min_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = min(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_yz

  function min_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = min(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_yz_real

  function min_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = min(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function min_xyz

  function min_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = min(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function min_xyz_real

  function min_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = min(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_x

  function min_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = min(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_y

  function min_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = min(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_z

  function min_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = min(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_xy

  function min_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = min(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_xz

  function min_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = min(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_yz

  function min_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = min(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function min_real_xyz

  function mod_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = mod(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_x

  function mod_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = mod(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_x_real

  function mod_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = mod(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_y

  function mod_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = mod(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_y_real

  function mod_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = mod(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_z

  function mod_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = mod(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_z_real

  function mod_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = mod(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_xy

  function mod_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = mod(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_xy_real

  function mod_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = mod(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_xz

  function mod_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = mod(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_xz_real

  function mod_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = mod(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_yz

  function mod_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = mod(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_yz_real

  function mod_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = mod(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function mod_xyz

  function mod_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = mod(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function mod_xyz_real

  function mod_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = mod(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_x

  function mod_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = mod(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_y

  function mod_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = mod(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_z

  function mod_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = mod(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_xy

  function mod_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = mod(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_xz

  function mod_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = mod(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_yz

  function mod_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = mod(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function mod_real_xyz

  function modulo_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = modulo(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_x

  function modulo_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = modulo(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_x_real

  function modulo_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = modulo(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_y

  function modulo_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = modulo(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_y_real

  function modulo_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = modulo(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_z

  function modulo_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = modulo(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_z_real

  function modulo_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = modulo(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xy

  function modulo_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = modulo(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xy_real

  function modulo_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = modulo(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xz

  function modulo_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = modulo(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xz_real

  function modulo_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = modulo(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_yz

  function modulo_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = modulo(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_yz_real

  function modulo_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = modulo(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xyz

  function modulo_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = modulo(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function modulo_xyz_real

  function modulo_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = modulo(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_x

  function modulo_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = modulo(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_y

  function modulo_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = modulo(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_z

  function modulo_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = modulo(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_xy

  function modulo_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = modulo(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_xz

  function modulo_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = modulo(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_yz

  function modulo_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = modulo(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function modulo_real_xyz

  function sign_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1, input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sign(work_x(:,:,:,input1%id), work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_x

  function sign_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sign(work_x(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_x_real

  function sign_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1, input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sign(work_y(:,:,:,input1%id), work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_y

  function sign_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sign(work_y(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_y_real

  function sign_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1, input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sign(work_z(:,:,:,input1%id), work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_z

  function sign_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sign(work_z(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_z_real

  function sign_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1, input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sign(work_xy(:,:,:,input1%id), work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_xy

  function sign_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sign(work_xy(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_xy_real

  function sign_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1, input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sign(work_xz(:,:,:,input1%id), work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_xz

  function sign_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sign(work_xz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_xz_real

  function sign_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1, input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sign(work_yz(:,:,:,input1%id), work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_yz

  function sign_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sign(work_yz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_yz_real

  function sign_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1, input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sign(work_xyz(:,:,:,input1%id), work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input1%grid
  end function sign_xyz

  function sign_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1
    real(8), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sign(work_xyz(:,:,:,input1%id), input2)

    output%id = new_id
    output%grid = input1%grid
  end function sign_xyz_real

  function sign_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_x), intent(in) :: input2
    type(var_x) :: output
    integer :: new_id

    call get_new_id_x(new_id)

    work_x(:,:,:,new_id) = sign(input1, work_x(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_x

  function sign_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_y), intent(in) :: input2
    type(var_y) :: output
    integer :: new_id

    call get_new_id_y(new_id)

    work_y(:,:,:,new_id) = sign(input1, work_y(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_y

  function sign_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_z), intent(in) :: input2
    type(var_z) :: output
    integer :: new_id

    call get_new_id_z(new_id)

    work_z(:,:,:,new_id) = sign(input1, work_z(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_z

  function sign_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xy), intent(in) :: input2
    type(var_xy) :: output
    integer :: new_id

    call get_new_id_xy(new_id)

    work_xy(:,:,:,new_id) = sign(input1, work_xy(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_xy

  function sign_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xz), intent(in) :: input2
    type(var_xz) :: output
    integer :: new_id

    call get_new_id_xz(new_id)

    work_xz(:,:,:,new_id) = sign(input1, work_xz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_xz

  function sign_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_yz), intent(in) :: input2
    type(var_yz) :: output
    integer :: new_id

    call get_new_id_yz(new_id)

    work_yz(:,:,:,new_id) = sign(input1, work_yz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_yz

  function sign_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1
    type(var_xyz), intent(in) :: input2
    type(var_xyz) :: output
    integer :: new_id

    call get_new_id_xyz(new_id)

    work_xyz(:,:,:,new_id) = sign(input1, work_xyz(:,:,:,input2%id))

    output%id = new_id
    output%grid = input2%grid
  end function sign_real_xyz

end module gms_math_function
