module gms_math_power
  use datatype
  use mem_manager
  implicit none
  integer :: ix, iy, iz

  interface operator(**)
  module procedure power_x_x, power_x_y, power_x_z, power_x_xy, power_x_xz, power_x_yz, power_x_xyz
  module procedure power_y_x, power_y_y, power_y_z, power_y_xy, power_y_xz, power_y_yz, power_y_xyz
  module procedure power_z_x, power_z_y, power_z_z, power_z_xy, power_z_xz, power_z_yz, power_z_xyz
  module procedure power_xy_x, power_xy_y, power_xy_z, power_xy_xy, power_xy_xz, power_xy_yz, power_xy_xyz
  module procedure power_xz_x, power_xz_y, power_xz_z, power_xz_xy, power_xz_xz, power_xz_yz, power_xz_xyz
  module procedure power_yz_x, power_yz_y, power_yz_z, power_yz_xy, power_yz_xz, power_yz_yz, power_yz_xyz
  module procedure power_xyz_x, power_xyz_y, power_xyz_z, power_xyz_xy, power_xyz_xz, power_xyz_yz, power_xyz_xyz
  module procedure power_real_x, power_real_y, power_real_z, power_real_xy, power_real_xz, power_real_yz, power_real_xyz
  module procedure power_x_real, power_y_real, power_z_real, power_xy_real, power_xz_real, power_yz_real, power_xyz_real
  end interface
contains
  function power_x_x(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function power_x_x

  function power_x_y(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function power_x_y

  function power_x_z(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function power_x_z

  function power_x_xy(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function power_x_xy

  function power_x_xz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function power_x_xz

  function power_x_yz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_x_yz

  function power_x_xyz(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_x(ix, 1, 1, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_x_xyz

  function power_x_real(input1, input2) result(output)
    type(var_x), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = work_x(ix, 1, 1, input1%id) **input2
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function power_x_real

  function power_y_x(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_y_x

  function power_y_y(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_y_y

  function power_y_z(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_y_z

  function power_y_xy(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_y_xy

  function power_y_xz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_y_xz

  function power_y_yz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_y_yz

  function power_y_xyz(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_y(1, iy, 1, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_y_xyz

  function power_y_real(input1, input2) result(output)
    type(var_y), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = work_y(1, iy, 1, input1%id) **input2
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_y_real

  function power_z_x(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_z_x

  function power_z_y(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_z_y

  function power_z_z(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_z_z

  function power_z_xy(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_z_xy

  function power_z_xz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_z_xz

  function power_z_yz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_z_yz

  function power_z_xyz(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_z_xyz

  function power_z_real(input1, input2) result(output)
    type(var_z), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = work_z(1, 1, iz, input1%id) **input2
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_z_real

  function power_xy_x(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_xy_x

  function power_xy_y(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_xy_y

  function power_xy_z(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_xy_z

  function power_xy_xy(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_xy_xy

  function power_xy_xz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_xy_xz

  function power_xy_yz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_xy_yz

  function power_xy_xyz(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_xy_xyz

  function power_xy_real(input1, input2) result(output)
    type(var_xy), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = work_xy(ix, iy, 1, input1%id) **input2
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = -1
  end function power_xy_real

  function power_xz_x(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_xz_x

  function power_xz_y(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xz_y

  function power_xz_z(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_xz_z

  function power_xz_xy(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xz_xy

  function power_xz_xz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_xz_xz

  function power_xz_yz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xz_yz

  function power_xz_xyz(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xz_xyz

  function power_xz_real(input1, input2) result(output)
    type(var_xz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = work_xz(ix, 1, iz, input1%id) **input2
        end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = -1
    output%grid(3) = input1%grid(3)
  end function power_xz_real

  function power_yz_x(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_x

  function power_yz_y(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_y

  function power_yz_z(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_z

  function power_yz_xy(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_xy

  function power_yz_xz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_xz

  function power_yz_yz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_yz

  function power_yz_xyz(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_xyz

  function power_yz_real(input1, input2) result(output)
    type(var_yz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = work_yz(1, iy, iz, input1%id) **input2
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_yz_real

  function power_xyz_x(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_x(ix, 1, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_x

  function power_xyz_y(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_y(1, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_y

  function power_xyz_z(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_z(1, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_z

  function power_xyz_xy(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_xy(ix, iy, 1, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_xy

  function power_xyz_xz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_xz(ix, 1, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_xz

  function power_xyz_yz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_yz(1, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_yz

  function power_xyz_xyz(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id
    if ( input1%grid(1) /= input2%grid(1) ) stop "(**)grid violation"
    if ( input1%grid(2) /= input2%grid(2) ) stop "(**)grid violation"
    if ( input1%grid(3) /= input2%grid(3) ) stop "(**)grid violation"

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) & 
                      ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_xyz

  function power_xyz_real(input1, input2) result(output)
    type(var_xyz), intent(in) :: input1 
    real(8), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = work_xyz(ix, iy, iz, input1%id) **input2
        end do
      end do
    end do

    output%grid(1) = input1%grid(1)
    output%grid(2) = input1%grid(2)
    output%grid(3) = input1%grid(3)
  end function power_xyz_real

  function power_real_x(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_x), intent(in) :: input2 
    type(var_x)             :: output 

    integer :: new_id

    call get_new_id_x(new_id)
    output%id = new_id 

        do ix = lb_axis1, ub_axis1

        work_x(ix, 1, 1, new_id) & 
                      = input1 ** work_x(ix, 1, 1, input2%id)
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = -1
  end function power_real_x

  function power_real_y(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_y), intent(in) :: input2 
    type(var_y)             :: output 

    integer :: new_id

    call get_new_id_y(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2

        work_y(1, iy, 1, new_id) & 
                      = input1 ** work_y(1, iy, 1, input2%id)
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function power_real_y

  function power_real_z(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_z), intent(in) :: input2 
    type(var_z)             :: output 

    integer :: new_id

    call get_new_id_z(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3

        work_z(1, 1, iz, new_id) & 
                      = input1 ** work_z(1, 1, iz, input2%id)
        end do

    output%grid(1) = -1
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function power_real_z

  function power_real_xy(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xy), intent(in) :: input2 
    type(var_xy)             :: output 

    integer :: new_id

    call get_new_id_xy(new_id)
    output%id = new_id 

      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xy(ix, iy, 1, new_id) & 
                      = input1 ** work_xy(ix, iy, 1, input2%id)
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = -1
  end function power_real_xy

  function power_real_xz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xz), intent(in) :: input2 
    type(var_xz)             :: output 

    integer :: new_id

    call get_new_id_xz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
        do ix = lb_axis1, ub_axis1

        work_xz(ix, 1, iz, new_id) & 
                      = input1 ** work_xz(ix, 1, iz, input2%id)
        end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = -1
    output%grid(3) = input2%grid(3)
  end function power_real_xz

  function power_real_yz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_yz), intent(in) :: input2 
    type(var_yz)             :: output 

    integer :: new_id

    call get_new_id_yz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2

        work_yz(1, iy, iz, new_id) & 
                      = input1 ** work_yz(1, iy, iz, input2%id)
        end do
      end do

    output%grid(1) = -1
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_real_yz

  function power_real_xyz(input1, input2) result(output)
    real(8), intent(in) :: input1 
    type(var_xyz), intent(in) :: input2 
    type(var_xyz)             :: output 

    integer :: new_id

    call get_new_id_xyz(new_id)
    output%id = new_id 

    do iz = lb_axis3, ub_axis3
      do iy = lb_axis2, ub_axis2
        do ix = lb_axis1, ub_axis1

        work_xyz(ix, iy, iz, new_id) & 
                      = input1 ** work_xyz(ix, iy, iz, input2%id)
        end do
      end do
    end do

    output%grid(1) = input2%grid(1)
    output%grid(2) = input2%grid(2)
    output%grid(3) = input2%grid(3)
  end function power_real_xyz

end module gms_math_power
