* PACKAGE  GTRELH  !" $@AjBP<>EY(J                         A.Numaguti
*"                                            95/05/31 S.Takehiro
***********************************************************************
      PROGRAM GTRELH
*
#ifdef SYS_IBMS
      INCLUDE    (GTSINC)
      INCLUDE    (GZSIZE)
#else
#include         "gtsinc.F"
#include         "gzsize.F"
#endif
      COMMON     /GMWORK/ MWORK
      REAL       MWORK  ( IJKDIM )
*
      CHARACTER  HHEADQ( NDC )*(NCC)
      REAL       GDATAQ( IJKDIM )
      CHARACTER  HHEADT( NDC )*(NCC)
      REAL       GDATAT( IJKDIM )
      CHARACTER  HHEADP( NDC )*(NCC)
      REAL       GDATAP( IJKDIM )
*
      DATA       IFILQ / 50 /
      DATA       IFILT / 51 /
      DATA       IFILP / 52 /
      DATA       JFILE / 60 /
*
      CHARACTER  Q      *(NFILN)
      DATA       Q      / 'q' /
      CHARACTER  T      *(NFILN)
      DATA       T      / 'T' /
      CHARACTER  PS     *(NFILN)
      DATA       PS     / 'Ps' /
      CHARACTER  OUT    *(NFILN)
      DATA       OUT    / '$GTTMPDIR/gtool.out' /
      LOGICAL    APND
      DATA       APND   / .FALSE. /
      CHARACTER  ITEM   *(NCC)
      CHARACTER  UNIT   *(NCC)
      CHARACTER  TITLE  *(NCC*2)
      CHARACTER  DSET   *(NCC)
      CHARACTER  EDIT   *(NCC)
      CHARACTER  ETTL   *(NCC)
      DATA       ITEM   / 'RH' /
      DATA       UNIT   / ' ' /
      DATA       TITLE  / 'relative humidity' /
      DATA       DSET, EDIT, ETTL /3*' '/
      LOGICAL    GRESET
      DATA       GRESET / .TRUE. /
      LOGICAL    HELP
      DATA       HELP   / .FALSE. /
*
      EXTERNAL   RELHUM
*     
      NAMELIST  /OPTION/ Q, T, PS, OUT, APND,
     &                   ITEM, UNIT, TITLE, DSET, EDIT, ETTL, GRESET,
     &                   HELP
*
      CALL OPTARG ( 91, 'OPTION', 'HFILE', NOPT, NFILE )
      READ (91,OPTION,IOSTAT=IOS)
      CLOSE(91)
      IF ( IOS.NE.0 .OR. HELP ) THEN
         WRITE(6,OPTION)
         STOP
      ENDIF
*
      CALL GTOPEN
      CALL GTSIZE ( HHEADQ, IJKDIM )
      CALL GTSIZE ( HHEADT, IJKDIM )
      CALL GTSIZE ( HHEADP, IJKDIM )
      CALL GMSIZE ( IJKDIM  )
*
      CALL GURNTF ( Q,  OUT  , '$GTTMPDIR/gtool.in' )
      CALL GURNTF ( T,  OUT  , '$GTTMPDIR/gtool.in' )
      CALL GURNTF ( PS, OUT  , '$GTTMPDIR/gtool.in' )
*
      CALL GFROPN ( IFILEQ, Q     )
      CALL GFROPN ( IFILET, T     )
      CALL GFROPN ( IFILEP, PS    )
      CALL GFOOPN ( JFILE ,  OUT , APND )
*
      CALL GUNENV( OUT,'.',.FALSE. )
      IL=LENC(OUT)
      WRITE (6,*) 'output='//OUT(1:IL)
*
 1100 CONTINUE
         CALL   GFREAD
     O        ( HHEADQ, GDATAQ, IEODQ  ,
     I          IFILEQ, 1               )
         CALL   GFREAD
     O        ( HHEADT, GDATAT, IEODT  ,
     I          IFILET , 1               )
         CALL   GFREAD
     O        ( HHEADP, GDATAP, IEODP ,
     I          IFILEP, 1               )
*
         IF ( MAX(IEODQ,IEODT,IEODP) .EQ.0 ) THEN
            CALL GMCAL3
     I         ( RELHUM,
     M           HHEADQ, GDATAQ,
     I           HHEADT, GDATAT,
     I           HHEADP, GDATAP,
     I           EDIT  , ETTL  )
*
            IF ( ITEM .NE. ' ' ) THEN
               CALL GHCSET( HHEADQ, 'ITEM', ITEM )
            ENDIF
            IF ( UNIT .NE. ' ' ) THEN
               CALL GHCSET( HHEADQ, 'UNIT', UNIT )
            ENDIF
            IF ( TITLE .NE. ' ' ) THEN
               CALL GHCSTS( HHEADQ, 'TITL', TITLE )
            ENDIF
            IF ( DSET .NE. ' ' ) THEN
               CALL GHCSET( HHEADQ, 'DSET', DSET )
            ENDIF
            IF ( GRESET ) THEN
               CALL GHRSGP( HHEADQ  )
            ENDIF
*
            CALL  GFWRIT
     I                 ( HHEADQ, GDATAQ,
     I                   JFILE , 1     , 0       )
*
      GOTO 1100
         ENDIF
*
      STOP
      END
********************************************************************
      SUBROUTINE RELHUM
     I         ( HHEADQ, QQ    ,
     I           HHEADT, TT    ,
     I           HHEADP, PS    ,
     O           HHEADR, RH    ,
     D           IXDIM , IYDIM , IZDIM ,
     D           IXDIM2, IYDIM2, IZDIM2,
     D           IXDIM3, IYDIM3, IZDIM3 )
*
      CHARACTER  HHEADT ( * ) *(*)
      CHARACTER  HHEADQ ( * ) *(*)
      CHARACTER  HHEADP ( * ) *(*)
      CHARACTER  HHEADR ( * ) *(*)
      REAL       TT ( IXDIM , IYDIM , IZDIM  )
      REAL       QQ ( IXDIM2, IYDIM2, IZDIM2 )
      REAL       PS ( IXDIM3, IYDIM3         )
      REAL       RH ( IXDIM , IYDIM , IZDIM  )
*
      PARAMETER  ( NCC=16, NDC=64 )
      PARAMETER  ( KDIMD=20 )
      CHARACTER  HHEADS ( NDC ) *(NCC)
      REAL       SIG ( KDIMD )
*
* PACKAGE ZQSAT     !" Clausis-Clapeyron $@$N<0(J($@J84X?t(J)
*
*"    QSAT:  saturation water vapour mixing ratio
*"    DQSAT: d(QSAT)/d(T)
*
      REAL       FQSAT
      REAL       FDQSAT
      REAL       T, P, QS
*
      FQSAT ( T,P )    = EPSV * ES0
     &                   * EXP( EL/RVAP *( 1./273. - 1./T ) )
     &                   / P
      FDQSAT( T,QS )   = EL * QS / ( RVAP * T*T )
*
      EL   = 2.5E6
      RVAP = 461.
      EPSV = 0.622
      ES0  = 6.11
      CALL GTSIZE ( HHEADS, KDIMD )
*
      CALL GUQAXV
     I         ( HHEADR, 3     , 'LOC' ,
     O           HHEADS, SIG   , IEOD   )
*
      DO 1100 IZ = 1, IZDIM
         DO 1110 IY = 1, IYDIM
            DO 1120 IX = 1, IXDIM
               RH ( IX,IY,IZ ) = QQ( IX,IY,IZ )
     &                         / FQSAT( TT(IX,IY,IZ),PS(IX,IY)*SIG(IZ) )
 1120       CONTINUE
 1110    CONTINUE
 1100 CONTINUE
*
      RETURN
      END
