*"    FST2S2, FST2P2 : Ū FST2SP, FST2PH Ʊʬ
*"    (ư=0)Ϥ
*
*     96/06/02 horinout < \
*        1993/11/17  horinout FST2SP:power spectrum FST2PH:phase
***********************************************************************
*
      SUBROUTINE  FST2S2 !"space-time fourier-->space-time power spect
     O   ( SP ,
     I     X  , N1 , NX , N3 , NT )
*
      IMPLICIT   REAL  (A-H,O-Z)
      DIMENSION  X(N1,NX,N3,NT)
      DIMENSION  SP(N1,NX+1,N3,0:NT/2)
*
      NX2 = NX/2
      NT2 = NT/2
      IF(NT2*2.NE.NT) CALL MSGDMP('E','FST2SP','INVALID ARRAY SIZE')
      IF(NX2*2 .NE.NX ) CALL MSGDMP('E','FST2SP','INVALID ARRAY size')
*
      DO 10 N = 0,NT2
      DO 10 J = 1,N3
      DO 10 K = 0,NX2
      DO 10 I = 1,N1
        IF(K.EQ.0 .AND. N.EQ.0) THEN
          P = X( I , 1 , J , 1 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.EQ.0 .AND. N.LE.NT2-1) THEN
          P = X( I , 1 , J , 2*N+1 )
          Q =-X( I , 1 , J , 2*N+2 )
          R = 0
          S = 0
        ELSE IF(K.EQ.0 .AND. N.EQ.NT2) THEN
          P = X( I , 1 , J , 2 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.LE.NX2-1 .AND. N.EQ.0) THEN
          P = X( I , 2*K+1 , J , 1 )
          Q = 0
          R =-X( I , 2*K+2 , J , 1 )
          S = 0
        ELSE IF(K.LE.NX2-1 .AND. N.LE.NT2-1) THEN
          P = X( I , 2*K+1 , J , 2*N+1 )
          Q =-X( I , 2*K+1 , J , 2*N+2 )
          R =-X( I , 2*K+2 , J , 2*N+1 )
          S = X( I , 2*K+2 , J , 2*N+2 )
        ELSE IF(K.LE.NX2-1 .AND. N.EQ.NT2) THEN
          P = X( I , 2*K+1 , J , 2 )
          Q = 0
          R =-X( I , 2*K+2 , J , 2 )
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.EQ.0) THEN
          P = X( I , 2 , J , 1 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.LE.NT2-1) THEN
          P = X( I , 2 , J , 2*N+1 )
          Q =-X( I , 2 , J , 2*N+2 )
          R = 0
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.EQ.NT2) THEN
          P = X( I , 2 , J , 2 )
          Q = 0
          R = 0
          S = 0
        ENDIF
        IF (N.NE.0) THEN
          SP( I , NX2+1-K , J ,N) = 2 * ( (P-S)**2 + (Q+R)**2 )
          SP( I , NX2+1+K , J ,N) = 2 * ( (P+S)**2 + (Q-R)**2 )
        ELSE
          SP( I , NX2+1-K , J ,N) = P**2 + R**2
          SP( I , NX2+1+K , J ,N) = P**2 + R**2
        ENDIF
   10 CONTINUE
*
      RETURN
      END
***********************************************************************
*
      SUBROUTINE  FST2P2  !" space-time fourier --> space-time phase
     O   ( PH ,
     I     X  , N1 , NX , N3 , NT )
*
      IMPLICIT   REAL  (A-H,O-Z)
      DIMENSION  X(N1,NX,N3,NT)
      DIMENSION  PH(N1,NX+1,N3,0:NT/2)
*
      NX2 = NX/2
      NT2 = NT/2
      IF(NT2*2.NE.NT) CALL MSGDMP('E','FST2PH','INVALID ARRAY SIZE')
      IF(NX2*2 .NE.NX ) CALL MSGDMP('E','FST2PH','INVALID ARRAY size')
*
      DO 10 N = 1,NT2
      DO 10 J = 1,N3
      DO 10 K = 0,NX2
      DO 10 I = 1,N1
        IF(K.EQ.0 .AND. N.EQ.0) THEN
          P = X( I , 1 , J , 1 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.EQ.0 .AND. N.LE.NT2-1) THEN
          P = X( I , 1 , J , 2*N+1 )
          Q =-X( I , 1 , J , 2*N+2 )
          R = 0
          S = 0
        ELSE IF(K.EQ.0 .AND. N.EQ.NT2) THEN
          P = X( I , 1 , J , 2 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.LE.NX2-1 .AND. N.EQ.0) THEN
          P = X( I , 2*K+1 , J , 1 )
          Q = 0
          R =-X( I , 2*K+2 , J , 1 )
          S = 0
        ELSE IF(K.LE.NX2-1 .AND. N.LE.NT2-1) THEN
          P = X( I , 2*K+1 , J , 2*N+1 )
          Q =-X( I , 2*K+1 , J , 2*N+2 )
          R =-X( I , 2*K+2 , J , 2*N+1 )
          S = X( I , 2*K+2 , J , 2*N+2 )
        ELSE IF(K.LE.NX2-1 .AND. N.EQ.NT2) THEN
          P = X( I , 2*K+1 , J , 2 )
          Q = 0
          R =-X( I , 2*K+2 , J , 2 )
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.EQ.0) THEN
          P = X( I , 2 , J , 1 )
          Q = 0
          R = 0
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.LE.NT2-1) THEN
          P = X( I , 2 , J , 2*N+1 )
          Q =-X( I , 2 , J , 2*N+2 )
          R = 0
          S = 0
        ELSE IF(K.EQ.NX2 .AND. N.EQ.NT2) THEN
          P = X( I , 2 , J , 2 )
          Q = 0
          R = 0
          S = 0
        ENDIF
        IF ( (Q+R).NE.0 .OR. (P-S).NE.0 ) THEN
          PH( I , NX2+1-K , J ,N) = ATAN2( (Q+R) , (P-S) )
        ELSE
          PH( I , NX2+1-K , J ,N) = 0
        ENDIF
        IF ( (Q-R).NE.0 .OR. (P+S).NE.0 ) THEN
          PH( I , NX2+1+K , J ,N) = ATAN2( (Q-R) , (P+S) )
        ELSE
          PH( I , NX2+1+K , J ,N) = 0
        ENDIF
   10 CONTINUE
*
      RETURN
      END
