!= "GTHST_NMLINFO" ѿνϾ䤤碌
!= Inquire output information of a "GTHST_NMLINFO" variable
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: hstnmlinfoinquire.f90,v 1.1 2009-05-11 15:15:15 morikawa Exp $
! Tag Name::  $Name: gtool5-20090602 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HstNmlInfoInquire( gthstnml, &
    & name, &
    & file, &
    & interval_value, &
    & interval_unit, &
    & precision, &
    & time_average, average, &
    & fileprefix, &
    & origin_value, origin_unit, &
    & terminus_value, terminus_unit, &
    & slice_start, slice_end, slice_stride, &
    & space_average, &
    & newfile_intvalue, newfile_intunit, &
    & err )
    !
    ! ѿνϾ䤤碌ޤ. 
    !
    ! ǥեͤˤ, *name* Ϳʤ, ޤ
    ! *name* ˶ͿƤ. 
    !
    ! *name* ˴ؤǡ¸ߤʤ, 顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Inquire output information of a variable.
    ! 
    ! If data correspond to *name* is not found, 
    ! error is occurred. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO, GTHST_NMLINFO_ENTRY
    use gtool_history_nmlinfo_internal, only: ListSearch
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, DC_ENOENTRY
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in), optional:: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    character(*), intent(out), optional:: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    real, intent(out), optional:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(*), intent(out), optional:: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(out), optional:: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, intent(out), optional:: time_average
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    logical, intent(out), optional:: average
                              ! time_average ε. 
                              ! Old version of "time_average"
    character(*), intent(out), optional:: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    real, intent(out), optional:: origin_value
                              ! ϳϻ. 
                              ! Start time of output. 
    character(*), intent(out), optional:: origin_unit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, intent(out), optional:: terminus_value
                              ! Ͻλ. 
                              ! End time of output. 
    character(*), intent(out), optional:: terminus_unit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, intent(out), optional:: slice_start(:)
                              ! γ. 
                              ! Start points of spaces. 
    integer, intent(out), optional:: slice_end(:)
                              ! νλ. 
                              ! End points of spaces. 
    integer, intent(out), optional:: slice_stride(:)
                              ! ι. 
                              ! Strides of spaces. 
    logical, intent(out), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, intent(out), optional:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(*), intent(out), optional:: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    character(STRING):: name_work
    integer:: stat, ary_size
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoInquire'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤõ.
    !  Search information correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    if ( present(name) ) then
      name_work = name
    else
      name_work = ''
    end if
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name_work )      ! (in)

    if ( .not. associated( hptr ) ) then
      stat = DC_ENOENTRY
      cause_c = adjustl( name_work )
      goto 999
    end if

    if ( hptr % name == '' ) then
      if ( present(file)           ) file           = ''
    else
      if ( present(file)           ) file           = trim( hptr % fileprefix ) // hptr % file
    end if
    if ( present(interval_value) ) interval_value = hptr % interval_value
    if ( present(interval_unit)  ) interval_unit  = hptr % interval_unit 
    if ( present(precision)      ) precision      = hptr % precision     
    if ( present(average)        ) average        = hptr % time_average  
    if ( present(time_average)   ) time_average   = hptr % time_average  
    if ( present(fileprefix)     ) fileprefix     = hptr % fileprefix    

    if ( present(origin_value    ) ) origin_value     = hptr % origin_value    
    if ( present(origin_unit     ) ) origin_unit      = hptr % origin_unit     
    if ( present(terminus_value  ) ) terminus_value   = hptr % terminus_value  
    if ( present(terminus_unit   ) ) terminus_unit    = hptr % terminus_unit   
    if ( present(slice_start     ) ) then
      ary_size = size(slice_start)
      slice_start  = hptr % slice_start(1:ary_size)
    end if
    if ( present(slice_end     ) ) then
      ary_size = size(slice_end)
      slice_end  = hptr % slice_end(1:ary_size)
    end if
    if ( present(slice_stride     ) ) then
      ary_size = size(slice_stride)
      slice_stride  = hptr % slice_stride(1:ary_size)
    end if
    if ( present(space_average     ) ) then
      ary_size = size(space_average)
      space_average  = hptr % space_average(1:ary_size)
    end if
    if ( present(newfile_intvalue) ) newfile_intvalue = hptr % newfile_intvalue
    if ( present(newfile_intunit ) ) newfile_intunit  = hptr % newfile_intunit 

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoInquire
