************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2016 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
************************************************************************
*     Υץ MϰϤ֤(MPI).
*     MCM: Υץ M θĿ(ʤ 0)
*     MC: Υץǰ MǼ  MC(1:MCM)
*-----------------------------------------------------------------------
      SUBROUTINE SUQRNM(MM,MCM,MC)

      IMPLICIT REAL*8(A-H,O-Z)
      INCLUDE 'mpif.h'
      DIMENSION MC(*)
!      DIMENSION MC(MM/NP+1) 

      CALL MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD,IP,IERR)

      N1=(MM+1)/NP
      M1=N1*NP
      MCM=N1
      IF(MOD(N1,2).EQ.0) THEN
        IF(IP.LE.MM-M1) THEN
          MCM=MCM+1
        END IF
      ELSE
        IF(IP.GE.NP-MM+M1-1) THEN
          MCM=MCM+1
        END IF
      END IF

      DO K=0,MCM-1
        MC(K+1)=K*NP+IP+MOD(K,2)*(NP-2*IP-1)
      END DO

      END
