!----------------------------------------------------------------------
!   Euler method: dx/dt = 1 - x**2
!
!   coded by Satoshi Sakai for lectures on Geophysical Fluid Dynamics
!   modified by Shigeo Yoden on Sept. 10, 2000
!----------------------------------------------------------------------
program euler01

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: mmax=200
  real, parameter :: tmax=2.
  real, dimension(0:mmax) :: t, t0, x, x0
  character :: ct*30

!!!    write(*,*) 'dt=?'
!!!    read (*,*)  dt
    dt = 0.2
 
    nmax = tmax/dt
    if(nmax > mmax) stop 'error: dt must have a larger value'

!--  ----
    t(0) = 0
    x(0) = 0

!-- ʬ ----
    do n=0, nmax-1
      dx = (1 - x(n)**2) *dt
      x(n+1) = x(n) + dx
      t(n+1) = t(n) + dt
    end do

!-- ϲ ----
    do m=0, mmax
      t0(m) = tmax/mmax *m
      x0(m) = tanh(t0(m))
    end do

!-- ղ ----
    call DclOpenGraphics()
    call DclNewFrame
      
    call DclSetTitle('time', 'x')
    call DclDrawScaledGraph(t0, x0)
    call DclDrawLine  (t(0:nmax), x(0:nmax), type=3)
    call DclDrawMarker(t(0:nmax), x(0:nmax), type=3)

      ct = 'dt=xx.xxExxx'
      write(ct(4:12),'(e9.2)') dt
    call DclDrawTitle('T', ct, position=-0.8)
    call DclDrawTitle('T', 'Euler method', position=-1.)

    call DclCloseGraphics
end program euler01
