program test_dcl

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: imax=20
  real,    parameter :: pi=3.141593, dx=2*pi/imax
  real, dimension(0:imax,0:imax) :: v

    do j=0, imax
      do i=0, imax
           v(i,j) = cos(i*dx)*cos(j*dx) + i*j*dx
      end do
    end do

    call DclOpenGraphics()
    call DclNewFrame

    call DclSetWindow  (0.0, 1.0, 0.0, 1.0)
    call DclSetViewPort(0.2, 0.8, 0.2, 0.8)
    call DclSetTransFunction

    call DclSetTitle('X-axis', 'Y-axis', 'km', 'm')
!    call DclSetTitle(xunit='km',ytitle='Y-axis',xtitle='X-axis',yunit='m')
   call DclDrawScaledAxis

    call DclSetParm('ENABLE_CONTOUR_MESSAGE', .false.)
    call DclDrawContour(v(0:imax/2,imax/2:imax))
!    call DclDrawContour(v)
    call DclDrawTitle('T', 'TEST DCL: proportional font', position=-1.)

    call DclCloseGraphics
end program  test_dcl
