!-----------------------------------------------------------------------
!   Advection equation: Forward -- Upstream
!
!   coded by Shigeo Yoden on Sept. 12, 2000
!-----------------------------------------------------------------------
program adv_ftus

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: jmax=1000, mmax=5
  real,    parameter :: xmax=1.0, tmax=1.0
  real,    parameter :: c=1.0, pi=3.141593
  real, dimension(0:jmax) :: x, u, du
  real, dimension(0:jmax,0:mmax) :: v
  character :: ct*30, cl*6

!!!    write(*,*) 'dx=?;   dt=? '
!!!    read (*,*)  dx, dt
    dx = 1.e-2;  dt = 5.e-3

    imax = xmax/dx
    nmax = tmax/dt;    ndel = nmax/mmax
    if(imax > jmax) stop 'error: dx must have a larger value'

!--  ----
!!!    write(*,*) 'initial condition # ?  1:cos  2:step  3:delta'
!!!    read (*,*) init
    init = 2

    if(init == 1) then
      do i=0, imax
        u(i) = cos(2*pi*i/imax)
      end do
    else if(init == 2) then
      u = - 1
      u(imax/4:imax/2) = 1
    else
      u = -1
      u(imax/4) = 1
    end if

    do i=0, imax
      x(i) = i*dx
      v(i,0) = u(i)
    end do
    mm = 0

!-- ʬ ----
    do n=1, nmax
      call drv(u, du)
      u = u + du

      if(mod(n,ndel) == 0) then
        mm = mm + 1
        v(0:imax,mm) = u
      end if
    end do

!-- ղ ----
    call DclOpenGraphics()
    call graph
    call DclCloseGraphics

!-- ³ ----
  contains
    subroutine drv(u, du)         ! ʬ׻֥롼
      real, dimension(0:imax) :: u, du

      do i=1, imax
        du(i) = - c*(u(i) - u(i-1))/dx *dt
      end do
      du(0)    = du(imax)         ! : x=0 <=> x=xmax
    end subroutine drv

    subroutine graph              ! դ֥롼
      call DclNewFrame
      
      call DclSetTitle('x', 'u(x,t)')
      call DclDrawScaledGraph(x(0:imax), v(0:imax,0))

      call DclSetParm('ENABLE_LINE_LABELING', .true.)
      call DclSetParm('LINE_CYCLE_LENGTH', 50.)
      call DclSetLineTextSize(0.02)
      cl = 't=?.?s'
      do m=1,mm
        call DclSetLineType(mod(m,4)+1)
          write(cl(3:5),'(f3.1)') ndel*m*dt
        call DclSetLineText(cl)
        call DclDrawLine(x(0:imax), v(0:imax,m))
      end do

        ct = 'dt=??.??E???s'
        write(ct(4:12),'(e9.2)') dt
      call DclDrawTitle('t', ct, position=-0.8)
      call DclDrawTitle('t', ' forward and upstream', position=-1.)
      call DclDrawTitle('t', 'Advection Equation:', position=-1.)
    end subroutine graph
end program adv_ftus
