!-----------------------------------------------------------------------
!   Heat conduction: Euler -- Centered Difference
!
!   coded by Shigeo Yoden on Sept. 12, 2000
!-----------------------------------------------------------------------
program cond_eu

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: jmax=1000, mmax=10
  real,    parameter :: xmax=0.5, tmax=1.0
  real,    parameter :: rkappa=0.14
  real, dimension(0:jmax) :: x, u, du
  real, dimension(0:jmax,0:mmax) :: v
  character :: ct*30, cl*6, csgi*1

!!!    write(*,*) 'dx=?;   dt=? '
!!!    read (*,*)  dx, dt
    dx = 5.e-3;  dt = 5.e-5

    imax = xmax/dx
    nmax = tmax/dt;    ndel = nmax/mmax
    if(imax > jmax) stop 'error: dx must have a larger value'

!--  ----
    u = 100
    u(0) = 0;  u(imax) = 0      ! ¸(1)ξü 0 
!!!    u(0) = 0                    ! ¸(2)ü 0 

    do i=0, imax
      x(i) = i*dx
      v(i,0) = u(i)
    end do
    mm = 0

!-- ʬ ----
    do n=1, nmax
      call drv(u, du)
      u = u + du

      if(mod(n,ndel) == 0) then
        mm = mm + 1
        v(0:imax,mm) = u
      end if
    end do

!-- ղ ----
    call DclOpenGraphics()
    call graph
    call DclCloseGraphics

!-- ³ ----
  contains
    subroutine drv(u, du)         ! ʬ׻֥롼
      real, dimension(0:imax) :: u, du

      du(0)    = 0                ! (x=0)
      du(imax) = 0                ! (x=xmax)

      do i=1, imax-1
        du(i) = rkappa*(u(i+1) - 2*u(i) + u(i-1))/dx**2 *dt
      end do
    end subroutine drv

    subroutine graph              ! դ֥롼
      call DclNewFrame
      
      call DclSetTitle('x', 'temperature', 'cm', '|'//csgi(4)//'"C')
      call DclDrawScaledGraph(x(0:imax), v(0:imax,0))

      call DclSetParm('ENABLE_LINE_LABELING', .true.)
      call DclSetParm('LINE_CYCLE_LENGTH', 45.)
      call DclSetLineTextSize(0.018)
      cl = 't=?.?s'
      do m=1,mm
          write(cl(3:5),'(f3.1)') ndel*m*dt
        call DclSetLineText(cl)
          if(m == 6) call DclSetParm('ENABLE_LINE_LABELING', .false.)
        call DclDrawLine(x(0:imax), v(0:imax,m))
      end do

        ct = 'dt=??.??E???s'
        write(ct(4:12),'(e9.2)') dt
      call DclDrawTitle('t', ct, position=-0.8)
      call DclDrawTitle('t', ' Euler-Centered Difference', position=-1.)
      call DclDrawTitle('t', 'Heat Conduction Equation:', position=-1.)
     end subroutine graph
end program cond_eu
