#include "na_fft.h"

#if RUBY_VERSION_CODE < 150
static int mem_count = 0;
static int na_gc_freq = 2500000;   /* Frequency of Garbage Collection */
#endif

int na_sizeof[NA_NTYPES+1] = {
  0,
  sizeof(u_int8_t),
  sizeof(int16_t),
  sizeof(int32_t),
  sizeof(float),
  sizeof(double),
  sizeof(scomplex),
  sizeof(dcomplex),
  sizeof(VALUE),
  0
};
 

/* allocation of NARRAY */
struct NARRAY*
 na_alloc_struct(int type, int rank, int *shape)
{
  int total=1;
  int i, memsz;
  struct NARRAY *ary;

  for (i=0; i<rank; i++)
    total *= shape[i];

  if (rank<=0 || total<=0) {
    /* empty array */
    ary = ALLOC(struct NARRAY);
    ary->rank  = 
    ary->total = 0;
    ary->shape = NULL;
    ary->ptr   = NULL;
    ary->type  = type;
  }
  else {
    memsz = na_sizeof[type] * total;

    /* Garbage Collection */
#if RUBY_VERSION_CODE < 150
    mem_count += memsz;
    if ( mem_count > na_gc_freq ) { rb_gc(); mem_count=0; }
#endif

    ary        = ALLOC(struct NARRAY);
    ary->shape = ALLOC_N(int,  rank);
    ary->ptr   = ALLOC_N(char, memsz);

    ary->rank  = rank;
    ary->total = total;
    ary->type  = type;
    for (i=0; i<rank; i++)
      ary->shape[i] = shape[i];
  }
  ary->ref = Qtrue;
  return ary;
}

void 
na_free(struct NARRAY* ary)
{
  if ( ary->total > 0 ) {
    if (ary->ref == Qnil || ary->ref == Qtrue) {  /* non reference */
      xfree(ary->ptr); 
    }
    xfree(ary->shape);
#ifdef DEBUG
    ary->shape = NULL;
    ary->ptr = NULL;
#endif
  }
  xfree(ary);
}
