#include <ruby.h>

enum NArray_Types {
  NA_NONE,
  NA_BYTE,      /* 1 */
  NA_SINT,      /* 2 */
  NA_LINT,      /* 3 */
  NA_SFLOAT,    /* 4 */
  NA_DFLOAT,    /* 5 */
  NA_SCOMPLEX,  /* 6 */
  NA_DCOMPLEX,  /* 7 */
  NA_ROBJ,      /* 8 */
  NA_NTYPES     /* 9 */
};

struct NARRAY {
  int    rank;    /* # of dimension */
  int    total;   /* # of total element */
  int    type;    /* data type */
  int   *shape;
  char  *ptr;     /* pointer to data */
  VALUE  ref;     /* NArray object wrapping this structure */
};

typedef struct { float  r,i; } scomplex;
typedef struct { double r,i; } dcomplex;
typedef struct NARRAY NA;

/* fft_fftw.c */
VALUE cNArray;
VALUE fft_fftw(int argc, VALUE *argv, VALUE self);
VALUE ffti_fftw(int argc, VALUE *argv, VALUE self);
void Init_na_fft(void);

/* fft_narray.c */
struct NARRAY *na_alloc_struct(int type, int rank, int *shape);
void na_free(struct NARRAY *ary);


/* copy from narray.h */

#define GetNArray(obj,var)  Data_Get_Struct(obj, struct NARRAY, var)


