!= ȳɹˤ륢٥Ѳ
!
!= modification of surface albedo on the snow covered ground and on the sea ice
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: modify_albedo_snowseaice.f90,v 1.2 2011-06-19 11:12:45 yot Exp $
! Tag Name::  $Name: dcpam5-20110926 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module modify_albedo_snowseaice

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: ModAlbedoDueToSnowSeaIce
  public :: ModAlbedoSnowSeaIceInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: modify_albedo_snowseaice_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'modify_albedo_snowseaice'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110926 $' // &
    & '$Id: modify_albedo_snowseaice.f90,v 1.2 2011-06-19 11:12:45 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine ModAlbedoDueToSnowSeaIce(          &
    & xy_SurfCond,                              &
    & xy_SurfSnow, xy_SeaIceConc,               & ! (in   ) optional
    & xy_SurfAlbedo                             & ! (inout)
    )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:            &
      & SnowThreshold => ThresholdSurfSnow,    &
      & SnowAlbedo,                            &
      & SeaIceThreshold,                       &
      & SeaIceAlbedo

    integer , intent(in   )           :: xy_SurfCond  ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SurfSnow  ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SeaIceConc( 0:imax-1, 1:jmax )
    real(DP), intent(inout)           :: xy_SurfAlbedo( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ǧ
    ! Initialization check
    !
    if ( .not. modify_albedo_snowseaice_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( present( xy_SurfSnow ) ) then
      ! modify surface albedo on the snow covered ground
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_SurfCond(i,j) > 0 .and. xy_SurfSnow(i,j) > SnowThreshold ) then
            xy_SurfAlbedo(i,j) = SnowAlbedo
          end if
        end do
      end do
    end if

    if ( present( xy_SeaIceConc ) ) then
      ! modify surface albedo on the sea ice
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_SurfCond(i,j) == 0 .and. xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            xy_SurfAlbedo(i,j) = SeaIceAlbedo
          end if
        end do
      end do
    end if


  end subroutine ModAlbedoDueToSnowSeaIce

  !--------------------------------------------------------------------------------------

  subroutine ModAlbedoSnowSeaIceInit

    if ( modify_albedo_snowseaice_inited ) return


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    modify_albedo_snowseaice_inited = .true.

  end subroutine ModAlbedoSnowSeaIceInit

  !--------------------------------------------------------------------------------------

end module modify_albedo_snowseaice
