
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003,2005 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//         Reza Nekovei <reza@intcomm.net>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

//
// A data exchange interface for DODS-netCDF V3.x API library.
//
//  Reza 5/18/99
// 

// $Id: Dncx.h 11906 2005-08-08 19:51:43Z root $ 

#ifndef _dncx_h
#define _dncx_h 1

#include <netcdf.h>

extern int
putn_into_uchar(void **xpp, size_t nelems, unsigned char *tp, nc_type type);

extern int
putn_into_schar(void **xpp, size_t nelems, signed char *tp, nc_type type);

extern int
putn_into_short(void **xpp, size_t nelems, short *tp, nc_type type);

extern int
putn_into_int(void **xpp, size_t nelems, int *tp, nc_type type);

extern int
putn_into_long(void **xpp, size_t nelems, long *tp, nc_type type);

extern int
putn_into_float(void **xpp, size_t nelems, float *tp, nc_type type);

extern int
putn_into_double(void **xpp, size_t nelems, double *tp, nc_type type);

extern int
putn_into_text(void **xpp, size_t nelems, char *tp);

#endif /* _dncx_h */
