
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003,2005 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//         Reza Nekovei <reza@intcomm.net>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

// DODS C++ header file for netcdf surrogate library. 
// 
// ReZa 10/6/94

#ifndef _dnetcdf_h
#define _dnetcdf_h 1

#include  <netcdf.h>		// netcdf interface

#include  <string>

#include "lnetcdf.h"		// local netcdf interface
#include <Connect.h>
#include "NCConnect.h"
#include "Connections.h"	// Connections class interface

using namespace libdap ;

extern Connections<NCConnect *>  *conns;

extern "C" void NCadvise(int err, char *fmt,...); // netcdf error handling

extern "C" char *cdf_routine_name;
extern int rcode;		// return code

#endif /* _dnetcdf_h */
