=begin
= Discrete Hankel Transforms

== Class Methods

--- GSL::Dht.new(size)
--- GSL::Dht.new(size, nu, xmax)
--- GSL::Dht.alloc(size)
--- GSL::Dht.alloc(size, nu, xmax)
    These methods allocate a Discrete Hankel transform object (({GSL::Dht})) 
    of size ((|size|)).
    If three arguments are given, the object is initialized with the values of
    ((|nu, xmax|)).

== Methods
--- GSL::Dht#init(nu, xmax)
    This initializes the transform ((|self|)) for the given values of ((|nu|)) and ((|xmax|)).
--- GSL::Dht#apply(vin, vout)
--- GSL::Dht#apply(vin)
    This applies the transform ((|self|)) to the vector ((|vin|)) whose size is 
    equal to the size of the transform.

--- GSL::Dht#x_sample(n)
    This method returns the value of the n'th sample point in the unit interval, 
    (j_{nu,n+1}/j_{nu,M}) X. These are the points where the function f(t) is 
    assumed to be sampled.

--- GSL::Dht#k_sample(n)
    This method returns the value of the n'th sample point in "k-space", 
    j_{nu,n+1}/X.

--- GSL::Dht#size
    Returns the size of the sample arrays to be transformed
--- GSL::Dht#nu
    Returns the Bessel function order
--- GSL::Dht#xmax
    Returns the upper limit to the x-sampling domain 
--- GSL::Dht#kmax
    Returns the upper limit to the k-sampling domain 

--- GSL::Dht#j
    Returns an array of computed J_nu zeros, j_{nu,s} = j[s] 
    as a (({GSL::Vector::View})).

--- GSL::Dht#Jjj
    Returns an array of transform numerator, J_nu(j_i j_m / j_N)
    as a (({GSL::Vector::View})).

--- GSL::Dht#J2
    Returns an array of transform numerator, J_nu(j_i j_m / j_N).

--- GSL::Dht#coef
--- GSL::Dht#coef(n, m)
    Return the (n,m)-th transform coefficient.

((<prev|URL:sum.html>))
((<next|URL:roots.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))

=end
