%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkCommon_typemaps.i


%{
#include "vtkViewport.h"
#include "vtkActor2DCollection.h"
#include "vtkAssemblyPath.h"
#include "vtkProp.h"
#include "vtkPropCollection.h"
#include "vtkWindow.h"
%}

%import vtkObject.h


%{
extern void vtkViewport_freefunc(void *ptr)
{
    vtkViewport *obj;
    obj = (vtkViewport*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetBackground()
}
%ignore GetBackground(double data[3]);
%ignore GetBackground(double _arg[3]);
%ignore GetBackground(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetAspect()
}
%ignore GetAspect(double data[2]);
%ignore GetAspect(double _arg[2]);
%ignore GetAspect(double &_arg1,double &_arg2);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetPixelAspect()
}
%ignore GetPixelAspect(double data[2]);
%ignore GetPixelAspect(double _arg[2]);
%ignore GetPixelAspect(double &_arg1,double &_arg2);

%typemap(ruby,out) double value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[4]{
   double *GetViewport()
}
%ignore GetViewport(double data[4]);
%ignore GetViewport(double _arg[4]);
%ignore GetViewport(double &_arg1,double &_arg2,double &_arg3,double &_arg4);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDisplayPoint()
}
%ignore GetDisplayPoint(double data[3]);
%ignore GetDisplayPoint(double _arg[3]);
%ignore GetDisplayPoint(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetViewPoint()
}
%ignore GetViewPoint(double data[3]);
%ignore GetViewPoint(double _arg[3]);
%ignore GetViewPoint(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[4]{
   double *GetWorldPoint()
}
%ignore GetWorldPoint(double data[4]);
%ignore GetWorldPoint(double _arg[4]);
%ignore GetWorldPoint(double &_arg1,double &_arg2,double &_arg3,double &_arg4);

%include vtkViewport.h
