%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkExtractTensorComponents.h"
%}

%import vtkDataSetToDataSetFilter.h


%{
extern void vtkExtractTensorComponents_freefunc(void *ptr)
{
    vtkExtractTensorComponents *obj;
    obj = (vtkExtractTensorComponents*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[2]{
   int *GetScalarComponents()
}
%ignore GetScalarComponents(int data[2]);
%ignore GetScalarComponents(int _arg[2]);
%ignore GetScalarComponents(int &_arg1,int &_arg2);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetVectorComponents()
}
%ignore GetVectorComponents(int data[6]);
%ignore GetVectorComponents(int _arg[6]);
%ignore GetVectorComponents(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetNormalComponents()
}
%ignore GetNormalComponents(int data[6]);
%ignore GetNormalComponents(int _arg[6]);
%ignore GetNormalComponents(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetTCoordComponents()
}
%ignore GetTCoordComponents(int data[6]);
%ignore GetTCoordComponents(int _arg[6]);
%ignore GetTCoordComponents(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%include vtkExtractTensorComponents.h
