%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageChangeInformation.h"
%}

%import vtkImageToImageFilter.h


%{
extern void vtkImageChangeInformation_freefunc(void *ptr)
{
    vtkImageChangeInformation *obj;
    obj = (vtkImageChangeInformation*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetOutputExtentStart()
}
%ignore GetOutputExtentStart(int data[3]);
%ignore GetOutputExtentStart(int _arg[3]);
%ignore GetOutputExtentStart(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOutputSpacing()
}
%ignore GetOutputSpacing(double data[3]);
%ignore GetOutputSpacing(double _arg[3]);
%ignore GetOutputSpacing(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOutputOrigin()
}
%ignore GetOutputOrigin(double data[3]);
%ignore GetOutputOrigin(double _arg[3]);
%ignore GetOutputOrigin(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetExtentTranslation()
}
%ignore GetExtentTranslation(int data[3]);
%ignore GetExtentTranslation(int _arg[3]);
%ignore GetExtentTranslation(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetSpacingScale()
}
%ignore GetSpacingScale(double data[3]);
%ignore GetSpacingScale(double _arg[3]);
%ignore GetSpacingScale(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOriginTranslation()
}
%ignore GetOriginTranslation(double data[3]);
%ignore GetOriginTranslation(double _arg[3]);
%ignore GetOriginTranslation(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOriginScale()
}
%ignore GetOriginScale(double data[3]);
%ignore GetOriginScale(double _arg[3]);
%ignore GetOriginScale(double &_arg1,double &_arg2,double &_arg3);

%include vtkImageChangeInformation.h
