%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkParallel_typemaps.i


%{
#include "vtkRTAnalyticSource.h"
%}

%import vtkImageSource.h


%{
extern void vtkRTAnalyticSource_freefunc(void *ptr)
{
    vtkRTAnalyticSource *obj;
    obj = (vtkRTAnalyticSource*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetWholeExtent()
}
%ignore GetWholeExtent(int data[6]);
%ignore GetWholeExtent(int _arg[6]);
%ignore GetWholeExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetCenter()
}
%ignore GetCenter(double data[3]);
%ignore GetCenter(double _arg[3]);
%ignore GetCenter(double &_arg1,double &_arg2,double &_arg3);

%include vtkRTAnalyticSource.h
