%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkRendering_typemaps.i


%{
#include "vtkVolumeProMapper.h"
%}

%import vtkVolumeMapper.h
%import vtkToolkits.h
%import vtkVersion.h


%{
extern void vtkVolumeProMapper_freefunc(void *ptr)
{
    vtkVolumeProMapper *obj;
    obj = (vtkVolumeProMapper*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetSubVolume()
}
%ignore GetSubVolume(int data[6]);
%ignore GetSubVolume(int _arg[6]);
%ignore GetSubVolume(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetCursorPosition()
}
%ignore GetCursorPosition(double data[3]);
%ignore GetCursorPosition(double _arg[3]);
%ignore GetCursorPosition(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetCursorXAxisColor()
}
%ignore GetCursorXAxisColor(double data[3]);
%ignore GetCursorXAxisColor(double _arg[3]);
%ignore GetCursorXAxisColor(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetCursorYAxisColor()
}
%ignore GetCursorYAxisColor(double data[3]);
%ignore GetCursorYAxisColor(double _arg[3]);
%ignore GetCursorYAxisColor(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetCursorZAxisColor()
}
%ignore GetCursorZAxisColor(double data[3]);
%ignore GetCursorZAxisColor(double _arg[3]);
%ignore GetCursorZAxisColor(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetSuperSamplingFactor()
}
%ignore GetSuperSamplingFactor(double data[3]);
%ignore GetSuperSamplingFactor(double _arg[3]);
%ignore GetSuperSamplingFactor(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[4]{
   double *GetCutPlaneEquation()
}
%ignore GetCutPlaneEquation(double data[4]);
%ignore GetCutPlaneEquation(double _arg[4]);
%ignore GetCutPlaneEquation(double &_arg1,double &_arg2,double &_arg3,double &_arg4);

%include vtkVolumeProMapper.h
