header_dir = nil
if ARGV.length==1
  header_dir = ARGV[0]
else
  if File.directory?("/usr/include/vtk")
    header_dir = "/usr/include/vtk"
  elsif File.directory?("/usr/local/include/vtk")
    header_dir = "/usr/local/include/vtk"
  end
end

raise "Usage: ruby #$0 header_dir\n" until header_dir
    

subs = %w(
Common
Filtering
Graphics
IO
Imaging
Rendering
Patented
Parallel
Hybrid
)


use_default_free = %w(
vtkCommonInstantiator
vtkFilteringInstantiator
vtkGraphicsInstantiator
vtkIOInstantiator
vtkImagingInstantiator
vtkRenderingInstantiator
vtkPatentedInstantiator
vtkParallelInstantiator
vtkHybridInstantiator
vtkCollectionElement
vtkLargeInteger
vtkOStrStreamWrapper
vtkImageIterator
vtkImageProgressIterator
vtkSmartPointer
vtkOBBNode
vtkImageCanvasSource2DPixel
vtkImageConnectorSeed
vtkTransformPair
vtkDebugLeaksManager
vtkErrorCode
vtkHeapNode
vtkOStreamWrapper
vtkOutputWindowCleanup
vtkSmartPointerBase
vtkInstantiatorInitialize
vtkPLY
vtkFreeTypeFontCacheCleanup
vtkFreeTypeFontCache
vtkStdString
)


def out(name,length,type)
  case type
  when "int"
    method = "INT2NUM("
  when "unsigned int"
    method = "UINT2NUM("
  when "long"
    method = "LONG2NUM("
  when "unsigned long"
    method = "ULONG2NUM("
  when "float"
    method = "rb_float_new((double)"
  when "double"
    method = "rb_float_new("
  else
    raise "#{type} is not defined yet"
  end
  str = <<"EOF"
%typemap(ruby,out) #{type} value[#{length}] {
  int i;
  $result = rb_ary_new2(#{length});
  for (i=0; i<#{length}; i++)
    rb_ary_store($result,i,#{method}$1[i]));
}
%apply #{type} value[#{length}]{
   #{type} *Get#{name}()
}
%ignore Get#{name}(#{type} data[#{length}]);
%ignore Get#{name}(#{type} _arg[#{length}]);
EOF
tmp = (1..length).to_a.collect{|i| "#{type} &_arg#{i}" }.join(",")
  str<< "%ignore Get#{name}(#{tmp});\n\n"
  return str
end



subs.each{|subname|

  p subname

  files = File.open("#{subname}/#{subname}_files"){|f|
    f.readlines.collect{|l| l.chop!}
  }

  files.delete("vtkOStrStreamWrapper") if subname=="Common"
  files.delete("vtkOStreamWrapper") if subname=="Common"


  nfiles = files.length

  ind_win32header = files.index("vtkWin32Header") if subname=="Common"
  class_lines = Array.new(nfiles).collect{ Array.new }
  parent = Array.new(nfiles).collect{ Array.new }
  child = Array.new(nfiles).collect{ Array.new }
  all_classes = Array.new
  nfiles.times{|i|
    name = files[i]
    File.foreach("#{header_dir}/#{name}.h"){|line|
      if (line =~ /^class (vtk\w*)[\s|:|$]/)||(line =~ /^class VTK_\w*EXPORT (vtk\w*)[\s|:|$]/)
        class_lines[i].push(line)
        all_classes.push($1)
        if subname=="Common"
          parent[i].push ind_win32header
          child[ind_win32header].push i
        end
      end
      if line =~ /^#include "(vtk\w*)\.h/ && (ind = files.index($1))
        parent[i].push ind
        child[ind].push i
      end
    }
  }

  nfiles.times{|i|
    class_lines[i].each{|line|
      line =~ /: public (vtk\w*)/
      j = files.index($1)
      if j && !parent[i].include?(j)
        parent[i].push(j)
        child[j].push(i)
      end
    }
  }

  if subname=="Common"
    i = files.index("vtkPropAssembly")
    j = files.index("vtkPropCollection")
    parent[i].push(j)
    child[j].push(i)
    j = files.index("vtkAssemblyPath")
    parent[i].push(j)
    child[j].push(i)
#    i = files.index("vtkDataArray")
#    j = files.index("vtkFloatArray")
#    parent[i].delete(j)
#    child[j].delete(i)
  end

  remain = Array.new(nfiles)
  nfiles.times{|i|
    remain[i] = i
  }
  order = Array.new
  while (remain.length>0)
    remain.dup.each{|i|
      if parent[i].length==0
        remain.delete(i)
        order.push(i)
        child[i].each{|j|
          parent[j].delete(i)
        }
      end
    }
  end


  names = Array.new(nfiles)
  nfiles.times{|i|
    names[i] = files[order[i]]
  }


  File.open("#{subname}/#{subname}.cxx","w"){|f|
    f.print <<"EOF"
#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if !defined(STATIC_LINKED)
#    define SWIGEXPORT(a) __declspec(dllexport) a
#  else
#    define SWIGEXPORT(a) a
#  endif
#else
#  define SWIGEXPORT(a) a
#endif


#ifdef __cplusplus
extern "C" {
#endif
EOF
    if subname=="Common"
      f.print "extern SWIGEXPORT(void) Init_vtkConfigure(void);\n"
      f.print "extern SWIGEXPORT(void) Init_vtkToolkits(void);\n"
    end
    names.each{|name|
      f.print "extern SWIGEXPORT(void) Init_#{name}(void);\n"
    }
    f.print <<"EOF"
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C"
#endif
EOF
    f.print "SWIGEXPORT(void) Init_#{subname}(void){\n\n"

    if subname=="Common"
      f.print "  Init_vtkConfigure();\n"
      f.print "  Init_vtkToolkits();\n"
    end
    names.each{|name|
      f.print "  Init_#{name}();\n"
    }
    f.print "}\n"
  }

  File.open("vtk#{subname}_typemaps.i","w"){|f|
    all_classes.each{|name|
      if name=="vtkCallbackCommand"
        name = "vtkRubyCallbackCommand"
        f.print <<"EOF"
%rename(CallbackCommand) #{name};
%typemap(ruby,out) #{name}* {
    if ( $1 != NULL ) {
      if ( !((strcmp(rb_obj_classname(self),"Class")==0)&&(argc==1))  )
        $1->Register((vtkObjectBase*)NULL);
      $result = SWIG_NewPointerObj((void*)$1, SWIGTYPE_p_#{name}, 1);
    } else
      $result = Qnil;
}
%markfunc #{name} "#{name}_markfunc";
%freefunc #{name} "#{name}_freefunc";
%{
extern void #{name}_markfunc(void*);
extern void #{name}_freefunc(void*);
%}
EOF
      else
        newname  = name[3..-1]
        newname[0..0] = "H3" if newname[0..0]=="3"
        f.print "%rename(#{newname}) #{name};\n"
        if !use_default_free.include?(name)
          f.print <<"EOF"
%typemap(ruby,out) #{name}*
{
    if ( (strcmp(rb_obj_classname(self),"Class")==0)&&(argc==1)  ) {
      if ( $1 != NULL )
        $result = Data_Wrap_Struct(self, 0, VOIDFUNC(#{name}_freefunc), (void*)$1);
      else
        $result = Qnil;
    } else {
      if ( $1 != NULL ) {
EOF
          if ! %w(vtkTransformConcatenation vtkTransformConcatenationStack vtkTimeStamp vtkIndent vtkSimpleCriticalSection vtkSimpleMutexLock).include?(name)
            f.print "        $1->Register((vtkObjectBase*)NULL);\n"
          end
          f.print <<"EOF"
        $result = Data_Wrap_Struct(rb_const_get_at(mVtk,rb_intern("#{newname}")), 0, VOIDFUNC(#{name}_freefunc), (void*)$1);
      } else
        $result = Qnil;
    }
}
%freefunc #{name} "#{name}_freefunc";
%{
extern void #{name}_freefunc(void*);
%}
EOF
        end
      end
      f.print "\n\n"


    }
  }
  if subname == "Common"
    %w(vtkConfigure vtkToolkits).each{|name|
      File.open("Common/#{name}.i","w"){|f|
        f.print <<"EOF"
%module vtk
%{
#include "#{name}.h"
%}
%include typemaps.i
%include vtk_typemaps.i
%include vtk#{subname}_typemaps.i


%include #{name}.h
EOF
      }
    }
  end


  names.each{|filename|
    headers = Array.new
    def_classes = Array.new
    classes = Array.new
    macros = Array.new
    File.foreach("#{header_dir}/#{filename}.h"){|line|
      if line =~ /^#include "(vtk\w*).h"/
        header = $1
        headers.push(header) unless header=~/^#{filename}$/
      elsif line =~ /^class (vtk\w*);/
        def_classes.push($1) if files.include?($1)&&(!headers.include?($1))
      elsif (line =~ /^class (vtk\w*)[\s|:|$]/)||(line =~ /^class VTK_\w*EXPORT (vtk\w*)[\s|:|$]/)
        classes.push($1)
      elsif !(line=~/#define/) &&line =~ /vtkGetVector(.*)Macro\((.*)\)/
        length = $1.to_i
        name, type, tmp = $2.split(/,\s*/)
        length = tmp.to_i if length==0
        macros.push [name.strip,length,type.strip] unless type=~/char/
      end

    }
    if filename=="vtkPolyData"
      def_classes.push("vtkCellArray")
    elsif filename=="vtkPropAssembly"
      def_classes.push("vtkPropCollection")
      def_classes.push("vtkAssemblyPath")
    elsif filename=="vtkImageViewer"
      def_classes.push("vtkRenderer")
    elsif filename=="vtkImageViewer2"
      def_classes.push("vtkRenderer")
    elsif filename=="vtkHierarchicalBoxDataSet"
      def_classes.push("vtkCompositeDataVisitor")
    elsif filename=="vtkMultiBlockDataSet"
      def_classes.push("vtkCompositeDataVisitor")
    elsif filename=="vtkHierarchicalDataSet"
      def_classes.push("vtkCompositeDataIterator")
    end
    begin
      f = File.open("#{subname}/#{filename}.i","w")

      f.print "%module vtk\n"
      f.print "%include typemaps.i\n"
      f.print "%include vtk_typemaps.i\n"
      f.print  "%include vtk#{subname}_typemaps.i\n\n\n"

      f.print "%{\n"
      if %w(vtkIdType vtkWin32Header).include?(filename)
        f.print "#include \"vtkSystemIncludes.h\"\n"
      else
        f.print "#include \"#{filename}.h\"\n"
        def_classes.each{|name|
          f.print "#include \"#{name}.h\"\n"
        }
      end
      f.print "%}\n\n"

      if filename=="vtkCallbackCommand"
        name = "vtkRubyCallbackCommand"
        f.print <<"EOF"
%import vtkCallbackCommand.h


%inline %{
class #{name} : public vtkCommand
{
public:
  static #{name} *New(){ return new #{name}; };

  void SetCallback(VALUE proc)
    {this->Callback = proc;}
  void Execute(vtkObject *ptr, unsigned long eventtype, void *);

  VALUE Callback;
protected:
  #{name}();
};
%}
%{
#{name}::#{name}()
{
  this->Callback = Qnil;
}
void #{name}::Execute(vtkObject *caller, unsigned long event, void *callData)
{
  VALUE rcaller;
  VALUE revent;

  rcaller = SWIG_NewPointerObj((void*)caller, SWIGTYPE_p_vtkObject, 0);
  revent = ULONG2NUM(event);
  if (this->Callback)
    rb_funcall(this->Callback, rb_intern("call"), 2, rcaller, revent);
}
void #{name}_markfunc(void *ptr)
{
    #{name} *obj;
    obj = (#{name}*)ptr;
    rb_gc_mark(obj->Callback);

}
void #{name}_freefunc(void *ptr)
{
    #{name} *obj;
    obj = (#{name}*)ptr;
    obj->Delete();
}
%}

EOF
      else

        if %w(vtkIdType vtkWin32Header).include?(filename)
          f.print "%import vtkSystemIncludes.h\n"
        else
          headers.each{|header|
            if %w(vtkWin32Header vtkIdType vtkOStrStreamWrapper vtkOStreamWrapper).include?(header)
              f.print "#define __VTK_SYSTEM_INCLUDES__INSIDE\n"
            end
            f.print "%import #{header}.h\n"
            if %w(vtkWin32Header vtkIdType vtkOStrStreamWrapper vtkOStreamWrapper).include?(header)
              f.print "#undef __VTK_SYSTEM_INCLUDES__INSIDE\n"
            end
          }
        end
        f.print "\n\n"
        classes.each{|name|
          if !use_default_free.include?(name)
            if name=="vtkDataArrayTemplate"
              f.print <<"EOF"
%{
extern void #{name}_freefunc(void *ptr)
{
    vtkDataArray     *obj;
    obj = (vtkDataArray*)ptr;
    obj->Delete();
}
%}

EOF
            else
              f.print <<"EOF"
%{
extern void #{name}_freefunc(void *ptr)
{
    #{name} *obj;
    obj = (#{name}*)ptr;
    obj->Delete();
}
%}

EOF
            end 
          end
        }

        macros.each{|arg|
          f.print out(*arg)
        }

       if %w(vtkWin32Header vtkIdType vtkOStrStreamWrapper vtkOStreamWrapper).include?(filename)
         f.print "#define __VTK_SYSTEM_INCLUDES__INSIDE\n"
       end
        f.print "%include #{filename}.h\n"
       if %w(vtkWin32Header vtkIdType vtkOStrStreamWrapper vtkOStreamWrapper).include?(filename)
         f.print "#undef __VTK_SYSTEM_INCLUDES__INSIDE\n"
       end

      end

    ensure
      f.close if defined?(f)
    end
  }

}
