#
# simple calc 2 (ja)
#
# This file contains Japanese characters (euc-jp) !!!
#

class Calcp

  prechigh
    nonassoc UMINUS
    left '*' '/'
    left '+' '-'
  preclow

rule

  target  : exp
          | /* none */ { result = 0 }

  exp     : exp '+' exp { result += val[2] }
          | exp '-' exp { result -= val[2] }
          | exp '*' exp { result *= val[2] }
          | exp '/' exp { result /= val[2] }
          | '(' exp ')' { result = val[1] }
          | '-' NUMBER  = UMINUS { result = -val[1] }
          | NUMBER

end


---- header ----
#
# calc.rb : generated by racc
#

---- inner ----
  
  def parse( str )
    @q = []

    while str.size > 0 do
      case str
      when /\A\s+/
      when /\A\d+/
        @q.push [:NUMBER, $&.to_i]
      when /\A.|\n/
        s = $&
        @q.push [s, s]
      end
      str = $'
    end
    @q.push [false, '$']

    do_parse
  end

  def next_token
    @q.shift
  end

---- footer ----

class Nemui < Exception; end

parser = Calcp.new
count = 0
scnt  = 0

print "\n***********************"
print "\nĶڤ2浡"
print "\n***********************\n\n"
print "ꤿʤäQ򥿥פƤ\n"

while true do
  print "\n"
  print 'ikutu? > '
  str = gets.chop!
  break if /q/i === str

  begin
    val = parser.parse( str )
    print 'kotae! = ', val, "\n"
    scnt += 1
    
    case scnt
    when 5
      print "\nƯΤǤ 5׻ä\n\n"
    when 8
      print "\näѤ׻͡\n\n"
    when 9
      print "\nͤ ⤦Ĥ줿 ⤦٤⤦衼\n\n"
    when 10
      print "\n⤦ͤΤá\n\n"
      raise Nemui, "⤦ᡣ"
    end

  rescue ParseError
    case count
    when 0
      print "\n  á\n"
    when 1
      print "\n  ⤦áä㤦衪\n"
    when 2
      print "\n  ⤦Ƥʤá\n\n\n"
      sleep 0.5
      print "           á\n\n"
      sleep(1)
      raise
    end
    count += 1

  rescue
    print "\n  ʤ\n"
    raise

  end

end

print "\n㤢ޤͤ\n\n"
sleep 0.5
