/* Do not edit this file. It is produced from the corresponding .m4 source */
/*
 *	Copyright 1996, University Corporation for Atmospheric Research
 *	See netcdf/COPYRIGHT file for copying and redistribution conditions.
 */
/* "$Id: t_ncxx.m4,v 2.16 1996/11/27 22:38:52 davis Exp $" */

/*
 * This program tests the aggregate external representation conversion
 * functions "ncx_[pad_]{put,get}n_*()" declared in ncx.h.
 * Unlike t_ncx.c, it only checks self consistancy,
 * not consistancy with the xdr library.
 *
 * Link like this: 
 * cc t_ncxx.c ncx.o -o t_nxc
 * (The xdr library is not needed.)
 *
 * If an assertion fails, there is a problem.
 * Otherwise, the program is silent and has exit code 0.
 */ 

#undef NDEBUG   /* always active assert() in this file */

#include <stdio.h>
#include <string.h>
#include <limits.h>
/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#include <assert.h>
#include "ncx.h"
#define X_SIZEOF_SCHAR X_SIZEOF_CHAR
#define X_LONG_MAX X_INT_MAX
#define X_LONG_MIN X_INT_MIN

#define XBSZ 1024

char ncxb[XBSZ];
char lbuf[XBSZ];

#define ArraySize(thang) (sizeof(thang)/sizeof(thang[0]))
#define eSizeOf(thang) ((size_t)(sizeof(thang[0])))

/*
 * Some test data
 * The ideas is that ncx_putn_type_type(...., types)
 * should not return NC_ERANGE.
 */

#if SCHAR_MAX == X_SCHAR_MAX && SCHAR_MIN == X_SCHAR_MIN
static schar schars[] = {
	SCHAR_MIN, SCHAR_MIN +1,
	-1, 0, 1,
	SCHAR_MAX - 1, SCHAR_MAX
};
#else
/* The implementation and this test assume 8 bit bytes. */
#error "Not 8 bit bytes ??"
#endif

static short shorts[] = {
#if SHORT_MAX <= X_SHORT_MAX
	SHORT_MIN, SHORT_MIN + 1,
#  if SCHAR_MAX < X_SHORT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_SHORT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
	SHORT_MAX - 1, SHORT_MAX
#else
	X_SHORT_MIN, X_SHORT_MIN + 1,
#  if SCHAR_MAX < X_SHORT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_SHORT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
	X_SHORT_MAX - 1, X_SHORT_MAX
#endif
};

static int ints[] = {
#if INT_MAX <= X_INT_MAX
	INT_MIN, INT_MIN +1,
#  if SHORT_MAX < X_INT_MAX
	SHORT_MIN -1, SHORT_MIN, SHORT_MIN + 1,
#  endif
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
#  if SHORT_MAX < X_INT_MAX
	SHORT_MAX - 1, SHORT_MAX, SHORT_MAX +1,
#  endif
	INT_MAX - 1, INT_MAX
#else
	X_INT_MIN, X_INT_MIN +1,
#  if SHORT_MAX < X_INT_MAX
	SHORT_MIN -1, SHORT_MIN, SHORT_MIN + 1,
#  endif
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
#  if SHORT_MAX < X_INT_MAX
	SHORT_MAX - 1, SHORT_MAX, SHORT_MAX +1,
#  endif
	X_INT_MAX - 1, X_INT_MAX
#endif /* INT */
};


/* N.B. only testing longs over X_INT range for now */
static long longs[] = {
#if LONG_MAX <= X_INT_MAX
	LONG_MIN, LONG_MIN +1,
#  if INT_MAX < X_INT_MAX
	INT_MIN -1, INT_MIN, INT_MIN + 1,
#  endif
#  if SHORT_MAX < X_INT_MAX
	SHORT_MIN -1, SHORT_MIN, SHORT_MIN + 1,
#  endif
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
#  if SHORT_MAX < X_INT_MAX
	SHORT_MAX - 1, SHORT_MAX, SHORT_MAX +1,
#  endif
#  if INT_MAX < X_INT_MAX
	INT_MAX -1, INT_MAX, INT_MAX + 1,
#  endif
	LONG_MAX - 1, LONG_MAX
#else
	X_INT_MIN, X_INT_MIN +1,
#  if SHORT_MAX < X_INT_MAX
	SHORT_MIN -1, SHORT_MIN, SHORT_MIN + 1,
#  endif
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MIN - 1, SCHAR_MIN, SCHAR_MIN + 1,
#  endif
	-1, 0, 1,
#  if SCHAR_MAX < X_INT_MAX
	SCHAR_MAX - 1, SCHAR_MAX, SCHAR_MAX + 1,
#  endif
#  if SHORT_MAX < X_INT_MAX
	SHORT_MAX - 1, SHORT_MAX, SHORT_MAX +1,
#  endif
	X_INT_MAX - 1, X_INT_MAX
#endif
};

static float floats[] = {
	-1.E9F,
	-16777215, -16777214,
	-999999,
	-32769, -32768, -32767,
	-129, -128, 127,
	-1, 0, 1,
	126, 127, 128,
	32766, 32767, 32768,
	999999,
	16777214, 16777215,	/* 2^24 -1 */
	1.E9F
};

static double doubles[] = {
	-1.E20,
	-4503599627370495., -4503599627370494.,
	-999999999999999.,
	-1.E9,
	-16777215, -16777214,
	-999999,
	-32769, -32768, -32767,
	-129, -128, 127,
	-1, 0, 1,
	126, 127, 128,
	32766, 32767, 32768,
	999999,
	16777214, 16777215,	/* 2^24 -1 */
	1.E9,
	999999999999999.,
	4503599627370494., 4503599627370495.,	/* 2^53 -1 */
	1.E20
};

static uchar uchars[] = {
	0, 1,
	UCHAR_MAX/2 -1, UCHAR_MAX/2, UCHAR_MAX/2 +1,
	UCHAR_MAX - 1, UCHAR_MAX
};

/* End of test data */



static void 
t_putn_schar_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_schar_schar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_schar_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_schar_uchar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);
}

static void 
t_putn_schar_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	int status = ncx_putn_schar_short((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_schar_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	int status = ncx_putn_schar_int((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_schar_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	int status = ncx_putn_schar_long((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_schar_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	int status = ncx_putn_schar_float((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_schar_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	int status = ncx_putn_schar_double((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_pad_putn_schar_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_schar((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_schar_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_uchar((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);
}

static void 
t_pad_putn_schar_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_short((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_schar_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_int((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_schar_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_long((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_schar_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_float((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_schar_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_putn_schar_double((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SCHAR_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SCHAR_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_putn_short_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_short_schar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	int status = ncx_putn_short_uchar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	int status = ncx_putn_short_short((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	int status = ncx_putn_short_int((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	int status = ncx_putn_short_long((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	int status = ncx_putn_short_float((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_short_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	int status = ncx_putn_short_double((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_pad_putn_short_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_schar((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_uchar((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_short((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_int((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_long((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_float((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_pad_putn_short_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_putn_short_double((void **)&xp, nelems, tp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_SHORT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_SHORT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_putn_int_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_int_schar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	int status = ncx_putn_int_uchar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	int status = ncx_putn_int_short((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	int status = ncx_putn_int_int((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	int status = ncx_putn_int_long((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	int status = ncx_putn_int_float((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_int_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	int status = ncx_putn_int_double((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_INT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_INT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_putn_float_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_float_schar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	int status = ncx_putn_float_uchar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	int status = ncx_putn_float_short((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	int status = ncx_putn_float_int((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	int status = ncx_putn_float_long((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	int status = ncx_putn_float_float((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_float_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	int status = ncx_putn_float_double((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_FLOAT_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_FLOAT_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}


static void 
t_putn_double_schar(char *const buf)
{
	char *xp = buf; 
	const schar *tp = schars;
	size_t nelems = ArraySize(schars);
	int status = ncx_putn_double_schar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_uchar(char *const buf)
{
	char *xp = buf; 
	const uchar *tp = uchars;
	size_t nelems = ArraySize(uchars);
	int status = ncx_putn_double_uchar((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_short(char *const buf)
{
	char *xp = buf; 
	const short *tp = shorts;
	size_t nelems = ArraySize(shorts);
	int status = ncx_putn_double_short((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_int(char *const buf)
{
	char *xp = buf; 
	const int *tp = ints;
	size_t nelems = ArraySize(ints);
	int status = ncx_putn_double_int((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_long(char *const buf)
{
	char *xp = buf; 
	const long *tp = longs;
	size_t nelems = ArraySize(longs);
	int status = ncx_putn_double_long((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_float(char *const buf)
{
	char *xp = buf; 
	const float *tp = floats;
	size_t nelems = ArraySize(floats);
	int status = ncx_putn_double_float((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}

static void 
t_putn_double_double(char *const buf)
{
	char *xp = buf; 
	const double *tp = doubles;
	size_t nelems = ArraySize(doubles);
	int status = ncx_putn_double_double((void **)&xp, nelems, tp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] > X_DOUBLE_MAX)
			{
				assert(status == NC_ERANGE);
				return;
			}
			if((double) tp[ii] < X_DOUBLE_MIN)
			{
				assert(status == NC_ERANGE);
				return;
			}
		}
		assert(status == 0);
	}
}




static void 
t_getn_schar_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_schar_schar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_schar_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_schar_uchar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			assert(tp[ii] == lp[ii]);
		}
	}
}

static void 
t_getn_schar_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	int status = ncx_getn_schar_short((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_schar_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	int status = ncx_getn_schar_int((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_schar_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	int status = ncx_getn_schar_long((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_schar_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	int status = ncx_getn_schar_float((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_schar_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	int status = ncx_getn_schar_double((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SCHAR);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SCHAR_MAX)
				&& ((double)tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}


static void 
t_pad_getn_schar_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_schar((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_schar_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(schars);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_uchar((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			assert(tp[ii] == lp[ii]);
		}
	}
}

static void 
t_pad_getn_schar_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_short((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_schar_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_int((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_schar_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_long((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_schar_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_float((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_schar_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	const char *end = buf + nelems * X_SIZEOF_SCHAR;
	int status = ncx_pad_getn_schar_double((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SCHAR_MAX)
				&& ((double) tp[ii] >= X_SCHAR_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}


static void 
t_getn_short_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_short_schar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(uchars);
	int status = ncx_getn_short_uchar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] <= X_SHORT_MAX)
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	int status = ncx_getn_short_short((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	int status = ncx_getn_short_int((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	int status = ncx_getn_short_long((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	int status = ncx_getn_short_float((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_short_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	int status = ncx_getn_short_double((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_SHORT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_SHORT_MAX)
				&& ((double)tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}


static void 
t_pad_getn_short_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_schar((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(uchars);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_uchar((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((tp[ii] <= X_SHORT_MAX))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_short((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_int((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_long((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_float((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_pad_getn_short_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	const char *end = buf + nelems * X_SIZEOF_SHORT;
	int status = ncx_pad_getn_short_double((const void **)&xp, nelems, lp);
	assert(xp >= end);
	assert((xp - end)  < 4);
	assert((xp - buf)%4 == 0);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double) tp[ii] <= X_SHORT_MAX)
				&& ((double) tp[ii] >= X_SHORT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}


static void 
t_getn_int_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_int_schar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(uchars);
	int status = ncx_getn_int_uchar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] <= X_INT_MAX)
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	int status = ncx_getn_int_short((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	int status = ncx_getn_int_int((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	int status = ncx_getn_int_long((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	int status = ncx_getn_int_float((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_int_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	int status = ncx_getn_int_double((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_INT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_INT_MAX)
				&& ((double)tp[ii] >= X_INT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}


static void 
t_getn_float_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_float_schar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_FLOAT_MAX)
				&& ((double)tp[ii] >= X_FLOAT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_float_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(uchars);
	int status = ncx_getn_float_uchar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] <= X_FLOAT_MAX)
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_float_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	int status = ncx_getn_float_short((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_FLOAT_MAX)
				&& ((double)tp[ii] >= X_FLOAT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_float_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	int status = ncx_getn_float_int((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	/* If the system rounds up can get NC_ERANGE */
	assert(status == 0 || status == NC_ERANGE);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			/* limited by x_float mantissa nbits */
			if((tp[ii] <= 16777215)
				&& (tp[ii] >= -16777215))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_float_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	int status = ncx_getn_float_long((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	/* If the system rounds up can get NC_ERANGE */
	assert(status == 0 || status == NC_ERANGE);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			/* limited by x_float mantissa nbits */
			if((tp[ii] <= 16777215)
				&& (tp[ii] >= 16777215))
			{
				if(tp[ii] != lp[ii])
		(void) fprintf(stderr,
				"%.9e != %.9e float_float (diff %.9e)\n",
				(double)tp[ii], (double)lp[ii],
				(double)(tp[ii] - lp[ii]));
			}
		}
	}
}
static void 
t_getn_float_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	int status = ncx_getn_float_float((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_FLOAT_MAX)
				&& ((double)tp[ii] >= X_FLOAT_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_float_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	int status = ncx_getn_float_double((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_FLOAT);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((tp[ii] <= X_FLOAT_MAX)
				&& (tp[ii] >= X_FLOAT_MIN))
			{
				if(((float)tp[ii]) != lp[ii])
				{
	if(tp[ii] != 0)
	{
		double eps = (tp[ii] - lp[ii])/tp[ii];
		if(eps > 1.19209290E-07F) /* X_FLT_EPSILON */
		{
			(void) fprintf(stderr,
				"%.9e != %.9e float_double (eps %.9e)\n",
				tp[ii], lp[ii], eps);
		}
	}
	else
	{
		(void) fprintf(stderr,
				"%.9e != %.9e float_double (diff %.9e)\n",
				tp[ii], lp[ii], tp[ii] - lp[ii]);
					
	}
				}
			}
		}
	}
}


static void 
t_getn_double_schar(const char *const buf)
{
	const char *xp = buf; 
	const schar *tp = schars;
	schar *lp = (schar *)lbuf;
	size_t nelems = ArraySize(schars);
	int status = ncx_getn_double_schar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_uchar(const char *const buf)
{
	const char *xp = buf; 
	const uchar *tp = uchars;
	uchar *lp = (uchar *)lbuf;
	size_t nelems = ArraySize(uchars);
	int status = ncx_getn_double_uchar((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if((double) tp[ii] <= X_DOUBLE_MAX)
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_short(const char *const buf)
{
	const char *xp = buf; 
	const short *tp = shorts;
	short *lp = (short *)lbuf;
	size_t nelems = ArraySize(shorts);
	int status = ncx_getn_double_short((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_int(const char *const buf)
{
	const char *xp = buf; 
	const int *tp = ints;
	int *lp = (int *)lbuf;
	size_t nelems = ArraySize(ints);
	int status = ncx_getn_double_int((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_long(const char *const buf)
{
	const char *xp = buf; 
	const long *tp = longs;
	long *lp = (long *)lbuf;
	size_t nelems = ArraySize(longs);
	int status = ncx_getn_double_long((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_float(const char *const buf)
{
	const char *xp = buf; 
	const float *tp = floats;
	float *lp = (float *)lbuf;
	size_t nelems = ArraySize(floats);
	int status = ncx_getn_double_float((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}

static void 
t_getn_double_double(const char *const buf)
{
	const char *xp = buf; 
	const double *tp = doubles;
	double *lp = (double *)lbuf;
	size_t nelems = ArraySize(doubles);
	int status = ncx_getn_double_double((const void **)&xp, nelems, lp);
	assert(xp == buf + nelems * X_SIZEOF_DOUBLE);
	assert(status == 0);

	{
		size_t ii;
		for(ii = 0; ii < nelems; ii++)
		{
			if(((double)tp[ii] <= X_DOUBLE_MAX)
				&& ((double)tp[ii] >= X_DOUBLE_MIN))
			{
				assert(tp[ii] == lp[ii]);
			}
		}
	}
}



#if defined(_CRAYIEEE) && !defined(_CRAYMPP) /* T90 */
#include <signal.h>
#endif /* T90 */

int
main(int ac, char *av[])
{

#if defined(_CRAYIEEE) && !defined(_CRAYMPP) /* T90 */
	/*
	 * Some of the extreme test assignments in this program trigger
         * floating point exceptions on CRAY T90
	 */
	(void) signal(SIGFPE, SIG_IGN);
#endif /* T90 */

  /* x_schar */
	t_putn_schar_schar(ncxb);
	t_getn_schar_schar(ncxb);

	t_putn_schar_uchar(ncxb);
	t_getn_schar_uchar(ncxb);

	t_putn_schar_short(ncxb);
	t_getn_schar_short(ncxb);

	t_putn_schar_int(ncxb);
	t_getn_schar_int(ncxb);

	t_putn_schar_long(ncxb);
	t_getn_schar_long(ncxb);

	t_putn_schar_float(ncxb);
	t_getn_schar_float(ncxb);

	t_putn_schar_double(ncxb);
	t_getn_schar_double(ncxb);

  /* pad x_schar */
	t_pad_putn_schar_schar(ncxb);
	t_getn_schar_schar(ncxb);
	t_pad_getn_schar_schar(ncxb);

	t_pad_putn_schar_uchar(ncxb);
	t_getn_schar_uchar(ncxb);
	t_pad_getn_schar_uchar(ncxb);

	t_pad_putn_schar_short(ncxb);
	t_getn_schar_short(ncxb);
	t_pad_getn_schar_short(ncxb);

	t_pad_putn_schar_int(ncxb);
	t_getn_schar_int(ncxb);
	t_pad_getn_schar_int(ncxb);

	t_pad_putn_schar_long(ncxb);
	t_getn_schar_long(ncxb);
	t_pad_getn_schar_long(ncxb);

	t_pad_putn_schar_float(ncxb);
	t_getn_schar_float(ncxb);
	t_pad_getn_schar_float(ncxb);

	t_pad_putn_schar_double(ncxb);
	t_getn_schar_double(ncxb);
	t_pad_getn_schar_double(ncxb);

  /* x_short */
	t_putn_short_schar(ncxb);
	t_getn_short_schar(ncxb);

	t_putn_short_uchar(ncxb);
	t_getn_short_uchar(ncxb);

	t_putn_short_short(ncxb);
	t_getn_short_short(ncxb);

	t_putn_short_int(ncxb);
	t_getn_short_int(ncxb);

	t_putn_short_long(ncxb);
	t_getn_short_long(ncxb);

	t_putn_short_float(ncxb);
	t_getn_short_float(ncxb);

	t_putn_short_double(ncxb);
	t_getn_short_double(ncxb);

  /* pad x_short */
	t_pad_putn_short_schar(ncxb);
	t_getn_short_schar(ncxb);
	t_pad_getn_short_schar(ncxb);

	t_pad_putn_short_uchar(ncxb);
	t_getn_short_uchar(ncxb);
	t_pad_getn_short_uchar(ncxb);

	t_pad_putn_short_short(ncxb);
	t_getn_short_short(ncxb);
	t_pad_getn_short_short(ncxb);

	t_pad_putn_short_int(ncxb);
	t_getn_short_int(ncxb);
	t_pad_getn_short_int(ncxb);

	t_pad_putn_short_long(ncxb);
	t_getn_short_long(ncxb);
	t_pad_getn_short_long(ncxb);

	t_pad_putn_short_float(ncxb);
	t_getn_short_float(ncxb);
	t_pad_getn_short_float(ncxb);

	t_pad_putn_short_double(ncxb);
	t_getn_short_double(ncxb);
	t_pad_getn_short_double(ncxb);

  /* x_int */
	t_putn_int_schar(ncxb);
	t_getn_int_schar(ncxb);

	t_putn_int_uchar(ncxb);
	t_getn_int_uchar(ncxb);

	t_putn_int_short(ncxb);
	t_getn_int_short(ncxb);

	t_putn_int_int(ncxb);
	t_getn_int_int(ncxb);

	t_putn_int_long(ncxb);
	t_getn_int_long(ncxb);

	t_putn_int_float(ncxb);
	t_getn_int_float(ncxb);

	t_putn_int_double(ncxb);
	t_getn_int_double(ncxb);

  /* x_float */
	t_putn_float_schar(ncxb);
	t_getn_float_schar(ncxb);

	t_putn_float_uchar(ncxb);
	t_getn_float_uchar(ncxb);

	t_putn_float_short(ncxb);
	t_getn_float_short(ncxb);

	t_putn_float_int(ncxb);
	t_getn_float_int(ncxb);

	t_putn_float_long(ncxb);
	t_getn_float_long(ncxb);

	t_putn_float_float(ncxb);
	t_getn_float_float(ncxb);

	t_putn_float_double(ncxb);
	t_getn_float_double(ncxb);

  /* x_double */
	t_putn_double_schar(ncxb);
	t_getn_double_schar(ncxb);

	t_putn_double_uchar(ncxb);
	t_getn_double_uchar(ncxb);

	t_putn_double_short(ncxb);
	t_getn_double_short(ncxb);

	t_putn_double_int(ncxb);
	t_getn_double_int(ncxb);

	t_putn_double_long(ncxb);
	t_getn_double_long(ncxb);

	t_putn_double_float(ncxb);
	t_getn_double_float(ncxb);

	t_putn_double_double(ncxb);
	t_getn_double_double(ncxb);

	return 0;
}
