!--
!----------------------------------------------------------------------
!   Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  eq_module
!      2 ΰ, Fourier Ÿ + ¿༰Ÿˡ
!
!      spml/eq_module ⥸塼 2 ΰǤήαư
!      ڥȥˡˤͷ׻¹Ԥ뤿 Fortran90 ؿ󶡤. 
!      Ūʶ򰷤̳ؤΥաꥨѴ
!      ɤ򰷤ư¿༰ѴѤ
!      ڥȥ׻ΤΤޤޤʴؿ󶡤. 
!
!       ae_module, aq_module ѤƤ. 
!      ǲǤϥաꥨѴӥӥѴΥ󥸥Ȥ 
!      ISPACK/FTPACK  Fortran77 ֥롼ѤƤ.
!
!      Matsushima and Marcus (1994) ¿༰˴ؤ 
!      doc/spectral_radial.tex 򻲾ȤΤ. 
!
!
!  2008/04/11  ݹ  et_module ¤
!      2008/05/02  ݹ  Ƚ
!      2008/10/29  ݹ  eq_Vor2Strm_eq 롼
!      2009/01/09  ݹ  eq_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ˽
!
!++
module eq_module
  !
  != eq_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: eq_module.f90,v 1.5 2009-02-28 21:33:46 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/eq_module ⥸塼 2 ΰǤήαư
  ! ڥȥˡˤͷ׻¹Ԥ뤿 Fortran90 ؿ󶡤. 
  ! Ūʶ򰷤̳ؤΥաꥨѴ
  ! ɤ򰷤ư¿༰ѴѤ
  ! ڥȥ׻ΤΤޤޤʴؿ󶡤. 
  !
  !  ae_module, aq_module ѤƤ. 
  ! ǲǤϥաꥨѴӥӥѴΥ󥸥Ȥ 
  ! ISPACK/FTPACK  Fortran77 ֥롼ѤƤ.
  !
  ! Matsushima and Marcus (1994) ¿༰˴ؤ 
  ! ưºɸΥڥȥˡ(spectral_radial.pdf[link:./spectral_radial.pdf])
  ! ȤΤ. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (eq_, rp_, r_, p_) , ֤ͤη򼨤Ƥ.
  !   eq_ :: 2ڥȥǡ
  !   rp_ :: 2 ʻǡ
  !   r_  :: ư 1 ʻǡ
  !   p_  :: ̳ 1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dr, Dp, Lapla, LaplaInv, Jacobian), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_eq_eq,_eq,_rp, _r, _p) , ѿΥڥȥǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _eq    :: 2ڥȥǡ
  !   _eq_eq :: 2 Ĥ2ڥȥǡ
  !   _rp    :: 2 ʻǡ
  !   _r     :: ư 1 ʻǡ
  !   _p     :: ̳ 1 ʻǡ
  !
  !=== ƥǡμ
  !
  ! * rp : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(jm,0:im-1). 
  !   * im, jm Ϥ줾̳, ưºɸγʻǤ, 
  !     ֥롼 eq_initial ˤƤ餫ꤷƤ.
  !   *  1 ưºɸγʻֹ,  2 ̳Ѻɸ
  !     ʻֹǤ. 
  !
  ! * eq : 2 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km,0:lm). 
  !   * km, lm Ϥ줾̳, ưκȿǤ, 
  !     ֥롼 eq_initial ˤƤ餫ꤷƤ. 
  !   * ư¥ڥȥǡγǼΤˤĤƤ 
  !     aq_module.f90 򻲾ȤΤ.
  !
  ! * p, r : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1)
  !      real(8), dimension(jm).
  !
  ! * e, q : 1 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km) 
  !      real(8), dimension(0:lm).
  !
  ! * ap, ar : 1 ʻǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,0:im-1) 
  !      real(8), dimension(:,jm).
  !
  ! * ae, aq : 1 ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,-km:km) 
  !      real(8), dimension(:,0:lm).
  !
  ! * eq_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * rp_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * p_, p_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! eq_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! p_Phi, r_Rad               ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! p_Phi_Weight, r_Rad_Weight ::  ŤߺɸǼ 1 
  ! rp_Phi, rp_Rad             ::  ʻǡ XY ɸ(X,Y)
  !                                (ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! rp_eq :: ڥȥǡʻҥǡؤѴ
  ! eq_rp :: ʻҥǡ饹ڥȥǡؤѴ
  ! ap_ae, p_e :: ̳ΥڥȥǡʻҥǡؤѴ
  ! ar_aq, r_q :: ưΥڥȥǡʻҥǡؤѴ
  ! ae_ap, e_p :: ̳γʻǡ饹ڥȥǡؤѴ
  ! aq_ar, q_r :: ưγʻǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! eq_Lapla_eq  :: ڥȥǡ˥ץ饷Ѥ
  ! eq_DPhi_eq, ae_DPhi_ae, e_DPhi_e :: ڥȥǡ
  !                                     ̳ʬѤ
  ! eq_RadDRad_eq, aq_RadDRad_aq, q_RadDRad_q :: ڥȥǡ
  !                                              ưʬѤ
  ! eq_Jacobian_eq_eq :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== 
  !
  ! eq_Boundary    :: ǥꥯ, Υޥ󶭳Ŭ
  ! eq_LaplaInv_eq :: ڥȥǡ˥ץ饷εѴѤ
  ! eq_Vor2Strm_eq :: ٤ή׻
  !
  !==== ʬʿ
  !
  ! IntRadPhi_rp, AvrRadPhi_rp   :: 2 ʻǡΰʬʿ
  ! r_IntPhi_rp, r_AvrPhi_rp :: 2 ʻǡ̳ʬʿ
  ! IntPhi_p, AvrPhi_p       :: 1 (X)ʻǡ̳ʬʿ
  ! p_IntRad_rp, p_AvrRad_rp :: 2 ʻǡưʬʿ
  ! IntRad_r, AvrRad_r       :: 1 (Y)ʻǡưʬʿ
  !
  use dc_message
  use lumatrix
  use ae_module, p_Phi => g_X, p_Phi_weight => g_X_Weight, &
                 e_p => e_g, ae_ap => ae_ag, &
                 p_e => g_e, ap_ae => ag_ae, &
                 ae_DPhi_ae => ae_Dx_ae, e_DPhi_e => e_Dx_e
  use aq_module, r_Rad => g_R, r_Rad_Weight => g_R_Weight, &
                 aq_ar => aq_ag, q_r => q_g, &
                 ar_aq => ag_aq, r_q => g_q, &
                 q_RadDRad_q => q_rDr_q, aq_RadDRad_aq => aq_rDr_aq

  implicit none
  private

  public eq_Initial                                       ! 

  public p_Phi, p_Phi_Weight, rp_Phi                      ! ɸѿ
  public r_Rad, r_Rad_Weight, rp_Rad, er_Rad              ! ɸѿ

  public rp_eq, eq_rp                                     ! Ѵ
  public er_eq, eq_er                                     ! Ѵ
  public er_rp, rp_er                                     ! Ѵ
  public e_p, p_e, ae_ap, ap_ae                           ! Ѵ
  public q_r, r_q, aq_ar, ar_aq                           ! Ѵ

  public eq_DPhi_eq, e_DPhi_e, ae_DPhi_ae                 ! ʬ
  public eq_RadDRad_eq, q_RadDRad_q, aq_RadDRad_aq        ! ʬ
  public er_Lapla_eq, eq_Lapla_eq                         ! ʬ

  public eq_Jacobian_eq_eq                                ! ׻

  public eq_Boundary                                      ! 
  public aq_Boundary_D, aq_Boundary_N                     ! 
  public eq_LaplaInv_eq, eq_Vor2Strm_eq                   ! 

  public IntRadPhi_rp, r_IntPhi_rp, p_IntRad_rp, IntPhi_p, IntRad_r   ! ʬ
  public AvrRadPhi_rp, r_AvrPhi_rp, p_AvrRad_rp, AvrPhi_p, AvrRad_r   ! ʿ

  integer            :: im=32, jm=8      ! ʻ(Phi,Rad)
  integer            :: km=10, lm=5      ! ȿ(Phi,Rad)
  real(8)            :: ra=1.0           ! ΰ礭
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), parameter :: alpha = 1.0D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta  = 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 

  real(8), dimension(:,:), allocatable :: rp_Phi, rp_Rad
  real(8), dimension(:,:), allocatable :: er_Rad
  integer, dimension(:), allocatable   :: md

  save im, jm, km, lm, ra, md

  contains
  !---------------  -----------------
    subroutine eq_Initial(i,j,k,l,ra_in)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: k           ! ȿ(X)
      integer,intent(in) :: l           ! ȿ(Y)

      real(8),intent(in) :: ra_in       ! Ⱦ

      integer :: kk

      im = i       ; jm = j
      km = k       ; lm = l
      ra = ra_in

      allocate(md(-km:km))

      do kk=-km,km
         md(kk) = abs(kk)
      enddo

      call ae_initial(im,km,0.0D0,2*pi)
      call aq_Initial(jm,lm,ra,alpha,beta,md)

      allocate(rp_Phi(jm,0:im-1),rp_Rad(jm,0:im-1))
      rp_Phi = spread(p_Phi,1,jm)
      rp_Rad = spread(r_Rad,2,im)

      allocate(er_Rad(-km:km,jm))
      er_Rad = spread(r_Rad,1,2*km+1)

      call MessageNotify('M','eq_initial','eq_module (2009/01/09) is initialized')
    end subroutine eq_initial

  !--------------- Ѵ -----------------

    function rp_eq(eq)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(jm,0:im-1)                :: rp_eq
      !(out) ʻǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: eq
      !(in) ڥȥǡ

      rp_eq = ap_ae(transpose(ar_aq(eq)))

    end function rp_eq

    function eq_rp(rp)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: eq_rp
      !(out) ڥȥǡ

      real(8), dimension(jm,0:im-1), intent(in)    :: rp
      !(in) ʻǡ

      eq_rp = aq_ar(transpose(ae_ap(rp)))

    end function eq_rp

    function eq_er(er)
      !
      ! ư³ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: eq_er
      !(out) ڥȥǡ

      real(8), dimension(-km:km,jm), intent(in)    :: er
      !(in) ʻǡ

      eq_er = aq_ar(er)

    end function eq_er

    function er_eq(eq)
      !
      ! ư³ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,jm)                :: er_eq
      !(out) ʻǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: eq
      !(out) ڥȥǡ

      er_eq = ar_aq(eq)

    end function er_eq

    function rp_er(er)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(jm,0:im-1)              :: rp_er
      !(out) ʻǡ

      real(8), dimension(-km:km,jm), intent(in)  :: er
      !(in) ڥȥǡ

      rp_er = ap_ae(transpose(er))

    end function rp_er

    function er_rp(rp)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-km:km,jm)                :: er_rp
      !(out) ڥȥǡ

      real(8), dimension(jm,0:im-1), intent(in)    :: rp
      !(in) ʻǡ

      er_rp = transpose(ae_ap(rp))

    end function er_rp

  !--------------- ʬ׻ -----------------

    function eq_DPhi_eq(eq)
      !
      ! ϥڥȥǡ̳ʬ(ߦ)Ѥ.
      !
      ! ڥȥǡΦʬȤ, бʻǡ˦ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,0:lm)                :: eq_DPhi_eq
      real(8), dimension(-km:km,0:lm), intent(in)    :: eq
      integer k

      do k=-km,km
         eq_DPhi_eq(k,:)  =  -k*eq(-k,:)
      enddo
    end function eq_DPhi_eq

    function eq_RadDRad_eq(eq)
      !
      ! ϥڥȥǡưʬ(rr)Ѥ.
      !
      ! ڥȥǡưʬȤ, бʻǡưʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)               :: eq_RadDRad_eq
      !(out) ڥȥǡưʬ

      real(8), dimension(-km:km,0:lm), intent(in)   :: eq
      !(in) ϥڥȥǡ

      eq_RadDRad_eq = aq_RadDRad_aq(eq)

    end function eq_RadDRad_eq

    function er_Lapla_eq(eq)
      !
      ! ϥڥȥǡ˥ץ饷 
      !  (1/r)(r(rr)+ (1/r^2) ߦզ Ѥ.
      !
      real(8), dimension(-km:km,jm)                :: er_Lapla_eq
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-km:km,0:lm), intent(in)  :: eq
      !(in) ϥڥȥǡ

      real(8), dimension(-km:km,0:lm)              :: eq_work

      integer k

      do k=-km,km
         eq_work(k,:) = -k**2 * eq(k,:)
      enddo

      er_Lapla_eq = er_eq(eq_work + eq_RadDRad_eq(eq_RadDRad_eq(eq)))/er_Rad**2

    end function er_Lapla_eq

    function eq_Lapla_eq(eq)
      !
      ! ϥڥȥǡ˥ץ饷 
      !  (1/r)(r(rr)+ (1/r^2) ߦզ Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, 
      ! бʻǡ˥ץ饷Ѥǡ
      ! ڥȥѴΤȤǤ. 
      !
      real(8), dimension(-km:km,0:lm)              :: eq_Lapla_eq
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-km:km,0:lm), intent(in)  :: eq
      !(in) ϥڥȥǡ

      eq_Lapla_eq = eq_er(er_Lapla_eq(eq))

    end function eq_Lapla_eq

    function eq_Jacobian_eq_eq(eq_a,eq_b)
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=1/r[(rA)(ߦB)-(ߦA)(rB)]
      !
      !  ׻. 1/r ΥեĤƤ뤳Ȥ. 
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm)                :: eq_Jacobian_eq_eq
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-km:km,0:lm), intent(in)    :: eq_a
      !(in) 1ܤϥڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)    :: eq_b
      !(in) 2ܤϥڥȥǡ

      eq_Jacobian_eq_eq = eq_rp(&
           (  rp_eq(eq_RadDRad_eq(eq_a)) * rp_eq(eq_DPhi_eq(eq_b))   &
             -rp_eq(eq_DPhi_eq(eq_a)) * rp_eq(eq_RadDRad_eq(eq_b)) ) &
           /rp_Rad**2)

    end function eq_Jacobian_eq_eq


  !---------------  -----------------

    subroutine eq_Boundary(eq,value,cond)
      !
      ! ǥꥯ, ΥޥŬ. ӥն֤Ǥη׻
      !
      ! ºݤˤǸƤФƤ aq_module Υ֥롼 
      ! aq_Boundary_D,, aq_Boundary_N ѤƤ. 
      ! ľܸƤ֤Ȥ.
      !
      real(8), dimension(-km:km,0:lm),intent(inout)      :: eq
              ! ŬѤǡ. 줿֤ͤ. 

      real(8), dimension(-km:km), intent(in), optional   :: value
              ! Ǥ / ʬۤʿڥȥѴΤͿ. 
              ! ά/ 0 Ȥʤ. 

      character(len=1), intent(in), optional             :: cond
              ! . ά 'D'
              !   D : ξüǥꥯ
              !   N : ξüΥޥ

      if (.not. present(cond)) then
         if (present(value)) then
            call aq_Boundary_D(eq,value)
         else
            call aq_Boundary_D(eq)
         endif
         return
      endif

      select case(cond)
      case ('N')
         if (present(value)) then
            call aq_Boundary_N(eq,value)
         else
            call aq_Boundary_N(eq)
         endif
      case ('D')
         if (present(value)) then
            call aq_Boundary_D(eq,value)
         else
            call aq_Boundary_D(eq)
         endif
      case default
         call MessageNotify('E','eq_Boundaries','B.C. not supported')
      end select

    end subroutine eq_Boundary

    function eq_LaplaInv_eq(eq,value)
      !
      ! ͤͿ(ǥꥯ), 
      ! ϥڥȥǡ˵եץ饷
      ! [(1/r)(r(rr)+ (1/r^2) ߦզ]^{-1} Ѥ.
      !
      ! ˡˤ׻
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,0:lm),intent(in)  :: eq
      !(in) ڥȥǡ

      real(8), dimension(-km:km,0:lm)             :: eq_LaplaInv_eq
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-km:km), intent(in), optional :: value
      !(in) . ά 0 ꤵ. 

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(-km:km,0:lm)         :: eq_work
      real(8), dimension(-km:km,jm)           :: er_work
      real(8), dimension(-km:km)              :: value1       ! 

      logical :: first = .true.
      integer :: k, l
      save    :: alu, kp, first

      if (.not. present(value)) then
         value1=0
      else
         value1 = value
      endif

      if ( first ) then
         first = .false.

         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         do l=0,lm
            eq_work = 0.0 ; eq_work(:,l) = 1.0
            alu(:,:,l) = eq_er(er_Lapla_eq(eq_work))
         enddo

         ! 0 ʬΤȤ 1 .
         do k=-km,km
            do l=0,md(k)-1
               alu(k,l,l) = 1.0D0
            enddo
            do l=md(k)+1,lm,2
               alu(k,l,l) = 1.0D0
            enddo
         enddo

         !  r=ra ͤͿ. 
         do k=-km,km
            do l=0,lm
               eq_work=0 ; eq_work(k,l)=1.0
               er_work=er_eq(eq_work)
               if ( mod(md(k),2) .eq. mod(lm,2) ) then
                  alu(k,lm,l) = er_work(k,jm)
               else
                  alu(k,lm-1,l) = er_work(k,jm)
               endif
            enddo
         enddo

         call ludecomp(alu,kp)
      endif

      eq_work = eq
      do k=-km,km
         if ( mod(md(k),2) .eq. mod(lm,2) ) then
            eq_work(k,lm)   = value1(k)
         else
            eq_work(k,lm-1) = value1(k)
         endif
      enddo
      eq_LaplaInv_eq = lusolve(alu,kp,eq_work)

    end function eq_LaplaInv_eq

    function eq_Vor2Strm_eq(eq,value,cond,new)
      !
      ! ٤ή. 
      !
      ! Chebyshev-tau ˡˤ׻
      !  \zeta Ϳή \psi .
      !    \nabla^2 \psi = \zeta, 
      !    \psi = const. at the boundary
      ! Ǵ
      !    \DP{\psi}{r} = 0 at the boundary
      ! Ϥʤ
      !    r\DP{}{r}(1/r\DP{\psi}{r})  = 0 at the boundary
      !
      ! l=0,lm ʬμ˶Ϳ. 
      !
      real(8), dimension(-km:km,0:lm),intent(in)  :: eq
              !(in) ϱʬ

      real(8), dimension(-km:km,0:lm)             :: eq_Vor2Strm_eq
              !(out) ήؿʬ

      real(8), intent(in), optional               :: value
              ! ή. ǰʤΤȿ 0 ʬΤ

      character(len=1), intent(in), optional  :: cond
              !(in) 凉å. ά 'R'
              !     R    : ¦Ǵ
              !     F    : ¦Ϥʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu, alub
      integer, dimension(:,:), allocatable    :: kp, kpb

      real(8), dimension(-km:km,0:lm)         :: eq_work
      real(8), dimension(-km:km,jm)           :: er_work
      real(8)                                 :: value1          ! 
      logical                                 :: rigid

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: k, l, ll
      save    :: alu, kp, first
      save    :: alub, kpb

      if (.not. present(value)) then
         value1=0
      else
         value1 = value
      endif

      if (.not. present(cond)) then
         rigid=.TRUE. 
      else
         select case (cond)
         case ('R')
            rigid = .TRUE.
         case ('F')
            rigid = .FALSE.
         case default
            call MessageNotify('E','eq_Vor2Strm_eq','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu(-km:km,0:lm,0:lm),kp(-km:km,0:lm))

         if ( allocated(alub) ) deallocate(alub)
         if ( allocated(kpb) ) deallocate(kpb)
         allocate(alub(-km:km,0:lm,0:lm),kpb(-km:km,0:lm))

         ! 
         do l=0,lm
            eq_work = 0.0 ; eq_work(:,l) = 1.0
            alu(:,:,l) = eq_er(er_Lapla_eq(eq_work))
         enddo

         ! 0 ʬΤȤ 1 .
         do k=-km,km
            do l=0,md(k)-1
               alu(k,l,l) = 1.0D0
            enddo
            do l=md(k)+1,lm,2
               alu(k,l,l) = 1.0D0
            enddo
         enddo
         
         ! alu(:,:,nd(k))  0 ʤΤ 1 򤤤Ƥ. 
         ! l=md(k) ʬ϶Ƿ. 
         do k=-km,km
            if ( mod(md(k),2) .eq. mod(lm,2) ) then
               alu(k,lm,md(k)) = 1.0D0
            else
               alu(k,lm-1,md(k)) = 1.0D0
            endif
         enddo

         call ludecomp(alu,kp)

         !---- ׻ѹ -----
         alub = 0.0
         do l=0,lm
            alub(:,l,l) = 1.0D0
         enddo

         ! ưŪ. ή϶ǰ
         !     l=nd(n) ʬ򶭳Ƿ. 
         do l=0,lm
            eq_work = 0.0 ; eq_work(:,l)=1.0D0
            er_work = er_eq(eq_work)
            do k=-km,km
               alub(k,md(k),l) = er_work(k,jm)
            enddo
         enddo

         ! ϳŪǴ 
         !     l=lm or lm-1 ʬ򶭳Ƿ. 
         if ( rigid ) then
            do l=0,lm
               eq_work = 0.0 ;  eq_work(:,l)=1.0D0
               er_work=er_eq(eq_RadDRad_eq(eq_work))/er_Rad
               do k=-km,km
                  if ( mod(md(k),2) .eq. mod(lm,2) ) then
                     alub(k,lm,l) = er_work(k,jm)
                  else
                     alub(k,lm-1,l) = er_work(k,jm)
                  endif
               end do
            enddo
         else
            do l=0,lm
               eq_work = 0.0 ; eq_work(:,l)=1.0D0
               er_work=er_eq(eq_RadDRad_eq(eq_RadDRad_eq(eq_work)) &
                            -2*eq_RadDRad_eq(eq_work))/er_Rad**2
               do k=-km,km
                  if ( mod(md(k),2) .eq. mod(lm,2) ) then
                     alub(k,lm,l) = er_work(k,jm)
                  else
                     alub(k,lm-1,l) = er_work(k,jm)
                  endif
               end do
            enddo
         endif

         call ludecomp(alub,kpb)

         if ( rigid ) then
            call MessageNotify('M','eq_Vor2Strm_eq',&
                              'Matrix to apply rigid b.c. newly produced.')
         else
            call MessageNotify('M','eq_Vor2Strm_eq',&
                              'Matrix to apply stress-free b.c. newly produced.')
         endif
      endif

      ! ΰ׻
      eq_work = eq

      eq_work = lusolve(alu,kp,eq_work)

      ! ׻
      do k=-km,km
         eq_work(k,md(k)) = 0
         if ( mod(md(k),2) .eq. mod(lm,2) ) then
            eq_work(k,lm)   = 0
         else
            eq_work(k,lm-1) = 0
         endif
      enddo
      eq_work(0,0)   = value1*2     ! ưŪ. ȿ 0 ϽŤ 1/2

      eq_Vor2Strm_eq = lusolve(alub,kpb,eq_work)

    end function eq_Vor2Strm_eq

  !--------------- ʬ׻ -----------------
    function IntRadPhi_rp(rp)
      !
      ! 2 ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ p_Phi_Weight, r_Rad_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in)  2 ʻǡ

      real(8)                         :: IntRadPhi_rp
      !(out) ʬ

      integer :: i, j

      IntRadPhi_rp = 0.0d0
      do i=0,im-1
         do j=1,jm
            IntRadPhi_rp = IntRadPhi_rp + rp(j,i) * r_Rad_Weight(j) * p_Phi_Weight(i)
         enddo
      enddo
    end function IntRadPhi_rp

    function r_IntPhi_rp(rp)
      !
      ! 2 ʻǡ Phi ʬ
      !
      ! ºݤˤϳʻǡ p_Phi_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in) 2 ʻǡ

      real(8), dimension(jm)          :: r_IntPhi_rp
      !(out) ʬ줿 1 (Rad)ʻǡ

      integer :: i
      ! ѿ

      r_IntPhi_rp = 0.0d0
      do i=0,im-1
         r_IntPhi_rp(:) = r_IntPhi_rp(:) + rp(:,i) * p_Phi_Weight(i)
      enddo
    end function r_IntPhi_rp

    function p_IntRad_rp(rp)
      !
      ! 2 ʻǡ Rad ʬ
      !
      ! ºݤˤϳʻǡ r_Rad_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in)  2 ʻǡ

      real(8), dimension(0:im-1)      :: p_IntRad_rp
      !(out) ʬ줿 1 (Phi)ʻǡ

      integer :: j
      ! ѿ

      p_IntRad_rp = 0.0d0
      do j=1,jm
         p_IntRad_rp(:) = p_IntRad_rp(:) + rp(j,:) * r_Rad_Weight(j)
      enddo
    end function p_IntRad_rp

    function IntPhi_p(p)
      !
      ! 1 (Phi)ʻǡ Phi ʬ
      !
      ! ºݤˤϳʻǡ p_Phi_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1)   :: p         !(in)  1 ʻǡ
      real(8)                      :: IntPhi_p    !(out) ʬ

      IntPhi_p = sum(p*p_Phi_Weight)
    end function IntPhi_p

    function IntRad_r(r) 
      !
      ! 1 (Rad)ʻǡ Rad ʬ
      !
      ! ºݤˤϳʻǡ r_Rad_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(jm)   :: r          !(in)  1 ʻǡ
      real(8)                  :: IntRad_r     !(out) ʬ

      IntRad_r = sum(r*r_Rad_Weight)
    end function IntRad_r

  !--------------- ʿѷ׻ -----------------
    function AvrRadPhi_rp(rp)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ p_Phi_Weight, r_Rad_Weight 򤫤
      ! ¤׻, p_Phi_Weight*r_Rad_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in)  2 ʻǡ

      real(8)                         :: AvrRadPhi_rp
      !(out) ʿ

      AvrRadPhi_rp = IntRadPhi_rp(rp)/(sum(p_Phi_weight)*sum(r_Rad_weight))
    end function AvrRadPhi_rp

    function r_AvrPhi_rp(rp)
      !
      ! 2 ʻǡ Phi ʿ
      !
      ! ºݤˤϳʻǡ p_Phi_Weight 򤫤¤׻, 
      ! p_Phi_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in) 2 ʻǡ

      real(8), dimension(jm)          :: r_AvrPhi_rp
      !(out) ʿѤ줿 1 (Rad)ʻ

      r_AvrPhi_rp = r_IntPhi_rp(rp)/sum(p_Phi_weight)
    end function r_AvrPhi_rp

    function p_AvrRad_rp(rp)
      !
      ! 2 ʻǡ Rad ʿ
      !
      ! ºݤˤϳʻǡ r_Rad_Weight 򤫤¤׻, 
      ! r_Rad_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(jm,0:im-1)   :: rp
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)      :: p_AvrRad_rp
      !(out) ʿѤ줿 1 (Phi)ʻ

      p_AvrRad_rp = p_IntRad_rp(rp)/sum(r_Rad_weight)
    end function p_AvrRad_rp

    function AvrPhi_p(p)
      !
      ! 1 (Phi)ʻǡ Phi ʿ
      !
      ! ºݤˤϳʻǡ p_Phi_Weight 򤫤¤׻, 
      ! p_Phi_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1)   :: p          !(in)  1 ʻǡ
      real(8)                      :: AvrPhi_p     !(out) ʿ

      AvrPhi_p = IntPhi_p(p)/sum(p_Phi_weight)
    end function AvrPhi_p

    function AvrRad_r(r)
      !
      ! 1 (Rad)ʻǡ Rad ʿ
      !
      ! ºݤˤϳʻǡ r_Rad_Weight 򤫤¤׻, 
      ! r_Rad_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(jm)   :: r            !(in)  1 ʻǡ
      real(8)                  :: AvrRad_r     !(out) ʿ

      AvrRad_r = IntRad_r(r)/sum(r_Rad_weight)
    end function AvrRad_r

end module eq_module
